/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http;

import clojure.lang.ISeq;
import clojure.lang.Seqable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.channels.SelectableChannel;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.HttpStatus;

public class HttpUtils {
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("utf8");
    public static final String CHARSET = "charset=";
    public static final byte COLON = 58;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final int MAX_LINE = 2048;
    public static final int BUFFER_SIZE = 65536;
    public static final int SELECT_TIMEOUT = 3000;
    public static final int TIMEOUT_CHECK_INTEVAL = 3000;
    public static final String USER_AGENT = "User-Agent";
    public static final String ACCEPT = "Accept";
    public static final String ETAG = "ETag";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CHUNKED = "chunked";
    public static final String HOST = "Host";
    public static final String CONNECTION = "Connection";
    public static final String LOCATION = "Location";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final byte SP = 32;

    public static void closeQuiety(SelectableChannel c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static DynamicBytes encodeResponseHeader(int status, Map<String, Object> headers) {
        DynamicBytes bytes = new DynamicBytes(196);
        byte[] bs = HttpStatus.valueOf(status).getResponseIntialLineBytes();
        bytes.append(bs, 0, bs.length);
        for (Map.Entry<String, Object> e : headers.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            if (v instanceof String) {
                bytes.append(k);
                bytes.append((byte)58);
                bytes.append((byte)32);
                bytes.append((String)v, UTF_8);
                bytes.append((byte)13);
                bytes.append((byte)10);
                continue;
            }
            if (!(v instanceof Seqable)) continue;
            for (ISeq seq = ((Seqable)v).seq(); seq != null; seq = seq.next()) {
                bytes.append(k);
                bytes.append((byte)58);
                bytes.append((byte)32);
                bytes.append(seq.first().toString(), UTF_8);
                bytes.append((byte)13);
                bytes.append((byte)10);
            }
        }
        bytes.append((byte)13);
        bytes.append((byte)10);
        return bytes;
    }

    public static int findEndOfString(String sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    public static int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    public static int findWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    public static int getChunkSize(String hex) {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        return Integer.parseInt(hex, 16);
    }

    public static String getPath(URI uri) {
        String path = uri.getPath();
        String query = uri.getRawQuery();
        if ("".equals(path)) {
            path = "/";
        }
        if (query == null) {
            return path;
        }
        return path + "?" + query;
    }

    public static int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = "https".equals(uri.getScheme()) ? 443 : 80;
        }
        return port;
    }

    public static InetSocketAddress getServerAddr(URI uri) throws UnknownHostException {
        InetAddress host = InetAddress.getByName(uri.getHost());
        return new InetSocketAddress(host, HttpUtils.getPort(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAll(File f) throws IOException {
        int length = (int)f.length();
        byte[] bytes = new byte[length];
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            for (int offset = 0; offset < length; offset += fs.read(bytes, offset, length - offset)) {
            }
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception ignore) {}
            }
        }
        return bytes;
    }

    public static DynamicBytes readAll(InputStream is) throws IOException {
        int read;
        DynamicBytes bytes = new DynamicBytes(1024);
        byte[] buffer = new byte[4096];
        while ((read = is.read(buffer)) != -1) {
            bytes.append(buffer, 0, read);
        }
        is.close();
        return bytes;
    }

    public static final void printError(String msg, Throwable t) {
        String error = String.format("%s [%s] ERROR - %s", new Date(), Thread.currentThread().getName(), msg);
        StringWriter str = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)str, false);
        pw.println(error);
        t.printStackTrace(pw);
        System.err.print(str.getBuffer().toString());
    }

    public static void splitAndAddHeader(String sb, Map<String, String> headers) {
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = HttpUtils.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        int valueStart = HttpUtils.findNonWhitespace(sb, colonEnd);
        int valueEnd = HttpUtils.findEndOfString(sb);
        String key = sb.substring(nameStart, nameEnd);
        if (valueStart <= valueEnd) {
            String value = sb.substring(valueStart, valueEnd);
            headers.put(key, value);
        }
    }
}

