/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import java.io.IOException;
import java.io.InputStream;

public class BytesInputStream
extends InputStream {
    private final byte[] buf;
    private final int count;
    protected int mark = 0;
    private int pos;

    public BytesInputStream(byte[] data, int offset, int length) {
        this.buf = data;
        this.count = length;
        this.pos = offset;
    }

    public int read() throws IOException {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pos >= this.count) {
            return -1;
        }
        int avail = this.count - this.pos;
        if (len > avail) {
            len = avail;
        }
        System.arraycopy(this.buf, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    public String toString() {
        return "BytesInputStream[len=" + this.count + "]";
    }

    public long skip(long n) throws IOException {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + k);
        return k;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }
}

