/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.ssl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import me.shenfeng.ssl.SslContextFactory;
import org.junit.Test;

public class SSLTest {
    void doHandshake(SocketChannel socketChannel, SSLEngine engine, ByteBuffer myNetData, ByteBuffer peerNetData) throws Exception {
        int appBufferSize = engine.getSession().getApplicationBufferSize();
        ByteBuffer myAppData = ByteBuffer.allocate(appBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(appBufferSize);
        engine.beginHandshake();
        SSLEngineResult.HandshakeStatus hs = engine.getHandshakeStatus();
        block10: while (hs != SSLEngineResult.HandshakeStatus.FINISHED && hs != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            switch (hs) {
                case NEED_UNWRAP: {
                    socketChannel.read(peerNetData);
                    peerNetData.flip();
                    SSLEngineResult res = engine.unwrap(peerNetData, peerAppData);
                    peerNetData.compact();
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        default: 
                    }
                    break;
                }
                case NEED_WRAP: {
                    myNetData.clear();
                    SSLEngineResult res = engine.wrap(myAppData, myNetData);
                    hs = res.getHandshakeStatus();
                    switch (res.getStatus()) {
                        case OK: {
                            myNetData.flip();
                            while (myNetData.hasRemaining()) {
                                socketChannel.write(myNetData);
                            }
                            continue block10;
                        }
                    }
                    break;
                }
                case NEED_TASK: {
                    Runnable task = engine.getDelegatedTask();
                    if (task == null) break;
                    new Thread(task).run();
                }
            }
        }
    }

    @Test
    public void testSSL() throws Exception {
        System.setProperty("javax.net.debug", "all");
        SSLEngine engine = SslContextFactory.getClientContext().createSSLEngine();
        engine.setUseClientMode(true);
        SSLSession session = engine.getSession();
        int applicationBufferSize = session.getApplicationBufferSize();
        int packetBufferSize = session.getPacketBufferSize();
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress("173.230.145.92", 443));
        while (!socketChannel.finishConnect()) {
        }
        ByteBuffer appData = ByteBuffer.allocate(applicationBufferSize);
        ByteBuffer netData = ByteBuffer.allocate(packetBufferSize);
        ByteBuffer peerAppData = ByteBuffer.allocate(applicationBufferSize);
        ByteBuffer peerNetData = ByteBuffer.allocate(packetBufferSize);
        this.doHandshake(socketChannel, engine, netData, peerNetData);
        appData.put("GET / HTTP/1/1\r\nHost: mei.fm\r\r\r\n".getBytes());
        appData.flip();
        while (appData.hasRemaining()) {
            SSLEngineResult res = engine.wrap(appData, netData);
            if (res.getStatus() != SSLEngineResult.Status.OK) continue;
            appData.compact();
            while (netData.hasRemaining()) {
                int num = socketChannel.write(netData);
                System.out.println(num);
            }
        }
        int num = socketChannel.read(peerNetData);
        if (num != -1 && num != 0) {
            peerNetData.flip();
            SSLEngineResult res = engine.unwrap(peerNetData, peerAppData);
            if (res.getStatus() == SSLEngineResult.Status.OK) {
                peerNetData.compact();
                if (peerAppData.hasRemaining()) {
                    System.out.println(peerAppData);
                }
            }
        }
    }
}

