/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;
import me.shenfeng.http.SelectAttachment;

public class PerformanceBench {
    static final boolean DEBUG = false;
    static final byte CR = 13;
    static final byte LF = 10;
    static final String CL = "content-length: ";
    static final int concurrency = 100;
    static final int total = 2000000;
    static int remaining = 2000000;
    static long totalByteReceive = 0L;
    static InetSocketAddress addr = new InetSocketAddress("127.0.0.1", 9091);
    static ByteBuffer readBuffer = ByteBuffer.allocateDirect(65536);
    static long start = System.currentTimeMillis();

    /*
     * Enabled aggressive block sorting
     */
    public static String readLine(ByteBuffer buffer) {
        StringBuilder sb = new StringBuilder(64);
        while (true) {
            char b = (char)buffer.get();
            switch (b) {
                case '\r': {
                    if (buffer.get() != 10) break;
                    return sb.toString();
                }
                case '\n': {
                    return sb.toString();
                }
            }
            sb.append(b);
        }
    }

    private static void D(String mesg) {
    }

    public static void main(String[] args) throws IOException {
        System.out.println("concurrency: 100; total requests: 2000000");
        Selector selector = Selector.open();
        int i = 0;
        while (i < 100) {
            PerformanceBench.connect(addr, selector);
            ++i;
        }
        while (true) {
            int select = selector.select();
            PerformanceBench.D("selec return " + select);
            if (select <= 0) continue;
            Set<SelectionKey> selectedKeys = selector.selectedKeys();
            for (SelectionKey key : selectedKeys) {
                if (key.isConnectable()) {
                    SocketChannel ch = (SocketChannel)key.channel();
                    try {
                        if (!ch.finishConnect()) continue;
                        key.interestOps(4);
                    }
                    catch (Exception e) {
                        ch.close();
                        e.printStackTrace();
                        PerformanceBench.D(String.valueOf(e.getMessage()) + "\t" + "close and reconnect");
                        PerformanceBench.connect(addr, selector);
                    }
                    continue;
                }
                if (key.isWritable()) {
                    PerformanceBench.doWrite(key);
                    continue;
                }
                if (!key.isReadable()) continue;
                PerformanceBench.doRead(selector, key);
            }
            selectedKeys.clear();
        }
    }

    private static void doWrite(SelectionKey key) throws IOException {
        SocketChannel ch = (SocketChannel)key.channel();
        SelectAttachment att = (SelectAttachment)key.attachment();
        ByteBuffer buffer = att.request;
        ch.write(buffer);
        if (!buffer.hasRemaining()) {
            key.interestOps(1);
        }
    }

    private static void doRead(Selector selector, SelectionKey key) throws IOException, SocketException, ClosedChannelException {
        SocketChannel ch = (SocketChannel)key.channel();
        SelectAttachment att = (SelectAttachment)key.attachment();
        readBuffer.clear();
        while (true) {
            int read;
            if ((read = ch.read(readBuffer)) == -1) {
                ch.close();
                PerformanceBench.decAndPrint();
                PerformanceBench.D("remote closed, connecton new, remaining: " + remaining);
                PerformanceBench.connect(addr, selector);
                break;
            }
            if (read == 0) {
                PerformanceBench.D("read zero");
                break;
            }
            totalByteReceive += (long)read;
            if (att.response_length == -1) {
                readBuffer.flip();
                String line = PerformanceBench.readLine(readBuffer);
                while (line.length() > 0) {
                    if ((line = line.toLowerCase()).startsWith(CL)) {
                        String length = line.substring(CL.length());
                        att.response_cnt = att.response_length = Integer.valueOf(length).intValue();
                    }
                    line = PerformanceBench.readLine(readBuffer);
                }
                att.response_cnt -= readBuffer.remaining();
            } else {
                att.response_cnt -= read;
            }
            if (att.response_cnt != 0) continue;
            PerformanceBench.D("read all");
            PerformanceBench.decAndPrint();
            key.attach(SelectAttachment.next());
            key.interestOps(4);
        }
    }

    private static void decAndPrint() {
        if (--remaining % 200000 == 0) {
            System.out.println("remaining\t" + remaining);
        }
        if (remaining == 0) {
            long time = System.currentTimeMillis() - start;
            double receiveM = (double)totalByteReceive / 1024.0 / 1024.0;
            double reqs = 2000000.0 / (double)time * 1000.0;
            double ms = receiveM / (double)time * 1000.0;
            System.out.printf("concurrency: %d; requests: %d; time: %dms; req/s: %.2f; receive bytes: %.2fM data; throughput: %.2f M/s\n", 100, 2000000, time, reqs, receiveM, ms);
            System.exit(0);
        }
    }

    private static void connect(InetSocketAddress addr, Selector selector) throws IOException, SocketException, ClosedChannelException {
        SocketChannel ch = SocketChannel.open();
        ch.socket().setReuseAddress(true);
        ch.configureBlocking(false);
        ch.register(selector, 8, SelectAttachment.next());
        ch.connect(addr);
    }
}

