/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import me.shenfeng.http.HttpMethod;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.LineTooLargeException;
import me.shenfeng.http.ProtocolException;
import me.shenfeng.http.RequestTooLargeException;
import me.shenfeng.http.server.HttpRequest;

public class RequestDecoder {
    HttpRequest request;
    int readRemaining = 0;
    byte[] content;
    int readCount = 0;
    private Map<String, String> headers = new TreeMap<String, String>();
    private final int maxBody;
    private State state = State.READ_INITIAL;
    int lineBufferIdx = 0;
    private final byte[] lineBuffer;

    public RequestDecoder(int maxBody, int maxLine) {
        this.maxBody = maxBody;
        this.lineBuffer = new byte[maxLine];
    }

    private void createRequest(String sb) throws ProtocolException {
        HttpVersion version;
        HttpMethod method;
        int cEnd;
        int aStart = HttpUtils.findNonWhitespace(sb, 0);
        int aEnd = HttpUtils.findWhitespace(sb, aStart);
        int bStart = HttpUtils.findNonWhitespace(sb, aEnd);
        int bEnd = HttpUtils.findWhitespace(sb, bStart);
        int cStart = HttpUtils.findNonWhitespace(sb, bEnd);
        if (cStart < (cEnd = HttpUtils.findEndOfString(sb))) {
            method = HttpMethod.GET;
            String m = sb.substring(aStart, aEnd).toUpperCase();
            if (m.equals("GET")) {
                method = HttpMethod.GET;
            } else if (m.equals("POST")) {
                method = HttpMethod.POST;
            } else if (m.equals("PUT")) {
                method = HttpMethod.PUT;
            } else if (m.equals("DELETE")) {
                method = HttpMethod.DELETE;
            }
            version = HttpVersion.HTTP_1_1;
            if ("HTTP/1.0".equals(sb.substring(cStart, cEnd))) {
                version = HttpVersion.HTTP_1_0;
            }
        } else {
            throw new ProtocolException("not http?");
        }
        this.request = new HttpRequest(method, sb.substring(bStart, bEnd), version);
    }

    public State decode(ByteBuffer buffer) throws LineTooLargeException, ProtocolException, RequestTooLargeException {
        while (buffer.hasRemaining() && this.state != State.ALL_READ) {
            switch (this.state) {
                case READ_INITIAL: {
                    String line = this.readLine(buffer);
                    if (line == null) break;
                    this.createRequest(line);
                    this.state = State.READ_HEADER;
                    break;
                }
                case READ_HEADER: {
                    this.readHeaders(buffer);
                    break;
                }
                case READ_CHUNK_SIZE: {
                    String line = this.readLine(buffer);
                    if (line == null) break;
                    this.readRemaining = HttpUtils.getChunkSize(line);
                    if (this.readRemaining == 0) {
                        this.state = State.READ_CHUNK_FOOTER;
                        break;
                    }
                    this.throwIfBodyIsTooLarge();
                    if (this.content == null) {
                        this.content = new byte[this.readRemaining];
                    } else if (this.content.length - this.readCount < this.readRemaining) {
                        this.content = Arrays.copyOf(this.content, this.readRemaining + this.readCount);
                    }
                    this.state = State.READ_CHUNKED_CONTENT;
                    break;
                }
                case READ_FIXED_LENGTH_CONTENT: {
                    this.readFixedLength(buffer);
                    if (this.readRemaining != 0) break;
                    this.finish();
                    break;
                }
                case READ_CHUNKED_CONTENT: {
                    this.readFixedLength(buffer);
                    if (this.readRemaining != 0) break;
                    this.state = State.READ_CHUNK_DELIMITER;
                    break;
                }
                case READ_CHUNK_FOOTER: {
                    this.readEmptyLine(buffer);
                    this.finish();
                    break;
                }
                case READ_CHUNK_DELIMITER: {
                    this.readEmptyLine(buffer);
                    this.state = State.READ_CHUNK_SIZE;
                }
            }
        }
        return this.state;
    }

    private void finish() {
        this.state = State.ALL_READ;
        this.request.setBody(this.content, this.readCount);
    }

    void readEmptyLine(ByteBuffer buffer) {
        byte b = buffer.get();
        if (b == 13) {
            buffer.get();
        }
    }

    void readFixedLength(ByteBuffer buffer) {
        int toRead = Math.min(buffer.remaining(), this.readRemaining);
        buffer.get(this.content, this.readCount, toRead);
        this.readRemaining -= toRead;
        this.readCount += toRead;
    }

    private void readHeaders(ByteBuffer buffer) throws LineTooLargeException, RequestTooLargeException, ProtocolException {
        String line = this.readLine(buffer);
        while (line != null && !line.isEmpty()) {
            HttpUtils.splitAndAddHeader(line, this.headers);
            line = this.readLine(buffer);
        }
        if (line == null) {
            return;
        }
        this.request.setHeaders(this.headers);
        String te = this.headers.get("Transfer-Encoding");
        if ("chunked".equals(te)) {
            this.state = State.READ_CHUNK_SIZE;
        } else {
            String cl = this.headers.get("Content-Length");
            if (cl != null) {
                try {
                    this.readRemaining = Integer.parseInt(cl);
                    if (this.readRemaining > 0) {
                        this.throwIfBodyIsTooLarge();
                        this.content = new byte[this.readRemaining];
                        this.state = State.READ_FIXED_LENGTH_CONTENT;
                    }
                    this.state = State.ALL_READ;
                }
                catch (NumberFormatException e) {
                    throw new ProtocolException(e.getMessage());
                }
            } else {
                this.state = State.ALL_READ;
            }
        }
    }

    String readLine(ByteBuffer buffer) throws LineTooLargeException {
        boolean more = true;
        while (buffer.hasRemaining() && more) {
            byte b = buffer.get();
            if (b == 13) {
                if (buffer.get() != 10) continue;
                more = false;
                continue;
            }
            if (b == 10) {
                more = false;
                continue;
            }
            if (this.lineBufferIdx == this.lineBuffer.length - 2) {
                throw new LineTooLargeException("line length exceed " + this.lineBuffer.length);
            }
            this.lineBuffer[this.lineBufferIdx] = b;
            ++this.lineBufferIdx;
        }
        String line = null;
        if (!more) {
            line = new String(this.lineBuffer, 0, this.lineBufferIdx);
            this.lineBufferIdx = 0;
        }
        return line;
    }

    public void reset() {
        this.state = State.READ_INITIAL;
        this.headers = new TreeMap<String, String>();
        this.readCount = 0;
        this.content = null;
    }

    private void throwIfBodyIsTooLarge() throws RequestTooLargeException {
        if (this.readCount + this.readRemaining > this.maxBody) {
            throw new RequestTooLargeException("request body " + (this.readCount + this.readRemaining) + "; max request body " + this.maxBody);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ALL_READ,
        READ_INITIAL,
        READ_HEADER,
        READ_FIXED_LENGTH_CONTENT,
        READ_CHUNK_SIZE,
        READ_CHUNKED_CONTENT,
        READ_CHUNK_FOOTER,
        READ_CHUNK_DELIMITER;

    }
}

