/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.HTTPException;
import me.shenfeng.http.HttpMethod;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.ProtocolException;
import me.shenfeng.http.client.HttpClientConfig;
import me.shenfeng.http.client.IRespListener;
import me.shenfeng.http.client.PersistentConn;
import me.shenfeng.http.client.PriorityQueue;
import me.shenfeng.http.client.Request;
import me.shenfeng.http.client.State;
import me.shenfeng.http.client.TimeoutException;

public final class HttpClient
implements Runnable {
    private static final AtomicInteger ID = new AtomicInteger(0);
    private final Queue<Request> pendings = new ConcurrentLinkedQueue<Request>();
    private final PriorityQueue<Request> requests = new PriorityQueue();
    private final PriorityQueue<PersistentConn> keepalives = new PriorityQueue();
    private volatile boolean running = true;
    private final HttpClientConfig config;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(65536);
    private final Selector selector;

    public HttpClient(HttpClientConfig config) throws IOException {
        this.config = config;
        int id = ID.incrementAndGet();
        String name = "http-client";
        if (id > 1) {
            name = name + "#" + id;
        }
        this.selector = Selector.open();
        Thread t = new Thread((Runnable)this, name);
        t.setDaemon(true);
        t.start();
    }

    private void clearTimeouted(long now) {
        PersistentConn pc;
        Request r;
        while ((r = this.requests.peek()) != null && r.isTimeout(now)) {
            String msg = r.connected() ? "read timeout: " : "connect timeout: ";
            r.finish(new TimeoutException(msg + r.timeOutMs + "ms"));
            if (r.key == null) continue;
            this.closeQuitely(r.key);
        }
        while ((pc = this.keepalives.peek()) != null && pc.isTimeout(now)) {
            this.closeQuitely(pc.key);
            this.keepalives.poll();
        }
    }

    private void doRead(SelectionKey key, long now) {
        Request req = (Request)key.attachment();
        SocketChannel ch = (SocketChannel)key.channel();
        this.buffer.clear();
        int read = 0;
        try {
            read = ch.read(this.buffer);
        }
        catch (IOException e) {
            this.closeQuitely(key);
            req.finish(e);
        }
        if (read == -1) {
            this.keepalives.remove(key);
            this.closeQuitely(key);
            req.finish();
        } else if (read > 0) {
            req.onProgress(now);
            this.buffer.flip();
            try {
                if (req.decoder.decode(this.buffer) == State.ALL_READ) {
                    req.finish();
                    this.keepalives.offer(new PersistentConn(now + (long)this.config.keepalive, req.addr, key));
                }
            }
            catch (HTTPException e) {
                this.closeQuitely(key);
                req.finish(e);
            }
            catch (Exception e) {
                this.closeQuitely(key);
                req.finish();
                HttpUtils.printError("Should not happend!!", e);
            }
        }
    }

    private void closeQuitely(SelectionKey key) {
        try {
            key.channel().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doWrite(SelectionKey key) {
        Request req = (Request)key.attachment();
        SocketChannel ch = (SocketChannel)key.channel();
        try {
            ByteBuffer request = req.request;
            ch.write(request);
            if (!request.hasRemaining()) {
                key.interestOps(1);
            }
        }
        catch (IOException e) {
            this.closeQuitely(key);
            req.finish(e);
        }
    }

    public void exec(String url, HttpMethod method, Map<String, String> headers, byte[] body, int timeoutMs, IRespListener cb) {
        URI uri = null;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            cb.onThrowable(e);
            return;
        }
        if (!"http".equals(uri.getScheme())) {
            cb.onThrowable(new ProtocolException(uri.getScheme() + " is not supported"));
            return;
        }
        TreeMap<String, String> tmp = new TreeMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                tmp.put(HttpUtils.camelCase(e.getKey()), e.getValue());
            }
        }
        headers = tmp;
        headers.put("Host", HttpUtils.getHost(uri));
        headers.put("Accept", "*/*");
        if (!headers.containsKey("User-Agent")) {
            headers.put("User-Agent", this.config.userAgent);
        }
        if (!headers.containsKey("Accept-Encoding")) {
            headers.put("Accept-Encoding", "gzip, deflate");
        }
        int length = 64 + headers.size() * 48;
        if (body != null) {
            headers.put("Content-Length", Integer.toString(body.length));
            length += body.length;
        }
        DynamicBytes path = HttpUtils.encodeURI(HttpUtils.getPath(uri));
        DynamicBytes bytes = new DynamicBytes(length);
        bytes.append(method.toString()).append((byte)32).append(path.get(), 0, path.length());
        bytes.append(" HTTP/1.1\r\n");
        for (Map.Entry<String, String> e : headers.entrySet()) {
            if (e.getValue() == null) continue;
            bytes.append(e.getKey()).append((byte)58).append((byte)32).append(e.getValue());
            bytes.append((byte)13).append((byte)10);
        }
        bytes.append((byte)13).append((byte)10);
        if (body != null) {
            bytes.append(body, 0, body.length);
        }
        ByteBuffer request = ByteBuffer.wrap(bytes.get(), 0, bytes.length());
        if (timeoutMs == -1) {
            timeoutMs = this.config.timeOutMs;
        }
        try {
            InetSocketAddress addr = HttpUtils.getServerAddr(uri);
            this.pendings.offer(new Request(addr, request, cb, this.requests, timeoutMs, method));
            this.selector.wakeup();
        }
        catch (UnknownHostException e) {
            cb.onThrowable(e);
        }
    }

    private void finishConnect(SelectionKey key, long now) {
        SocketChannel ch = (SocketChannel)key.channel();
        Request req = (Request)key.attachment();
        try {
            if (ch.finishConnect()) {
                req.setConnected();
                req.onProgress(now);
                key.interestOps(4);
            }
        }
        catch (IOException e) {
            this.closeQuitely(key);
            req.finish(e);
        }
    }

    private void processPendings(long currentTime) {
        Request job = null;
        while ((job = this.pendings.poll()) != null) {
            PersistentConn con = this.keepalives.remove(job.addr);
            if (con != null) {
                SelectionKey key = con.key;
                if (key.isValid()) {
                    key.attach(job);
                    key.interestOps(4);
                    this.requests.offer(job);
                    continue;
                }
                this.closeQuitely(key);
            }
            try {
                SocketChannel ch = SocketChannel.open();
                ch.configureBlocking(false);
                job.key = ch.register(this.selector, 8, job);
                ch.connect(job.addr);
                this.requests.offer(job);
            }
            catch (IOException e) {
                job.finish(e);
                HttpUtils.printError("Try to connect " + job.addr, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                long now = System.currentTimeMillis();
                int select = this.selector.select(2000L);
                if (select > 0) {
                    Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> ite = selectedKeys.iterator();
                    while (ite.hasNext()) {
                        SelectionKey key = ite.next();
                        if (!key.isValid()) continue;
                        try {
                            if (key.isConnectable()) {
                                this.finishConnect(key, now);
                                continue;
                            }
                            if (key.isWritable()) {
                                this.doWrite(key);
                                continue;
                            }
                            if (!key.isReadable()) continue;
                            this.doRead(key, now);
                        }
                        catch (Exception e) {
                            ((Request)key.attachment()).finish(e);
                            this.closeQuitely(key);
                            HttpUtils.printError("Please catch this exception", e);
                        }
                        finally {
                            ite.remove();
                        }
                    }
                }
                this.clearTimeouted(now);
                this.processPendings(now);
            }
            catch (IOException e) {
                HttpUtils.printError("select exception", e);
            }
        }
    }

    public void stop() throws IOException {
        this.running = false;
        if (this.selector != null) {
            this.selector.close();
        }
    }

    public String toString() {
        return this.getClass().getCanonicalName() + this.config.toString();
    }
}

