/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.client;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import me.shenfeng.http.BytesInputStream;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.HttpStatus;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.ProtocolException;
import me.shenfeng.http.client.AbortException;
import me.shenfeng.http.client.IRespListener;
import me.shenfeng.http.client.IResponseHandler;

public class RespListener
implements IRespListener {
    static final Pattern ENCODING = Pattern.compile("encoding=('|\")([\\w|-]+)('|\")", 2);
    private final DynamicBytes body;
    private Map<String, String> headers = new TreeMap<String, String>();
    private HttpStatus status;
    private final IResponseHandler handler;
    private final IFilter filter;

    public static Charset parseCharset(String type) {
        if (type != null) {
            try {
                type = type.toLowerCase();
                int i = type.indexOf("charset=");
                if (i != -1) {
                    String charset = type.substring(i + "charset=".length()).trim();
                    return Charset.forName(charset);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Charset guess(String html, String patten) {
        int start;
        int end;
        int idx = html.indexOf(patten);
        if (idx != -1 && (end = html.indexOf(34, start = idx + patten.length())) != -1) {
            try {
                return Charset.forName(html.substring(start, end));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isText() {
        if (this.status == HttpStatus.OK) {
            String type = this.headers.get("content-type");
            if (type != null) {
                return (type = type.toLowerCase()).contains("text") || type.contains("json");
            }
            return false;
        }
        return true;
    }

    private DynamicBytes unzipBody() throws IOException {
        String encoding = this.headers.get("content-encoding");
        if (encoding != null && this.body.length() > 0) {
            int read;
            boolean zipped;
            encoding = encoding.toLowerCase();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.body.get(), 0, this.body.length());
            DynamicBytes unzipped = new DynamicBytes(this.body.length() * 6);
            boolean bl = zipped = "gzip".equals(encoding) || "x-gzip".equals(encoding);
            if (zipped) {
                this.headers.remove("content-encoding");
            }
            FilterInputStream is = zipped ? new GZIPInputStream(bis) : new DeflaterInputStream(bis);
            byte[] buffer = new byte[4096];
            while ((read = ((InputStream)is).read(buffer)) != -1) {
                unzipped.append(buffer, 0, read);
            }
            return unzipped;
        }
        return this.body;
    }

    public static Charset detectCharset(Map<String, String> headers, DynamicBytes body) {
        Matcher matcher;
        String s;
        Charset result = RespListener.parseCharset(headers.get("content-type"));
        if (result == null && (result = RespListener.guess(s = new String(body.get(), 0, Math.min(512, body.length()), HttpUtils.ASCII), "charset=")) == null && (matcher = ENCODING.matcher(s)).find()) {
            try {
                result = Charset.forName(matcher.group(2));
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return result == null ? HttpUtils.UTF_8 : result;
    }

    public RespListener(IResponseHandler handler, IFilter filter) {
        this.body = new DynamicBytes(16384);
        this.filter = filter;
        this.handler = handler;
    }

    public RespListener(IResponseHandler handler) {
        this(handler, IFilter.ACCEPT_ALL);
    }

    @Override
    public void onBodyReceived(byte[] buf, int length) throws AbortException {
        if (this.filter != null && !this.filter.accept(this.body)) {
            throw new AbortException("Regected when reading body, length: " + this.body.length());
        }
        this.body.append(buf, 0, length);
    }

    @Override
    public void onCompleted() {
        if (this.status == null) {
            this.handler.onThrowable(new ProtocolException("No status"));
            return;
        }
        try {
            DynamicBytes bytes = this.unzipBody();
            if (this.isText()) {
                Charset charset = RespListener.detectCharset(this.headers, this.body);
                String html = new String(bytes.get(), 0, bytes.length(), charset);
                this.handler.onSuccess(this.status.getCode(), this.headers, html);
            } else {
                BytesInputStream is = new BytesInputStream(bytes.get(), 0, bytes.length());
                this.handler.onSuccess(this.status.getCode(), this.headers, is);
            }
        }
        catch (IOException e) {
            this.handler.onThrowable(e);
        }
    }

    @Override
    public void onThrowable(Throwable t) {
        this.handler.onThrowable(t);
    }

    @Override
    public void onHeadersReceived(Map<String, String> headers) throws AbortException {
        this.headers = headers;
        if (this.filter != null && !this.filter.accept(headers)) {
            throw new AbortException("Rejected when header received");
        }
    }

    @Override
    public void onInitialLineReceived(HttpVersion version, HttpStatus status) throws AbortException {
        this.status = status;
    }

    public static interface IFilter {
        public static final IFilter ACCEPT_ALL = new IFilter(){

            @Override
            public boolean accept(DynamicBytes partialBody) {
                return true;
            }

            @Override
            public boolean accept(Map<String, String> headers) {
                return true;
            }

            public String toString() {
                return "Response Filter: ACCEPT all response";
            }
        };

        public boolean accept(Map<String, String> var1);

        public boolean accept(DynamicBytes var1);
    }
}

