/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import clojure.lang.IPersistentMap;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import clojure.lang.Seqable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.server.DateFormater;
import me.shenfeng.http.server.HttpRequest;

public class ClojureRing {
    public static final Keyword SERVER_PORT = Keyword.intern((String)"server-port");
    public static final Keyword SERVER_NAME = Keyword.intern((String)"server-name");
    public static final Keyword REMOTE_ADDR = Keyword.intern((String)"remote-addr");
    public static final Keyword URI = Keyword.intern((String)"uri");
    public static final Keyword QUERY_STRING = Keyword.intern((String)"query-string");
    public static final Keyword SCHEME = Keyword.intern((String)"scheme");
    public static final Keyword REQUEST_METHOD = Keyword.intern((String)"request-method");
    public static final Keyword HEADERS = Keyword.intern((String)"headers");
    public static final Keyword CONTENT_TYPE = Keyword.intern((String)"content-type");
    public static final Keyword CONTENT_LENGTH = Keyword.intern((String)"content-length");
    public static final Keyword CHARACTER_ENCODING = Keyword.intern((String)"character-encoding");
    public static final Keyword BODY = Keyword.intern((String)"body");
    public static final Keyword KEEP_ALIVE = Keyword.intern((String)"keep_alive");
    public static final Keyword WEBSOCKET = Keyword.intern((String)"websocket");
    public static final Keyword M_GET = Keyword.intern((String)"get");
    public static final Keyword M_POST = Keyword.intern((String)"post");
    public static final Keyword M_DELETE = Keyword.intern((String)"delete");
    public static final Keyword M_PUT = Keyword.intern((String)"put");
    public static final Keyword HTTP = Keyword.intern((String)"http");
    public static final Keyword STATUS = Keyword.intern((String)"status");
    public static final String CL = "Content-Length";

    public static final int getStatus(Map<Keyword, Object> resp) {
        int status = 200;
        Object s = resp.get(STATUS);
        if (s instanceof Long) {
            status = ((Long)s).intValue();
        } else if (s instanceof Integer) {
            status = (Integer)s;
        }
        return status;
    }

    public static ByteBuffer[] encode(int status, Map<String, Object> headers, Object body) {
        ByteBuffer headBuffer;
        ByteBuffer bodyBuffer;
        block8: {
            bodyBuffer = null;
            headBuffer = null;
            headers.put("Server", "http-kit");
            headers.put("Date", DateFormater.getDate());
            try {
                Object b;
                if (body == null) {
                    headers.put(CL, "0");
                    break block8;
                }
                if (body instanceof String) {
                    b = ((String)body).getBytes(HttpUtils.UTF_8);
                    bodyBuffer = ByteBuffer.wrap((byte[])b);
                    headers.put(CL, Integer.toString(((Object)b).length));
                    break block8;
                }
                if (body instanceof InputStream) {
                    b = HttpUtils.readAll((InputStream)body);
                    bodyBuffer = ByteBuffer.wrap(((DynamicBytes)b).get(), 0, ((DynamicBytes)b).length());
                    headers.put(CL, Integer.toString(((DynamicBytes)b).length()));
                    break block8;
                }
                if (body instanceof File) {
                    bodyBuffer = HttpUtils.readAll((File)body);
                    break block8;
                }
                if (body instanceof Seqable) {
                    ISeq seq;
                    DynamicBytes b2 = new DynamicBytes(seq.count() * 512);
                    for (seq = ((Seqable)body).seq(); seq != null; seq = seq.next()) {
                        b2.append(seq.first().toString(), HttpUtils.UTF_8);
                    }
                    bodyBuffer = ByteBuffer.wrap(b2.get(), 0, b2.length());
                    headers.put(CL, Integer.toString(b2.length()));
                    break block8;
                }
                throw new RuntimeException(body.getClass() + " is not understandable");
            }
            catch (IOException e) {
                byte[] b = e.getMessage().getBytes(HttpUtils.ASCII);
                status = 500;
                headers.clear();
                headers.put(CL, Integer.toString(b.length));
                bodyBuffer = ByteBuffer.wrap(b);
            }
        }
        DynamicBytes bytes = HttpUtils.encodeResponseHeader(status, headers);
        headBuffer = ByteBuffer.wrap(bytes.get(), 0, bytes.length());
        return new ByteBuffer[]{headBuffer, bodyBuffer};
    }

    public static IPersistentMap buildRequestMap(HttpRequest req) {
        TreeMap<Keyword, Object> m = new TreeMap<Keyword, Object>();
        m.put(SERVER_PORT, req.getServerPort());
        m.put(SERVER_NAME, req.getServerName());
        m.put(REMOTE_ADDR, req.getRemoteAddr());
        m.put(URI, req.uri);
        m.put(QUERY_STRING, req.queryString);
        m.put(SCHEME, HTTP);
        if (req.isWs()) {
            m.put(WEBSOCKET, req.getWebSocketCon());
        }
        switch (req.method) {
            case DELETE: {
                m.put(REQUEST_METHOD, M_DELETE);
                break;
            }
            case GET: {
                m.put(REQUEST_METHOD, M_GET);
                break;
            }
            case POST: {
                m.put(REQUEST_METHOD, M_POST);
                break;
            }
            case PUT: {
                m.put(REQUEST_METHOD, M_PUT);
            }
        }
        m.put(HEADERS, PersistentArrayMap.create(req.getHeaders()));
        m.put(CONTENT_TYPE, req.getContentType());
        m.put(CONTENT_LENGTH, req.getContentLength());
        m.put(CHARACTER_ENCODING, req.getCharactorEncoding());
        m.put(BODY, req.getBody());
        return PersistentArrayMap.create(m);
    }
}

