/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http.server;

import clojure.lang.IFn;
import java.util.Map;
import java.util.TreeMap;
import me.shenfeng.http.HttpUtils;
import me.shenfeng.http.HttpVersion;
import me.shenfeng.http.server.ClojureRing;
import me.shenfeng.http.server.HttpRequest;
import me.shenfeng.http.server.IListenableFuture;
import me.shenfeng.http.server.ResponseCallback;

class HttpHandler
implements Runnable {
    final HttpRequest req;
    final ResponseCallback cb;
    final IFn handler;

    public HttpHandler(HttpRequest req, ResponseCallback cb, IFn handler) {
        this.req = req;
        this.cb = cb;
        this.handler = handler;
    }

    private Map<String, Object> getHeaders(Map resp) {
        TreeMap<String, Object> headers = (TreeMap<String, Object>)resp.get(ClojureRing.HEADERS);
        headers = headers == null ? new TreeMap<String, Object>() : new TreeMap(headers);
        if (this.req.version == HttpVersion.HTTP_1_0 && this.req.isKeepAlive() && !headers.containsKey("Connection")) {
            headers.put("Connection", "Keep-Alive");
        }
        return headers;
    }

    private void asyncHandle(final ResponseCallback cb, final Map resp, final IListenableFuture future) {
        future.addListener(new Runnable(){

            @Override
            public void run() {
                Object r = future.get();
                if (r instanceof Map) {
                    Map resp2 = (Map)r;
                    cb.run(ClojureRing.encode(ClojureRing.getStatus(resp2), HttpHandler.this.getHeaders(resp2), resp2.get(ClojureRing.BODY)));
                } else {
                    cb.run(ClojureRing.encode(ClojureRing.getStatus(resp), HttpHandler.this.getHeaders(resp), r));
                }
            }
        });
    }

    @Override
    public void run() {
        try {
            Map resp = (Map)this.handler.invoke((Object)ClojureRing.buildRequestMap(this.req));
            if (resp != null) {
                Object body = resp.get(ClojureRing.BODY);
                if (body instanceof IListenableFuture) {
                    this.asyncHandle(this.cb, resp, (IListenableFuture)body);
                } else {
                    this.cb.run(ClojureRing.encode(ClojureRing.getStatus(resp), this.getHeaders(resp), body));
                }
            } else {
                this.cb.run(ClojureRing.encode(404, new TreeMap<String, Object>(), null));
            }
        }
        catch (Throwable e) {
            this.cb.run(ClojureRing.encode(500, new TreeMap<String, Object>(), e.getMessage()));
            HttpUtils.printError("ring handler: " + e.getMessage(), e);
        }
    }
}

