/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.http;

import clojure.lang.ISeq;
import clojure.lang.Seqable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import me.shenfeng.http.DynamicBytes;
import me.shenfeng.http.HttpStatus;
import me.shenfeng.http.ProtocolException;

public class HttpUtils {
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("utf8");
    public static final String CHARSET = "charset=";
    public static final byte COLON = 58;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final int MAX_LINE = 4096;
    public static final int BUFFER_SIZE = 65536;
    public static final int SELECT_TIMEOUT = 3000;
    public static final int TIMEOUT_CHECK_INTEVAL = 3000;
    public static final String TRANSFER_ENCODING = "transfer-encoding";
    public static final String CONTENT_ENCODING = "content-encoding";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CHUNKED = "chunked";
    public static final String CONNECTION = "connection";
    public static final String X_FORWARDED_FOR = "x-forwarded-for";
    public static final String CONTENT_LENGTH = "content-length";
    public static final byte SP = 32;
    private static final byte[] ALPHAS = "0123456789ABCDEF".getBytes();

    public static DynamicBytes encodeResponseHeader(int status, Map<String, Object> headers) {
        DynamicBytes bytes = new DynamicBytes(196);
        byte[] bs = HttpStatus.valueOf(status).getResponseIntialLineBytes();
        bytes.append(bs, 0, bs.length);
        for (Map.Entry<String, Object> e : headers.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            if (v instanceof String) {
                bytes.append(k);
                bytes.append((byte)58);
                bytes.append((byte)32);
                bytes.append((String)v, UTF_8);
                bytes.append((byte)13);
                bytes.append((byte)10);
                continue;
            }
            if (!(v instanceof Seqable)) continue;
            for (ISeq seq = ((Seqable)v).seq(); seq != null; seq = seq.next()) {
                bytes.append(k);
                bytes.append((byte)58);
                bytes.append((byte)32);
                bytes.append(seq.first().toString(), UTF_8);
                bytes.append((byte)13);
                bytes.append((byte)10);
            }
        }
        bytes.append((byte)13);
        bytes.append((byte)10);
        return bytes;
    }

    public static DynamicBytes encodeURI(String url) {
        byte[] bytes = url.getBytes(UTF_8);
        DynamicBytes buffer = new DynamicBytes(bytes.length * 2);
        boolean e = true;
        for (byte b : bytes) {
            byte c;
            byte by = c = b < 0 ? b + 256 : b;
            if (c < 33 || c > 126) {
                e = true;
            } else {
                switch (c) {
                    case 34: 
                    case 37: 
                    case 60: 
                    case 62: 
                    case 92: 
                    case 94: 
                    case 96: 
                    case 123: 
                    case 124: 
                    case 125: {
                        e = true;
                        break;
                    }
                    default: {
                        e = false;
                    }
                }
            }
            if (e) {
                buffer.append((byte)37);
                buffer.append(ALPHAS[c / 16]);
                buffer.append(ALPHAS[c % 16]);
                continue;
            }
            buffer.append(b);
        }
        return buffer;
    }

    public static int findEndOfString(String sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    public static int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    public static int findWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    public static int getChunkSize(String hex) throws ProtocolException {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        try {
            return Integer.parseInt(hex, 16);
        }
        catch (Exception e) {
            throw new ProtocolException("Expect chunk size to be a number: " + hex);
        }
    }

    public static String camelCase(String key) {
        StringBuilder sb = new StringBuilder(key.length());
        boolean upper = true;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (upper) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(Character.toLowerCase(c));
            }
            upper = c == '-';
        }
        return sb.toString();
    }

    public static String getPath(URI uri) {
        String path = uri.getPath();
        String query = uri.getRawQuery();
        if ("".equals(path)) {
            path = "/";
        }
        if (query == null) {
            return path;
        }
        return path + "?" + query;
    }

    public static int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = "https".equals(uri.getScheme()) ? 443 : 80;
        }
        return port;
    }

    public static String getHost(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        if (port != -1) {
            host = host + ":" + port;
        }
        return host;
    }

    public static InetSocketAddress getServerAddr(URI uri) throws UnknownHostException {
        InetAddress host = InetAddress.getByName(uri.getHost());
        return new InetSocketAddress(host, HttpUtils.getPort(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer readAll(File f) throws IOException {
        int length = (int)f.length();
        if (length >= 0x200000) {
            FileInputStream fs = new FileInputStream(f);
            MappedByteBuffer buffer = fs.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, length);
            fs.close();
            return buffer;
        }
        byte[] bytes = new byte[length];
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            for (int offset = 0; offset < length; offset += fs.read(bytes, offset, length - offset)) {
            }
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception ignore) {}
            }
        }
        return ByteBuffer.wrap(bytes);
    }

    public static DynamicBytes readAll(InputStream is) throws IOException {
        int read;
        DynamicBytes bytes = new DynamicBytes(32768);
        byte[] buffer = new byte[16384];
        while ((read = is.read(buffer)) != -1) {
            bytes.append(buffer, 0, read);
        }
        is.close();
        return bytes;
    }

    public static final void printError(String msg, Throwable t) {
        String error = String.format("%s [%s] ERROR - %s", new Date(), Thread.currentThread().getName(), msg);
        StringWriter str = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)str, false);
        pw.println(error);
        t.printStackTrace(pw);
        System.err.print(str.getBuffer().toString());
    }

    public static void splitAndAddHeader(String sb, Map<String, String> headers) {
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = HttpUtils.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        int valueStart = HttpUtils.findNonWhitespace(sb, colonEnd);
        int valueEnd = HttpUtils.findEndOfString(sb);
        String key = sb.substring(nameStart, nameEnd);
        if (valueStart <= valueEnd) {
            String value = sb.substring(valueStart, valueEnd);
            headers.put(key.toLowerCase(), value);
        }
    }
}

