/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.mmseg;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import me.shenfeng.mmseg.Dictionary;
import me.shenfeng.mmseg.HashSet;
import me.shenfeng.mmseg.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashSetDictionary
implements Dictionary {
    private Logger logger = LoggerFactory.getLogger(HashSetDictionary.class);
    private int maxWordLength = 0;
    private HashSet set;

    public HashSetDictionary(InputStream is) throws IOException {
        this.load(is);
    }

    private void load(InputStream file) throws IOException {
        long start = System.currentTimeMillis();
        char[] buffer = new char[786432];
        int[] offsets = new int[40960];
        int[] lengths = new int[40960];
        InputStreamReader fr = new InputStreamReader(file);
        int charIdx = 0;
        int wordIdx = 0;
        int length = 0;
        int read = 0;
        while ((read = fr.read()) != -1) {
            if (read == 13) continue;
            if (read == 10) {
                if (length == 0) continue;
                if (wordIdx == offsets.length) {
                    offsets = Arrays.copyOf(offsets, wordIdx * 2);
                    lengths = Arrays.copyOf(lengths, wordIdx * 2);
                }
                lengths[wordIdx] = length;
                offsets[wordIdx] = charIdx - length;
                ++wordIdx;
                length = 0;
                continue;
            }
            if (charIdx == buffer.length) {
                buffer = Arrays.copyOf(buffer, charIdx * 2);
            }
            ++length;
            buffer[charIdx++] = (char)read;
        }
        buffer = Arrays.copyOf(buffer, charIdx);
        this.set = new HashSet(wordIdx);
        for (int i = 0; i < wordIdx; ++i) {
            if (lengths[i] > this.maxWordLength) {
                this.maxWordLength = lengths[i];
            }
            Word w = new Word(buffer, offsets[i], lengths[i]);
            this.set.insert(w);
        }
        long time = System.currentTimeMillis() - start;
        this.logger.info("load: {}ms, word: {}, max word length: {}, bucket: {}, hash: {}", new Object[]{time, wordIdx, this.maxWordLength, this.set.prime, this.set.getLoad()});
    }

    public int maxMath(char[] sen, int offset, int length) {
        int maxLength;
        for (int i = maxLength = Math.min(length, this.maxWordLength); i > 1; --i) {
            Word w = new Word(sen, offset, i);
            if (!this.set.contains(w)) continue;
            return i;
        }
        return 1;
    }
}

