/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.mmseg;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import me.shenfeng.mmseg.Dictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BSDictionary
implements Dictionary {
    private Logger logger = LoggerFactory.getLogger(BSDictionary.class);
    private int maxWordLength = 0;
    char[][] groups;

    private boolean binarySearch(char[] data, char[] target, int offset, int length) {
        int low = 0;
        int high = data.length / length - 1;
        while (low <= high) {
            int i;
            int mid = low + high >>> 1;
            int start = mid * length;
            for (i = 0; i < length; ++i) {
                if (data[start + i] < target[offset + i]) {
                    low = mid + 1;
                    break;
                }
                if (data[start + i] <= target[offset + i]) continue;
                high = mid - 1;
                break;
            }
            if (i != length) continue;
            return true;
        }
        return false;
    }

    @Override
    public int maxMath(char[] sen, int offset, int length) {
        int maxLength;
        for (int i = maxLength = Math.min(length, this.maxWordLength); i > 1; --i) {
            if (!this.binarySearch(this.groups[i - 1], sen, offset, i)) continue;
            return i;
        }
        return 1;
    }

    public BSDictionary(InputStream is) throws IOException {
        this.load(is);
    }

    private void load(InputStream is) throws IOException {
        int i;
        long start = System.currentTimeMillis();
        char[] buffer = new char[786432];
        int[] offsets = new int[40960];
        int[] lengths = new int[40960];
        InputStreamReader fr = new InputStreamReader(is);
        int charIdx = 0;
        int wordCnt = 0;
        int length = 0;
        int read = 0;
        while ((read = fr.read()) != -1) {
            if (read == 13) continue;
            if (read == 10) {
                if (length == 0) continue;
                if (wordCnt == offsets.length) {
                    offsets = Arrays.copyOf(offsets, wordCnt * 2);
                    lengths = Arrays.copyOf(lengths, wordCnt * 2);
                }
                lengths[wordCnt] = length;
                offsets[wordCnt] = charIdx - length;
                ++wordCnt;
                length = 0;
                continue;
            }
            if (charIdx == buffer.length) {
                buffer = Arrays.copyOf(buffer, charIdx * 2);
            }
            ++length;
            buffer[charIdx++] = (char)read;
        }
        for (int i2 = 0; i2 < wordCnt; ++i2) {
            if (lengths[i2] <= this.maxWordLength) continue;
            this.maxWordLength = lengths[i2];
        }
        this.groups = new char[this.maxWordLength][];
        int[] counter = new int[this.maxWordLength];
        for (i = 0; i < this.maxWordLength; ++i) {
            this.groups[i] = new char[buffer.length];
        }
        for (i = 0; i < wordCnt; ++i) {
            int len = lengths[i];
            int index = len - 1;
            System.arraycopy(buffer, offsets[i], this.groups[index], counter[index] * len, len);
            int n = index;
            counter[n] = counter[n] + 1;
        }
        for (i = 0; i < this.maxWordLength; ++i) {
            this.groups[i] = Arrays.copyOf(this.groups[i], counter[i] * (i + 1));
        }
        long time = System.currentTimeMillis() - start;
        this.logger.info("load: {}ms, word: {}, max word length: {}", new Object[]{time, wordCnt, this.maxWordLength});
    }
}

