/*
 * Decompiled with CFR 0.152.
 */
package me.shenfeng.mustache;

import clojure.lang.Keyword;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.shenfeng.mustache.Context;
import me.shenfeng.mustache.ParserException;
import me.shenfeng.mustache.Scanner;
import me.shenfeng.mustache.Token;

public class Mustache {
    public static final String BEGIN = "{{";
    public static final String END = "}}";
    List<Token> tokens;
    public static final ConcurrentMap<String, Mustache> CACHE = new ConcurrentHashMap<String, Mustache>();

    private List<Token> nestedToken(List<Token> list) throws ParserException {
        ArrayList<Token> arrayList = new ArrayList<Token>();
        LinkedList<Token> linkedList = new LinkedList<Token>();
        List<Token> list2 = arrayList;
        block4: for (Token token : list) {
            switch (token.type) {
                case '#': 
                case '?': 
                case '^': {
                    token.tokens = new ArrayList<Token>();
                    linkedList.add(token);
                    list2.add(token);
                    list2 = token.tokens;
                    continue block4;
                }
                case '/': {
                    if (linkedList.isEmpty()) {
                        throw new ParserException("Unopened section: " + token.value);
                    }
                    Token token2 = (Token)linkedList.removeLast();
                    if (!token2.value.equals(token.value)) {
                        throw new ParserException("Unclosed " + token.value + "; in section" + token2.value);
                    }
                    if (linkedList.size() > 0) {
                        list2 = ((Token)linkedList.peekLast()).tokens;
                        continue block4;
                    }
                    list2 = arrayList;
                    continue block4;
                }
            }
            list2.add(token);
        }
        if (linkedList.size() > 0) {
            throw new ParserException("Unclosed section: " + ((Token)linkedList.peek()).value);
        }
        return arrayList;
    }

    public static Mustache preprocess(String string) throws ParserException {
        Mustache mustache = (Mustache)CACHE.get(string);
        if (mustache == null) {
            mustache = new Mustache(string);
            CACHE.put(string, mustache);
        }
        return mustache;
    }

    private Mustache(String string) throws ParserException {
        LinkedList<Token> linkedList = new LinkedList<Token>();
        Scanner scanner = new Scanner(string);
        block3: while (!scanner.eos()) {
            String string2 = scanner.scanUtil(BEGIN);
            if (string2 != null) {
                linkedList.add(new Token('t', string2));
            }
            char c = scanner.nextType();
            scanner.skipeWhiteSpace();
            switch (c) {
                case '{': {
                    string2 = scanner.scanUtil("}}}");
                    linkedList.add(new Token(c, string2));
                    continue block3;
                }
            }
            string2 = scanner.scanUtil(END);
            linkedList.add(new Token(c, string2));
        }
        this.tokens = this.nestedToken(linkedList);
    }

    public String render(Context context) {
        try {
            return Token.renderTokens(this.tokens, context, null);
        }
        catch (ParserException parserException) {
            return "";
        }
    }

    public String render(Context context, Map<Keyword, String> map) throws ParserException {
        return Token.renderTokens(this.tokens, context, map);
    }
}

