(ns me.vedang.clj-fdb.internal.protocols
  "Protocols to control and extend the behavior of core clj-fdb functions.

  These are marked as internal at the moment since I am still working
  through the shape of the interfaces. I will make this namespace
  public by the 1.0 release.

  * `Encodable` -- for producing new Byte-Array objects to insert into FDB.
  * `Decodable` -- for converting back Byte-Array objects returned by FDB.")

(defprotocol Encodable
  "Protocol for taking an object and returning the byte-array version of
  the object which will be stored by FDB.

  Implementations are provided for `Tuple`, `Subspace`,
  `DirectoryLayer` / `DirectorySubspace`, `String`."
  (-encode [this] [this parent]))


(defprotocol Decodable
  "Protocol for taking the byte-array returned by FDB and converting it
  back into the object.

  Implementations are provided for `Tuple` and `Subspace`"
  (-decode [this] [this parent]))

(comment
  (extend-protocol p/Encodable
    byte-array-class
    (-encode [k] k)

    String
    (-encode [k] (.getBytes ^String k "UTF-8"))

    com.apple.foundationdb.tuple.Tuple
    (-encode [k] (ftup/pack ^Tuple k))

    clojure.lang.IPersistentVector
    (-encode [k] (ftup/pack (ftup/create k)))
    (-encode [s k] (-encode (fsub/create s) (ftup/create k)))

    com.apple.foundationdb.subspace.Subspace
    (-encode [s k] (-encode s (ftup/create k)))))
