/*
 * Decompiled with CFR 0.152.
 */
package me.vlobanov.mustache;

import clojure.lang.Keyword;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import me.vlobanov.mustache.Context;
import me.vlobanov.mustache.ParserException;
import me.vlobanov.mustache.Scanner;
import me.vlobanov.mustache.Token;

public class Mustache {
    public static final String BEGIN = "{{";
    public static final String END = "}}";
    String fileName;
    List<Token> tokens;
    public static final ConcurrentMap<String, Mustache> CACHE = new ConcurrentHashMap<String, Mustache>();

    private List<Token> nestedToken(List<Token> input) throws ParserException {
        ArrayList<Token> output = new ArrayList<Token>();
        LinkedList<Token> sections = new LinkedList<Token>();
        List<Token> collector = output;
        block4: for (Token token : input) {
            switch (token.type) {
                case '#': 
                case '?': 
                case '^': {
                    token.tokens = new ArrayList<Token>();
                    sections.add(token);
                    collector.add(token);
                    collector = token.tokens;
                    continue block4;
                }
                case '/': {
                    if (sections.isEmpty()) {
                        throw new ParserException("Unopened section: " + token.getDescription(), token);
                    }
                    Token section = (Token)sections.removeLast();
                    if (!section.value.equals(token.value)) {
                        throw new ParserException("Unclosed: " + token.getDescription() + "; in section" + section.value, token);
                    }
                    if (sections.size() > 0) {
                        collector = ((Token)sections.peekLast()).tokens;
                        continue block4;
                    }
                    collector = output;
                    continue block4;
                }
            }
            collector.add(token);
        }
        if (sections.size() > 0) {
            throw new ParserException("Unclosed section: " + ((Token)sections.peek()).getDescription());
        }
        return output;
    }

    public static Mustache preprocess(String template) throws ParserException {
        return Mustache.preprocess(template, "<unknown>");
    }

    public static Mustache preprocess(String template, String fileName) throws ParserException {
        Mustache m = (Mustache)CACHE.get(template);
        if (m == null) {
            m = new Mustache(template, fileName);
            CACHE.put(template, m);
        }
        return m;
    }

    private Mustache(String template, String fileName) throws ParserException {
        LinkedList<Token> tokens = new LinkedList<Token>();
        Scanner scanner = new Scanner(template);
        this.fileName = fileName;
        block3: while (!scanner.eos()) {
            String value = scanner.scanUtil(BEGIN);
            if (value != null) {
                tokens.add(new Token('t', value));
            }
            char type = scanner.nextType();
            scanner.skipeWhiteSpace();
            switch (type) {
                case '{': {
                    value = scanner.scanUtil("}}}");
                    tokens.add(new Token(type, value, scanner.getCurrentLine(), fileName));
                    continue block3;
                }
            }
            value = scanner.scanUtil(END);
            tokens.add(new Token(type, value, scanner.getCurrentLine(), fileName));
        }
        this.tokens = this.nestedToken(tokens);
    }

    public String render(Context ctx) {
        try {
            return Token.renderTokens(this.tokens, ctx, null);
        }
        catch (ParserException e) {
            return "";
        }
    }

    public String render(Context ctx, Map<Keyword, String> partials) throws ParserException {
        return Token.renderTokens(this.tokens, ctx, partials);
    }
}

