/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.outer.convert;

import com.google.common.collect.Sets;
import ff.FFModel;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.zhenchuan.base.enums.Manufacturer;
import me.zhenchuan.base.enums.OS;
import me.zhenchuan.base.enums.Platform;
import me.zhenchuan.db.history.DailyModel;
import me.zhenchuan.utils.IpUtils;
import me.zhenchuan.utils.TimeUtils;

public class FFConverter {
    private OS os = OS.NULL;
    private Manufacturer manufacturer = Manufacturer.NULL;
    private Set<String> countrySet = Sets.newHashSet();
    private Set<String> provinceSet = Sets.newHashSet();
    private Set<String> citySet = Sets.newHashSet();
    private Set<Long> ipSet = Sets.newHashSet();

    FFModel convert(long requestDay, List<DailyModel> dailyModelList) {
        FFModel model = new FFModel();
        for (DailyModel dailyModel : dailyModelList) {
            this.processSingleDay(model, dailyModel);
        }
        model.nCities = this.citySet.size();
        model.nCountries = this.countrySet.size();
        model.nProvinces = this.provinceSet.size();
        model.nIps = this.ipSet.size();
        model.phoneBrand = this.manufacturer.name();
        model.ipinyouOsAndroid = this.os == OS.Android;
        model.ipinyouOsIos = this.os == OS.IOS;
        model.nPlatforms = model.platformCounter.size();
        model.adReqPerDay = model.nAdReq == 0L ? 0L : model.nAdReq / model.nPreDays;
        model.lastActiveDay = TimeUtils.rangeInDay((long)model.lastActiveDay, (long)requestDay);
        return model;
    }

    private void processSingleDay(FFModel model, DailyModel dailyModel) {
        if (dailyModel.getCount() == 0L) {
            return;
        }
        if (dailyModel.getOs() != OS.NULL) {
            this.os = dailyModel.getOs();
        }
        if (dailyModel.getManufacturer() != Manufacturer.NULL) {
            this.manufacturer = dailyModel.getManufacturer();
        }
        model.nAdReq += dailyModel.getCount();
        ++model.nPreDays;
        if (model.lastActiveDay < dailyModel.getDay()) {
            model.lastActiveDay = dailyModel.getDay();
        }
        Iterator iterator = dailyModel.getIps().iterator();
        while (iterator.hasNext()) {
            long ip = (Long)iterator.next();
            String[] items = IpUtils.parse((long)ip);
            if (this.ipSet.contains(ip)) continue;
            this.ipSet.add(ip);
            this.countrySet.add(items[0]);
            this.provinceSet.add(items[1]);
            this.citySet.add(items[2]);
        }
        for (Platform platform : dailyModel.getPlatforms()) {
            long old = model.platformCounter.getOrDefault(platform.name(), 0L);
            model.platformCounter.put(platform.name(), old + 1L);
        }
    }
}

