/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

public strictfp final class R2Vector {
    private final double x;
    private final double y;

    public R2Vector() {
        this(0.0, 0.0);
    }

    public R2Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public R2Vector(double[] coord) {
        if (coord.length != 2) {
            throw new IllegalStateException("Points must have exactly 2 coordinates");
        }
        this.x = coord[0];
        this.y = coord[1];
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double get(int index) {
        if (index > 1) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return index == 0 ? this.x : this.y;
    }

    public static R2Vector add(R2Vector p1, R2Vector p2) {
        return new R2Vector(p1.x + p2.x, p1.y + p2.y);
    }

    public static R2Vector mul(R2Vector p2, double m2) {
        return new R2Vector(m2 * p2.x, m2 * p2.y);
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y;
    }

    public static double dotProd(R2Vector p1, R2Vector p2) {
        return p1.x * p2.x + p1.y * p2.y;
    }

    public double dotProd(R2Vector that) {
        return R2Vector.dotProd(this, that);
    }

    public double crossProd(R2Vector that) {
        return this.x * that.y - this.y * that.x;
    }

    public boolean lessThan(R2Vector vb) {
        if (this.x < vb.x) {
            return true;
        }
        if (vb.x < this.x) {
            return false;
        }
        return this.y < vb.y;
    }

    public boolean equals(Object that) {
        if (!(that instanceof R2Vector)) {
            return false;
        }
        R2Vector thatPoint = (R2Vector)that;
        return this.x == thatPoint.x && this.y == thatPoint.y;
    }

    public int hashCode() {
        long value = 17L;
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.x));
        value += 37L * value + Double.doubleToLongBits(Math.abs(this.y));
        return (int)(value ^ value >>> 32);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

