/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.common.geometry;

import com.baidu.common.geometry.S1Angle;
import com.baidu.common.geometry.S2;
import com.baidu.common.geometry.S2Cap;
import com.baidu.common.geometry.S2Cell;
import com.baidu.common.geometry.S2EdgeUtil;
import com.baidu.common.geometry.S2LatLngRect;
import com.baidu.common.geometry.S2Point;
import com.baidu.common.geometry.S2Region;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public strictfp final class S2Polyline
implements S2Region {
    private static final Logger log = Logger.getLogger(S2Polyline.class.getCanonicalName());
    private final int numVertices;
    private final S2Point[] vertices;

    public S2Polyline(List<S2Point> vertices) {
        this.numVertices = vertices.size();
        this.vertices = vertices.toArray(new S2Point[this.numVertices]);
    }

    public S2Polyline(S2Polyline src) {
        this.numVertices = src.numVertices();
        this.vertices = (S2Point[])src.vertices.clone();
    }

    public boolean isValid(List<S2Point> vertices) {
        int i2;
        int n2 = vertices.size();
        for (i2 = 0; i2 < n2; ++i2) {
            if (S2.isUnitLength(vertices.get(i2))) continue;
            log.info("Vertex " + i2 + " is not unit length");
            return false;
        }
        for (i2 = 1; i2 < n2; ++i2) {
            if (!vertices.get(i2 - 1).equals(vertices.get(i2)) && !vertices.get(i2 - 1).equals(S2Point.neg(vertices.get(i2)))) continue;
            log.info("Vertices " + (i2 - 1) + " and " + i2 + " are identical or antipodal");
            return false;
        }
        return true;
    }

    public int numVertices() {
        return this.numVertices;
    }

    public S2Point vertex(int k2) {
        return this.vertices[k2];
    }

    public S1Angle getArclengthAngle() {
        double lengthSum = 0.0;
        for (int i2 = 1; i2 < this.numVertices(); ++i2) {
            lengthSum += this.vertex(i2 - 1).angle(this.vertex(i2));
        }
        return S1Angle.radians(lengthSum);
    }

    public S2Point interpolate(double fraction) {
        if (fraction <= 0.0) {
            return this.vertex(0);
        }
        double lengthSum = 0.0;
        for (int i2 = 1; i2 < this.numVertices(); ++i2) {
            lengthSum += this.vertex(i2 - 1).angle(this.vertex(i2));
        }
        double target = fraction * lengthSum;
        for (int i3 = 1; i3 < this.numVertices(); ++i3) {
            double length = this.vertex(i3 - 1).angle(this.vertex(i3));
            if (target < length) {
                double f2 = Math.sin(target) / Math.sin(length);
                return S2Point.add(S2Point.mul(this.vertex(i3 - 1), Math.cos(target) - f2 * Math.cos(length)), S2Point.mul(this.vertex(i3), f2));
            }
            target -= length;
        }
        return this.vertex(this.numVertices() - 1);
    }

    @Override
    public S2Cap getCapBound() {
        return this.getRectBound().getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        S2EdgeUtil.RectBounder bounder = new S2EdgeUtil.RectBounder();
        for (int i2 = 0; i2 < this.numVertices(); ++i2) {
            bounder.addPoint(this.vertex(i2));
        }
        return bounder.getBound();
    }

    @Override
    public boolean contains(S2Cell cell) {
        throw new UnsupportedOperationException("'containment' is not numerically well-defined except at the polyline vertices");
    }

    @Override
    public boolean mayIntersect(S2Cell cell) {
        if (this.numVertices() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < this.numVertices(); ++i2) {
            if (!cell.contains(this.vertex(i2))) continue;
            return true;
        }
        S2Point[] cellVertices = new S2Point[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            cellVertices[i3] = cell.getVertex(i3);
        }
        for (int j2 = 0; j2 < 4; ++j2) {
            S2EdgeUtil.EdgeCrosser crosser = new S2EdgeUtil.EdgeCrosser(cellVertices[j2], cellVertices[j2 + 1 & 3], this.vertex(0));
            for (int i4 = 1; i4 < this.numVertices(); ++i4) {
                if (crosser.robustCrossing(this.vertex(i4)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public int getNearestEdgeIndex(S2Point point) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        if (this.numVertices() == 1) {
            return 0;
        }
        S1Angle minDistance = S1Angle.radians(10.0);
        int minIndex = -1;
        for (int i2 = 0; i2 < this.numVertices() - 1; ++i2) {
            S1Angle distanceToSegment = S2EdgeUtil.getDistance(point, this.vertex(i2), this.vertex(i2 + 1));
            if (!distanceToSegment.lessThan(minDistance)) continue;
            minDistance = distanceToSegment;
            minIndex = i2;
        }
        return minIndex;
    }

    public S2Point projectToEdge(S2Point point, int index) {
        Preconditions.checkState((this.numVertices() > 0 ? 1 : 0) != 0, (Object)"Empty polyline");
        Preconditions.checkState((this.numVertices() == 1 || index < this.numVertices() - 1 ? 1 : 0) != 0, (Object)"Invalid edge index");
        if (this.numVertices() == 1) {
            return this.vertex(0);
        }
        return S2EdgeUtil.getClosestPoint(point, this.vertex(index), this.vertex(index + 1));
    }

    public boolean equals(Object that) {
        if (!(that instanceof S2Polyline)) {
            return false;
        }
        S2Polyline thatPolygon = (S2Polyline)that;
        if (this.numVertices != thatPolygon.numVertices) {
            return false;
        }
        for (int i2 = 0; i2 < this.vertices.length; ++i2) {
            if (this.vertices[i2].equals(thatPolygon.vertices[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.numVertices, Arrays.deepHashCode(this.vertices)});
    }
}

