/*
 * Decompiled with CFR 0.152.
 */
package com.ipinyou.rpc.dependency;

import com.ipinyou.rpc.dependency.NComparator;
import com.ipinyou.rpc.dependency.O;
import java.util.ArrayList;
import java.util.List;

public class IObj<T extends Comparable<T>>
implements Comparable<IObj<T>> {
    private static final NComparator comparator = new NComparator();
    private final T obj;
    private final long cursor;

    public IObj(T obj, long cursor) {
        O.required(cursor >= 0L, "cursor >= 0");
        this.obj = obj;
        this.cursor = cursor;
    }

    public static <T extends Comparable<T>> List<IObj<T>> to(List<T> objs) {
        ArrayList<IObj<T>> ret = new ArrayList<IObj<T>>(objs.size());
        for (int i2 = 0; i2 < objs.size(); ++i2) {
            ret.add(new IObj<Comparable>((Comparable)objs.get(i2), i2));
        }
        return ret;
    }

    public static <T extends Comparable<T>> void separate(List<IObj<T>> iobjs, List<T> objs, List<Long> cursors) {
        for (IObj<T> iobj : iobjs) {
            objs.add(iobj.obj);
            cursors.add(iobj.cursor);
        }
    }

    public static <T extends Comparable<T>> void combine(List<IObj<T>> iobjs, List<T> objs, List<Long> cursors) {
        for (int i2 = 0; i2 < objs.size(); ++i2) {
            iobjs.add(new IObj<Comparable>((Comparable)objs.get(i2), cursors.get(i2)));
        }
    }

    public T obj() {
        return this.obj;
    }

    public long cursor() {
        return this.cursor;
    }

    @Override
    public int compareTo(IObj<T> o2) {
        int r2 = comparator.compare(this.obj, o2.obj);
        if (r2 != 0) {
            return r2;
        }
        return Long.compare(this.cursor, o2.cursor);
    }

    public int hashCode() {
        return Long.hashCode(this.cursor);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IObj)) {
            return false;
        }
        return this.compareTo((IObj)obj) == 0;
    }

    public String toString() {
        return O.conToString(this.getClass(), this.obj, this.cursor);
    }
}

