/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sparkey;

import com.spotify.sparkey.Util;

final class MurmurHash3 {
    MurmurHash3() {
    }

    static int murmurHash3_x86_32(byte[] data, int len, int seed) {
        int k1;
        int nblocks = len / 4;
        int h1 = seed;
        int c1 = -862048943;
        int c2 = 461845907;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            k1 = MurmurHash3.getBlock32(data, 4 * i2);
            k1 *= c1;
            k1 = k1 << 15 | k1 >>> 17;
            h1 ^= (k1 *= c2);
            h1 = h1 << 13 | h1 >>> 19;
            h1 = h1 * 5 + -430675100;
        }
        int tail = 4 * nblocks;
        k1 = 0;
        switch (len & 3) {
            case 3: {
                k1 ^= Util.unsignedByte(data[tail + 2]) << 16;
            }
            case 2: {
                k1 ^= Util.unsignedByte(data[tail + 1]) << 8;
            }
            case 1: {
                k1 ^= Util.unsignedByte(data[tail]);
                k1 *= c1;
                k1 = k1 << 15 | k1 >>> 17;
                h1 ^= (k1 *= c2);
            }
        }
        int h2 = h1 ^= len;
        h2 ^= h2 >>> 16;
        h2 *= -2048144789;
        h2 ^= h2 >>> 13;
        h2 *= -1028477387;
        h2 ^= h2 >>> 16;
        h1 = h2;
        return h1;
    }

    private static int getBlock32(byte[] data, int i2) {
        return Util.unsignedByte(data[i2]) | Util.unsignedByte(data[i2 + 1]) << 8 | Util.unsignedByte(data[i2 + 2]) << 16 | Util.unsignedByte(data[i2 + 3]) << 24;
    }

    private static long getBlock64(byte[] data, int i2) {
        long low = (long)MurmurHash3.getBlock32(data, 8 * i2) & 0xFFFFFFFFL;
        long high = (long)MurmurHash3.getBlock32(data, 8 * i2 + 4) & 0xFFFFFFFFL;
        return low | high << 32;
    }

    private static long fmix64(long k2) {
        k2 ^= k2 >>> 33;
        k2 *= -49064778989728563L;
        k2 ^= k2 >>> 33;
        k2 *= -4265267296055464877L;
        k2 ^= k2 >>> 33;
        return k2;
    }

    static long murmurHash3_x64_64(byte[] data, int len, int seed) {
        long k2;
        long k1;
        long h1;
        int nblocks = len / 16;
        long h2 = h1 = (long)seed & 0xFFFFFFFFL;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int i2 = 0; i2 < nblocks; ++i2) {
            k1 = MurmurHash3.getBlock64(data, 2 * i2);
            k2 = MurmurHash3.getBlock64(data, 2 * i2 + 1);
            k1 *= -8663945395140668459L;
            k1 = MurmurHash3.ROTL64(k1, 31);
            h1 ^= (k1 *= 5545529020109919103L);
            h1 = MurmurHash3.ROTL64(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= 5545529020109919103L;
            k2 = MurmurHash3.ROTL64(k2, 33);
            h2 ^= (k2 *= -8663945395140668459L);
            h2 = MurmurHash3.ROTL64(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        int tail = 16 * nblocks;
        k1 = 0L;
        k2 = 0L;
        switch (len & 0xF) {
            case 15: {
                k2 ^= (long)Util.unsignedByte(data[tail + 14]) << 48;
            }
            case 14: {
                k2 ^= (long)Util.unsignedByte(data[tail + 13]) << 40;
            }
            case 13: {
                k2 ^= (long)Util.unsignedByte(data[tail + 12]) << 32;
            }
            case 12: {
                k2 ^= (long)Util.unsignedByte(data[tail + 11]) << 24;
            }
            case 11: {
                k2 ^= (long)Util.unsignedByte(data[tail + 10]) << 16;
            }
            case 10: {
                k2 ^= (long)Util.unsignedByte(data[tail + 9]) << 8;
            }
            case 9: {
                k2 ^= (long)Util.unsignedByte(data[tail + 8]) << 0;
                k2 *= 5545529020109919103L;
                k2 = MurmurHash3.ROTL64(k2, 33);
                h2 ^= (k2 *= -8663945395140668459L);
            }
            case 8: {
                k1 ^= (long)Util.unsignedByte(data[tail + 7]) << 56;
            }
            case 7: {
                k1 ^= (long)Util.unsignedByte(data[tail + 6]) << 48;
            }
            case 6: {
                k1 ^= (long)Util.unsignedByte(data[tail + 5]) << 40;
            }
            case 5: {
                k1 ^= (long)Util.unsignedByte(data[tail + 4]) << 32;
            }
            case 4: {
                k1 ^= (long)Util.unsignedByte(data[tail + 3]) << 24;
            }
            case 3: {
                k1 ^= (long)Util.unsignedByte(data[tail + 2]) << 16;
            }
            case 2: {
                k1 ^= (long)Util.unsignedByte(data[tail + 1]) << 8;
            }
            case 1: {
                k1 ^= (long)Util.unsignedByte(data[tail + 0]) << 0;
                k1 *= -8663945395140668459L;
                k1 = MurmurHash3.ROTL64(k1, 31);
                h1 ^= (k1 *= 5545529020109919103L);
            }
        }
        h1 ^= (long)len;
        h1 += (h2 ^= (long)len);
        h2 += h1;
        h1 = MurmurHash3.fmix64(h1);
        h2 = MurmurHash3.fmix64(h2);
        h1 += h2;
        h2 += h1;
        return h1;
    }

    private static long ROTL64(long x, int r) {
        return x << r | x >>> 64 - r;
    }
}

