/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.db.history;

import com.ipinyou.rpc.dependency.Decoder;
import com.ipinyou.rpc.dependency.Encoder;
import com.ipinyou.rpc.dependency.Input;
import com.ipinyou.rpc.dependency.LongCodec;
import com.ipinyou.rpc.dependency.Output;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.zhenchuan.base.enums.DayType;
import me.zhenchuan.db.Flattening;
import me.zhenchuan.utils.FastDateFormat;

public class Time
implements Encoder<Time>,
Decoder<Time>,
Comparable<Time>,
Serializable,
Flattening {
    static final long base = 1483200000000L;
    long start;
    long end;
    long diff;
    public static final String[] LABELS = new String[]{"Start Time", "End Time", "Day Type"};
    static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");

    public Time(long start, long end) {
        this.start = start;
        this.end = end;
        this.diff = end - start;
    }

    public Time() {
    }

    @Override
    public String[] flatten() {
        return new String[]{FastDateFormat.yyyy_MM_dd_HH_mm_ss(this.start), FastDateFormat.yyyy_MM_dd_HH_mm_ss(this.end), DayType.valueOf(this.start).name()};
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public void setStart(long start) {
        this.start = start;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    @Override
    public Time decode(Input in) {
        long start = LongCodec.decode(in);
        long diff = LongCodec.decode(in);
        return new Time(1483200000000L + start, 1483200000000L + start + diff);
    }

    @Override
    public void encode(Output out) {
        LongCodec.encode(this.start - 1483200000000L, out);
        LongCodec.encode(this.diff, out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Time{");
        sb.append("diff=").append(this.diff);
        sb.append(", start=").append(df.format(new Date(this.start)));
        sb.append(", end=").append(df.format(new Date(this.end)));
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int compareTo(Time o2) {
        int ret = Long.compare(this.start, o2.start);
        if (ret == 0) {
            return Long.compare(this.end, o2.end);
        }
        return ret;
    }
}

