/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.dict;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.zhenchuan.base.ResourceFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelKeyword
extends ResourceFileReader {
    private static final Logger log = LoggerFactory.getLogger(ModelKeyword.class);
    private static Map<String, Pattern> patternMap = Maps.newHashMap();
    private static Map<String, String> modelMap = Maps.newHashMap();
    private static Map<String, String> manufacturerMap = Maps.newHashMap();
    private static volatile boolean loaded = false;
    private static ModelKeyword instance = new ModelKeyword();
    static String[] candidates = new String[]{"Huawei", "Xiaomi", "Coolpad", "Lenovo", "Sony Ericsson", "ZTE", "HTC", "Panasonic", "Sony", "Vivo", "Oppo"};

    public ModelKeyword() {
        this.load();
    }

    public static ModelKeyword getInstance() {
        return instance;
    }

    public String manufacturer(String key) {
        if (!loaded) {
            this.load();
        }
        if (manufacturerMap.containsKey(key = key.trim().toLowerCase())) {
            return manufacturerMap.get(key);
        }
        return key;
    }

    private synchronized void load() {
        if (loaded) {
            return;
        }
        List<String> lines = this.readLines("/model_secret.txt");
        HashSet c2 = Sets.newHashSet((Object[])new String[]{"Huawei", "Samsung", "Coolpad", "Lenovo", "Micromax", "ZTE"});
        manufacturerMap.put("360", "Q360");
        manufacturerMap.put("iPhone", "Apple");
        manufacturerMap.put("la-s35", "xiaolajiao");
        manufacturerMap.put("LA-S31", "xiaolajiao");
        manufacturerMap.put("smartisan", "Smartisan");
        manufacturerMap.put("bird", "Bird");
        for (int i2 = 0; i2 < lines.size(); i2 += 2) {
            String name = lines.get(i2).trim().replaceAll("==", "");
            manufacturerMap.put(name.replaceAll("\\(", "-").replaceAll("\\)".toLowerCase(), ""), name);
            manufacturerMap.put(name.replaceAll("\\s+", "-").toLowerCase(), name);
            String models = lines.get(i2 + 1).trim();
            Arrays.stream(models.split("\\|")).forEach(model -> {
                if (!modelMap.containsKey(model)) {
                    modelMap.put((String)model, name);
                }
            });
        }
        log.info("manufacturer : {} , models : {}", (Object)manufacturerMap.size(), (Object)modelMap.size());
        loaded = true;
    }

    public String findModel(String rawModel) {
        String key;
        if (!loaded) {
            this.load();
        }
        if (rawModel == null || rawModel.trim().isEmpty()) {
            return null;
        }
        int tryIdx = rawModel.indexOf("Build");
        if (tryIdx > 0 && modelMap.containsKey(key = rawModel.substring(0, tryIdx - 1).trim())) {
            return modelMap.get(key);
        }
        String[] items = rawModel.trim().split("\\s+");
        String key2 = "";
        boolean first = true;
        for (int i2 = 0; i2 < items.length && i2 < 4; ++i2) {
            String del1;
            if (items[i2].endsWith(";")) continue;
            if (items[i2].startsWith("Build")) break;
            if (key2.isEmpty()) {
                key2 = key2 + items[i2];
            } else {
                first = false;
                key2 = key2 + " " + items[i2];
            }
            if (modelMap.containsKey(key2)) {
                return modelMap.get(key2);
            }
            if (first) {
                String key22;
                if (key2.startsWith("HUAWEI")) {
                    key22 = key2.replace("HUAWEI", "HUAWEI ");
                    if (modelMap.containsKey(key22)) {
                        return modelMap.get(key22);
                    }
                } else {
                    key22 = "HUAWEI " + key2;
                    if (modelMap.containsKey(key22)) {
                        return modelMap.get(key22);
                    }
                    key22 = "Coolpad " + key2;
                    if (modelMap.containsKey(key22)) {
                        return modelMap.get(key22);
                    }
                    key22 = "OPPO " + key2;
                    if (modelMap.containsKey(key22)) {
                        return modelMap.get(key22);
                    }
                }
            }
            if (!modelMap.containsKey(del1 = key2.substring(0, key2.length() - 1))) continue;
            return modelMap.get(del1);
        }
        return null;
    }
}

