/*
 * Decompiled with CFR 0.152.
 */
package me.zhenchuan.utils;

public class LatLngUtils {
    static final double earthRadiusInKm = 6372.8;

    public static boolean inChina(double lng, double lat) {
        return lng > 72.0 && lng < 136.0 && lat > 16.0 && lat < 54.0;
    }

    public static boolean isValid(double lng, double lat) {
        if (lat == -0.020085074499909615) {
            return false;
        }
        return lng >= -180.0 && lng <= 180.0 && lat >= -90.0 && lat <= 90.0;
    }

    private static double haversinceDistance(Double lon1, Double lat1, Double lon2, Double lat2) {
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double a2 = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.pow(Math.sin(dLon / 2.0), 2.0) * Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2));
        double c2 = 2.0 * Math.asin(Math.sqrt(a2));
        return 6372.8 * c2;
    }

    public static double distance(Double lon1, Double lat1, Double lon2, Double lat2) {
        double dx = lon1 - lon2;
        double dy = lat1 - lat2;
        double b2 = (lat1 + lat2) / 2.0;
        double Lx = Math.toRadians(dx) * 6372.8 * Math.cos(Math.toRadians(b2));
        double Ly = 6372.8 * Math.toRadians(dy);
        return Math.sqrt(Lx * Lx + Ly * Ly);
    }
}

