(ns less4clj.api
  (:require [less4clj.watcher :as watcher]
            [less4clj.core :as core]
            [clojure.java.io :as io]
            [clojure.spec.alpha :as s]))

(s/def ::report (s/or :symbol s/symbol?
                      :keyword (s/enum :pretty :progress :junit)
                      :map (s/keys :req-un [:report/type]
                                   :opt-un [:report/output-to])
                      :vector (s/coll-of ::report :into vec)))

(s/def ::test-matcher )
(s/def ::parallel? s/boolean?)
(s/def ::filter s/fn?)
(s/def ::on-start s/fn?)
(s/def ::on-end s/fn?)
(s/def ::cloverage-oopts s/map?)
(s/def ::notify-command (s/or :string string?
                              :vector (s/coll-of string? :into vec)))

(s/def ::selectors (s/coll-of ))

(s/def ::namespaces (s/coll-of symbol? :into vec))
(s/def ::cloverage s/boolean?)
(s/def ::options (s/keys :req-un [::source-paths ::target-path]
                         :opt-un [::auto ::help ::compression ::source-map
                                  ::inline-javascript ::verbosity]))

(defn run-tests [{:keys [source-paths auto] :as options}]
  (when-not (s/valid? ::options options)
    (s/explain-out (s/explain-data ::options options)))
  (let [options (dissoc options :source-paths)]
    (if auto
      (watcher/start source-paths (fn [& _]
                                    (let [main-files (find-main-files source-paths)]
                                      (compile-less main-files options))))
      (let [main-files (find-main-files source-paths)]
        (compile-less main-files options)))))

(defn start [options]
  (build (assoc options :auto true)))

(defn stop [this]
  (if this
    (watcher/stop this)))

