;; NOTE: This namespace is generated by compojure.api.dev.gen
(ns compojure.api.upload (:require ring.middleware.multipart-params ring.swagger.upload))
(def ^{:arglists (quote ([handler] [handler options])), :doc "Middleware to parse multipart parameters from a request. Adds the\n  following keys to the request map:\n\n  :multipart-params - a map of multipart parameters\n  :params           - a merged map of all types of parameter\n\n  The following options are accepted\n\n  :encoding          - character encoding to use for multipart parsing.\n                       Overrides the encoding specified in the request. If not\n                       specified, uses the encoding specified in a part named\n                       \"_charset_\", or the content type for each part, or\n                       request character encoding if the part has no encoding,\n                       or \"UTF-8\" if no request character encoding is set.\n\n  :fallback-encoding - specifies the character encoding used in parsing if a\n                       part of the request does not specify encoding in its\n                       content type or no part named \"_charset_\" is present.\n                       Has no effect if :encoding is also set.\n\n  :store             - a function that stores a file upload. The function\n                       should expect a map with :filename, content-type and\n                       :stream keys, and its return value will be used as the\n                       value for the parameter in the multipart parameter map.\n                       The default storage function is the temp-file-store.\n\n  :progress-fn       - a function that gets called during uploads. The\n                       function should expect four parameters: request,\n                       bytes-read, content-length, and item-count."} wrap-multipart-params ring.middleware.multipart-params/wrap-multipart-params)
(def ^{:doc "Schema for file param created by ring.middleware.multipart-params.temp-file store."} TempFileUpload ring.swagger.upload/TempFileUpload)
(def ^{:doc "Schema for file param created by ring.middleware.multipart-params.byte-array store."} ByteArrayUpload ring.swagger.upload/ByteArrayUpload)
