/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.Image;
import com.leapmotion.leap.Interface;
import com.leapmotion.leap.LeapJNI;
import java.util.Iterator;

public class ImageList
extends Interface
implements Iterable<Image> {
    private long swigCPtr;

    public ImageList(long l, boolean bl) {
        super(LeapJNI.ImageList_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    public static long getCPtr(ImageList imageList) {
        return imageList == null ? 0L : imageList.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_ImageList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    @Override
    public Iterator<Image> iterator() {
        return new ImageListIterator();
    }

    public ImageList() {
        this(LeapJNI.new_ImageList(), true);
    }

    public int count() {
        return LeapJNI.ImageList_count(this.swigCPtr, this);
    }

    public boolean isEmpty() {
        return LeapJNI.ImageList_isEmpty(this.swigCPtr, this);
    }

    public Image get(int n) {
        return new Image(LeapJNI.ImageList_get(this.swigCPtr, this, n), true);
    }

    public ImageList append(ImageList imageList) {
        return new ImageList(LeapJNI.ImageList_append(this.swigCPtr, this, ImageList.getCPtr(imageList), imageList), false);
    }

    public class ImageListIterator
    implements Iterator<Image> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ImageList.this.count();
        }

        @Override
        public Image next() {
            return ImageList.this.get(this.index++);
        }

        @Override
        public void remove() {
        }
    }
}

