/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.LeapJNI;
import com.leapmotion.leap.Vector;

public class Matrix {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public Matrix(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(Matrix matrix) {
        return matrix == null ? 0L : matrix.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_Matrix(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public float[] toArray3x3(float[] fArray) {
        fArray[0] = this.getXBasis().getX();
        fArray[1] = this.getXBasis().getY();
        fArray[2] = this.getXBasis().getZ();
        fArray[3] = this.getYBasis().getX();
        fArray[4] = this.getYBasis().getY();
        fArray[5] = this.getYBasis().getZ();
        fArray[6] = this.getZBasis().getX();
        fArray[7] = this.getZBasis().getY();
        fArray[8] = this.getZBasis().getZ();
        return fArray;
    }

    public double[] toArray3x3(double[] dArray) {
        dArray[0] = this.getXBasis().getX();
        dArray[1] = this.getXBasis().getY();
        dArray[2] = this.getXBasis().getZ();
        dArray[3] = this.getYBasis().getX();
        dArray[4] = this.getYBasis().getY();
        dArray[5] = this.getYBasis().getZ();
        dArray[6] = this.getZBasis().getX();
        dArray[7] = this.getZBasis().getY();
        dArray[8] = this.getZBasis().getZ();
        return dArray;
    }

    public float[] toArray3x3() {
        return this.toArray3x3(new float[9]);
    }

    public float[] toArray4x4(float[] fArray) {
        fArray[0] = this.getXBasis().getX();
        fArray[1] = this.getXBasis().getY();
        fArray[2] = this.getXBasis().getZ();
        fArray[3] = 0.0f;
        fArray[4] = this.getYBasis().getX();
        fArray[5] = this.getYBasis().getY();
        fArray[6] = this.getYBasis().getZ();
        fArray[7] = 0.0f;
        fArray[8] = this.getZBasis().getX();
        fArray[9] = this.getZBasis().getY();
        fArray[10] = this.getZBasis().getZ();
        fArray[11] = 0.0f;
        fArray[12] = this.getOrigin().getX();
        fArray[13] = this.getOrigin().getY();
        fArray[14] = this.getOrigin().getZ();
        fArray[15] = 1.0f;
        return fArray;
    }

    public double[] toArray4x4(double[] dArray) {
        dArray[0] = this.getXBasis().getX();
        dArray[1] = this.getXBasis().getY();
        dArray[2] = this.getXBasis().getZ();
        dArray[3] = 0.0;
        dArray[4] = this.getYBasis().getX();
        dArray[5] = this.getYBasis().getY();
        dArray[6] = this.getYBasis().getZ();
        dArray[7] = 0.0;
        dArray[8] = this.getZBasis().getX();
        dArray[9] = this.getZBasis().getY();
        dArray[10] = this.getZBasis().getZ();
        dArray[11] = 0.0;
        dArray[12] = this.getOrigin().getX();
        dArray[13] = this.getOrigin().getY();
        dArray[14] = this.getOrigin().getZ();
        dArray[15] = 1.0;
        return dArray;
    }

    public float[] toArray4x4() {
        return this.toArray4x4(new float[16]);
    }

    public Matrix() {
        this(LeapJNI.new_Matrix__SWIG_0(), true);
    }

    public Matrix(Matrix matrix) {
        this(LeapJNI.new_Matrix__SWIG_1(Matrix.getCPtr(matrix), matrix), true);
    }

    public Matrix(Vector vector, Vector vector2, Vector vector3) {
        this(LeapJNI.new_Matrix__SWIG_2(Vector.getCPtr(vector), vector, Vector.getCPtr(vector2), vector2, Vector.getCPtr(vector3), vector3), true);
    }

    public Matrix(Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this(LeapJNI.new_Matrix__SWIG_3(Vector.getCPtr(vector), vector, Vector.getCPtr(vector2), vector2, Vector.getCPtr(vector3), vector3, Vector.getCPtr(vector4), vector4), true);
    }

    public Matrix(Vector vector, float f) {
        this(LeapJNI.new_Matrix__SWIG_4(Vector.getCPtr(vector), vector, f), true);
    }

    public Matrix(Vector vector, float f, Vector vector2) {
        this(LeapJNI.new_Matrix__SWIG_5(Vector.getCPtr(vector), vector, f, Vector.getCPtr(vector2), vector2), true);
    }

    public static Matrix identity() {
        return new Matrix(LeapJNI.Matrix_identity(), false);
    }

    public void setRotation(Vector vector, float f) {
        LeapJNI.Matrix_setRotation(this.swigCPtr, this, Vector.getCPtr(vector), vector, f);
    }

    public Vector transformPoint(Vector vector) {
        return new Vector(LeapJNI.Matrix_transformPoint(this.swigCPtr, this, Vector.getCPtr(vector), vector), true);
    }

    public Vector transformDirection(Vector vector) {
        return new Vector(LeapJNI.Matrix_transformDirection(this.swigCPtr, this, Vector.getCPtr(vector), vector), true);
    }

    public Matrix rigidInverse() {
        return new Matrix(LeapJNI.Matrix_rigidInverse(this.swigCPtr, this), true);
    }

    public Matrix times(Matrix matrix) {
        return new Matrix(LeapJNI.Matrix_times(this.swigCPtr, this, Matrix.getCPtr(matrix), matrix), true);
    }

    public boolean equals(Matrix matrix) {
        return LeapJNI.Matrix_equals(this.swigCPtr, this, Matrix.getCPtr(matrix), matrix);
    }

    public String toString() {
        return LeapJNI.Matrix_toString(this.swigCPtr, this);
    }

    public void setXBasis(Vector vector) {
        LeapJNI.Matrix_xBasis_set(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public Vector getXBasis() {
        long l = LeapJNI.Matrix_xBasis_get(this.swigCPtr, this);
        return l == 0L ? null : new Vector(l, false);
    }

    public void setYBasis(Vector vector) {
        LeapJNI.Matrix_yBasis_set(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public Vector getYBasis() {
        long l = LeapJNI.Matrix_yBasis_get(this.swigCPtr, this);
        return l == 0L ? null : new Vector(l, false);
    }

    public void setZBasis(Vector vector) {
        LeapJNI.Matrix_zBasis_set(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public Vector getZBasis() {
        long l = LeapJNI.Matrix_zBasis_get(this.swigCPtr, this);
        return l == 0L ? null : new Vector(l, false);
    }

    public void setOrigin(Vector vector) {
        LeapJNI.Matrix_origin_set(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public Vector getOrigin() {
        long l = LeapJNI.Matrix_origin_get(this.swigCPtr, this);
        return l == 0L ? null : new Vector(l, false);
    }
}

