(ns schema-tools.walk
  (:require [schema.core :as s]))

(defprotocol WalkableSchema
  (-walk [this inner outer]))

      
(defn- record? [x]
  (satisfies? IRecord x))

(defn walk
  {:added "0.3.0"}
  [this inner outer]
  (cond
    (satisfies? WalkableSchema this) (-walk this inner outer)
    (record? this) (outer (with-meta (reduce (fn [r x] (conj r (inner x))) this this) (meta this)))
                                                                                          
    (seq? this) (outer (with-meta (doall (map inner this)) (meta this)))
    (coll? this) (outer (with-meta (into (empty this) (map inner this)) (meta this)))
    :else (outer this)))

(extend-protocol WalkableSchema
       
                        
       
                           
                                   

  schema.core.Maybe
  (-walk [this inner outer]
    (outer (with-meta (s/maybe (inner (:schema this))) (meta this))))

  schema.core.Both
  (-walk [this inner outer]
    (outer (with-meta (apply s/both (map inner (:schemas this))) (meta this))))

  schema.core.Either
  (-walk [this inner outer]
    (outer (with-meta (apply s/either (map inner (:schemas this))) (meta this))))

       
                       
       
                           
                                                                            

  schema.core.Predicate
  (-walk [this inner outer]
    (outer this))

  schema.core.NamedSchema
  (-walk [this inner outer]
    (outer (with-meta (s/named (inner (:schema this)) (:name this)) (meta this)))))

;;;;;;;;;;;; This file autogenerated from src/schema_tools/walk.cljx
