(ns user)

(require '[clojure.spec :as s])
(require '[spec-tools.core :as st])
(require '[spec-tools.json-schema :as jsc])

(s/def ::age (s/and clojure.core/integer? #(> % 18)))

(def person-spec
  (st/coll-spec
   ::person
   {::id clojure.core/integer?
    :age ::age
    :name clojure.core/string?
    :likes {clojure.core/string? clojure.core/boolean?}
    (st/req :languages) #{clojure.core/keyword?}
    (st/opt :address) {:street clojure.core/string?
                       :zip clojure.core/string?}}))
