(ns deps-library.release
  (:require [clojure.edn :as edn]
            [clojure.java.io :as io]
            [clojure.java.shell :as sh]
            [deps-deploy.deps-deploy :as deps-deploy]
            [garamond.main :as garamond]
            [garamond.git :as git]
            [garamond.pom :as pom]
            [taoensso.timbre :as timbre]
            [hf.depstar.uberjar :as uberjar]))

(defn default-opts []
  {:jar/dir "target"
   :jar/name "project.jar"
   :jar/type :thin

   :version (:version (git/current-status))

   :repository {"clojars" {:url "https://clojars.org/repo"
                           :username (System/getenv "CLOJARS_USERNAME")
                           :password (System/getenv "CLOJARS_PASSWORD")}}})

(defn garamond-args [{:keys [group-id
                             artifact-id
                             scm-url
                             garamond-cli-args]}]
  ["--group-id" group-id
   "--artifact-id" artifact-id
   "--scm-url" scm-url])

(defn jar [opts args]
  (uberjar/uber-main opts args))

(defn pom [opts & args]
  (pom/generate! (:version (git/current-status)) opts)
  (apply garamond/-main (concat (garamond-args opts)
                                (:garamond-pom-args opts)
                                ["--pom"] args)))

(defn tag [opts & args]
  (apply garamond/-main (concat (garamond-args opts)
                                (:garamond-tag-args opts)
                                ["--tag"] args)))

(defn -main [& [command & args]]
  (let [opts (-> (io/file "release.edn")
                 (slurp)
                 (edn/read-string)
                 (->> (merge (default-opts))))
        jar-path (str (:jar/dir opts)
                      "/"
                      (:jar/name opts))

        ;; commands
        pom #(pom/generate! (:version opts) opts)
        jar #(uberjar/uber-main {:dest jar-path :jar (:jar/type opts)}
                                (:depstar/uber-main opts []))
        deploy #(deps-deploy/-main "deploy" jar-path)]
    (case command
      "tag" (apply tag opts (or (seq args) ["patch"]))
      "build-deploy" (do
                       (timbre/set-level! :warn)
                       (pom)
                       (jar)
                       ;(sh/sh "cp" "pom.xml" (:jar/dir opts))
                       (deploy))
      "pom" (pom)
      "jar" (jar)
      "deploy" (deploy)
      nil (-main "build-deploy"))
    (System/exit 0)))
