(defproject middlesphere/util "0.3.0"
  :description "Collection of useful functions: util, logging, metrics, monitoring."
  :url "https://github.com/mikeananev/util"
  :license {:name "EPL-2.0"
            :url  "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.10.1"]

                 ;;logs
                 [io.pedestal/pedestal.log "0.5.5"]

                 ;; metrics
                 [io.dropwizard.metrics/metrics-core "4.1.0"]
                 [io.dropwizard.metrics/metrics-jvm "4.1.0"]
                 [io.dropwizard.metrics/metrics-healthchecks "4.1.0"]

                 ;;prometheus metrics
                 [io.prometheus/simpleclient_dropwizard "0.6.0"]

                 [com.google.code.findbugs/annotations "3.0.1"]]

  :jvm-opts ["-Dclojure.compiler.direct-linking=true"]

  :java-source-paths ["java"]

  ;;lein deploy clojars
  :deploy-repositories {"releases" {:url "https://repo.clojars.org" :creds :gpg}}

  :profiles {:dev      {:resource-paths ["env/dev/resources"]
                        :source-paths   ["env/dev/src"]}

             :provided {:dependencies [
                                       ;; choose between log4j2 or logback

                                       ;; log4j2
                                       [org.apache.logging.log4j/log4j-core "2.11.2"]
                                       [org.apache.logging.log4j/log4j-slf4j-impl "2.11.2"]
                                       [com.lmax/disruptor "3.4.2"]

                                       ;; logback
                                       ;; [ch.qos.logback/logback-classic "1.2.3"]
                                       ]}})
