(ns clj-branca.crypto
  (:import (com.goterl.lazycode.lazysodium LazySodiumJava SodiumJava)
           com.goterl.lazycode.lazysodium.interfaces.AEAD))

#_(set! *warn-on-reflection* true)

(def sodium (delay (SodiumJava.)))
(def lazy-sodium (delay (LazySodiumJava. @sodium)))

(def +key-length+ AEAD/XCHACHA20POLY1305_IETF_KEYBYTES)

(defn generate-key
  "Generate a new encryption key.

  Returns the generated key as a byte array."
  []
  (.randomBytesBuf ^LazySodiumJava @lazy-sodium +key-length+))

(defn random-bytes [n]
  (.randomBytesBuf ^LazySodiumJava @lazy-sodium n))

(defn encrypt [msg ad n k]
  (let [out (byte-array (+ (count msg) 16))
        ret (.crypto_aead_xchacha20poly1305_ietf_encrypt
             ^SodiumJava @sodium
             out
             nil
             msg
             (count msg)
             ad
             (count ad)
             nil
             n
             k)]
    (when (= 0 ret)
      out)))

(defn decrypt [c ad n k]
  (let [out-length (- (count c) 16)]
    (when (>= out-length 0)
      (let [out (byte-array out-length)
            ret (.crypto_aead_xchacha20poly1305_ietf_decrypt
                 ^SodiumJava @sodium
                 out
                 nil
                 nil
                 c
                 (count c)
                 ad
                 (count ad)
                 n
                 k)]
        (when (= 0 ret)
          out)))))
