(ns leiningen.new.mikm-app
  (:require [leiningen.new.templates :refer [renderer year date project-name
                                             ->files sanitize-ns name-to-path
                                             multi-segment]]
            [leiningen.core.main :as main]))

(defn mikm-app
  "FIXME: write documentation"
  [name]
  (let [render (renderer "mikm-app")
        main-ns (multi-segment (sanitize-ns name))
        data {:raw-name name
              :name (project-name name)
              :namespace main-ns
              :nested-dirs (name-to-path main-ns)
              :year (year)
              :date (date)}]
    (main/info "Generating fresh 'lein new' mikm-app project.")
    (->files data
             ["src/{{nested-dirs}}.clj" (render "core.clj" data)]
             ["README.md" (render "README.md" data)]
             [".gitignore" (render ".gitignore" data)]
             ["LICENSE" (render "LICENSE" data)]
             ["test/{{nested-dirs}}_test.clj" (render "test.clj" data)]
             ["project.clj" (render "project.clj" data)]
             "resources")))
