package faiss;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;

import java.io.File;
import java.io.IOException;


public class FaissNative {

  public static native String faiss_get_last_error();

  public static native int faiss_index_factory(PointerByReference pIndex, int d, String description, int metric);

  public static native void faiss_Index_free(Pointer index);

  public static native int faiss_Index_is_trained(Pointer index);

  public static native int faiss_Index_train(Pointer index, long n, Pointer x);

  public static native int faiss_Index_add(Pointer index, long n, Pointer x);

  public static native int faiss_Index_add_with_ids(Pointer index, long n, Pointer x, Pointer ids);

  public static native int faiss_Index_search(Pointer index, long n, Pointer x, long k, Pointer distances, Pointer labels);

  // TODO RangeSearchResult struct
  public static native int faiss_Index_range_search(Pointer index, long n, Pointer x, float radius, Pointer result);

  public static native int faiss_Index_assign(Pointer index, long n, Pointer x, Pointer labels, long k);

  public static native int faiss_Index_reset(Pointer index);

  // TODO FaissIDSelector struct
  public static native int faiss_Index_remove_ids(Pointer index, Pointer sel, Pointer n_removed);

  static {
    String osName = System.getProperty("os.name", "Unknown");
    switch (osName) {
      case "Mac OS X":
        loadNativeLib("libfaiss_osx.dylib");
        break;
      default:
        throw new LinkageError("Non-supported OS: " + osName);
    }
  }

  private static void loadNativeLib(String resourceName) {
    try {
      File lib = Native.extractFromResourcePath(resourceName);
      Native.register(lib.getAbsolutePath());
    } catch (IOException e) {
      throw new LinkageError("Can't load native Faiss library " + resourceName, e);
    }
  }
}


/*

package org.tsers.faiss.impl;

public class faisswrap implements faisswrapConstants {
  public static String faiss_get_last_error() {
    return faisswrapJNI.faiss_get_last_error();
  }

  public static void faiss_Index_free(SWIGTYPE_p_FaissIndex_H obj) {
    faisswrapJNI.faiss_Index_free(SWIGTYPE_p_FaissIndex_H.getCPtr(obj));
  }

  public static int faiss_Index_d(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_Index_d(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static int faiss_Index_is_trained(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_Index_is_trained(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static int faiss_Index_ntotal(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_Index_ntotal(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static FaissMetricType faiss_Index_metric_type(SWIGTYPE_p_FaissIndex_H arg0) {
    return FaissMetricType.swigToEnum(faisswrapJNI.faiss_Index_metric_type(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0)));
  }

  public static int faiss_Index_train(SWIGTYPE_p_FaissIndex_H index, int n, SWIGTYPE_p_float x) {
    return faisswrapJNI.faiss_Index_train(SWIGTYPE_p_FaissIndex_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x));
  }

  public static int faiss_Index_add(SWIGTYPE_p_FaissIndex_H index, int n, SWIGTYPE_p_float x) {
    return faisswrapJNI.faiss_Index_add(SWIGTYPE_p_FaissIndex_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x));
  }

  public static int faiss_Index_add_with_ids(SWIGTYPE_p_FaissIndex_H index, int n, SWIGTYPE_p_float x, SWIGTYPE_p_long xids) {
    return faisswrapJNI.faiss_Index_add_with_ids(SWIGTYPE_p_FaissIndex_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_long.getCPtr(xids));
  }

  public static int faiss_Index_search(SWIGTYPE_p_FaissIndex_H index, int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
    return faisswrapJNI.faiss_Index_search(SWIGTYPE_p_FaissIndex_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
  }

  public static int faiss_Index_range_search(SWIGTYPE_p_FaissIndex_H index, int n, SWIGTYPE_p_float x, float radius, SWIGTYPE_p_FaissRangeSearchResult_H result) {
    return faisswrapJNI.faiss_Index_range_search(SWIGTYPE_p_FaissIndex_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x), radius, SWIGTYPE_p_FaissRangeSearchResult_H.getCPtr(result));
  }

  public static int faiss_Index_assign(SWIGTYPE_p_FaissIndex_H index, int n, SWIGTYPE_p_float x, SWIGTYPE_p_long labels, int k) {
    return faisswrapJNI.faiss_Index_assign(SWIGTYPE_p_FaissIndex_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_long.getCPtr(labels), k);
  }

  public static int faiss_Index_reset(SWIGTYPE_p_FaissIndex_H index) {
    return faisswrapJNI.faiss_Index_reset(SWIGTYPE_p_FaissIndex_H.getCPtr(index));
  }

  public static int faiss_Index_remove_ids(SWIGTYPE_p_FaissIndex_H index, SWIGTYPE_p_FaissIDSelector_H sel, SWIGTYPE_p_long n_removed) {
    return faisswrapJNI.faiss_Index_remove_ids(SWIGTYPE_p_FaissIndex_H.getCPtr(index), SWIGTYPE_p_FaissIDSelector_H.getCPtr(sel), SWIGTYPE_p_long.getCPtr(n_removed));
  }

  public static int faiss_Index_reconstruct(SWIGTYPE_p_FaissIndex_H index, int key, SWIGTYPE_p_float recons) {
    return faisswrapJNI.faiss_Index_reconstruct(SWIGTYPE_p_FaissIndex_H.getCPtr(index), key, SWIGTYPE_p_float.getCPtr(recons));
  }

  public static int faiss_Index_reconstruct_n(SWIGTYPE_p_FaissIndex_H index, int i0, int ni, SWIGTYPE_p_float recons) {
    return faisswrapJNI.faiss_Index_reconstruct_n(SWIGTYPE_p_FaissIndex_H.getCPtr(index), i0, ni, SWIGTYPE_p_float.getCPtr(recons));
  }

  public static int faiss_Index_compute_residual(SWIGTYPE_p_FaissIndex_H index, SWIGTYPE_p_float x, SWIGTYPE_p_float residual, int key) {
    return faisswrapJNI.faiss_Index_compute_residual(SWIGTYPE_p_FaissIndex_H.getCPtr(index), SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_float.getCPtr(residual), key);
  }

  public static int faiss_Index_display(SWIGTYPE_p_FaissIndex_H index) {
    return faisswrapJNI.faiss_Index_display(SWIGTYPE_p_FaissIndex_H.getCPtr(index));
  }

  public static int faiss_index_factory(SWIGTYPE_p_p_FaissIndex_H p_index, int d, String description, FaissMetricType metric) {
    return faisswrapJNI.faiss_index_factory(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d, description, metric.swigValue());
  }

  public static String faiss_ParameterRange_name(SWIGTYPE_p_FaissParameterRange_H arg0) {
    return faisswrapJNI.faiss_ParameterRange_name(SWIGTYPE_p_FaissParameterRange_H.getCPtr(arg0));
  }

  public static void faiss_ParameterRange_values(SWIGTYPE_p_FaissParameterRange_H arg0, SWIGTYPE_p_p_double arg1, SWIGTYPE_p_size_t arg2) {
    faisswrapJNI.faiss_ParameterRange_values(SWIGTYPE_p_FaissParameterRange_H.getCPtr(arg0), SWIGTYPE_p_p_double.getCPtr(arg1), SWIGTYPE_p_size_t.getCPtr(arg2));
  }

  public static int faiss_ParameterSpace_new(SWIGTYPE_p_p_FaissParameterSpace_H space) {
    return faisswrapJNI.faiss_ParameterSpace_new(SWIGTYPE_p_p_FaissParameterSpace_H.getCPtr(space));
  }

  public static long faiss_ParameterSpace_n_combinations(SWIGTYPE_p_FaissParameterSpace_H arg0) {
    return faisswrapJNI.faiss_ParameterSpace_n_combinations(SWIGTYPE_p_FaissParameterSpace_H.getCPtr(arg0));
  }

  public static int faiss_ParameterSpace_combination_name(SWIGTYPE_p_FaissParameterSpace_H arg0, long arg1, String arg2, long arg3) {
    return faisswrapJNI.faiss_ParameterSpace_combination_name(SWIGTYPE_p_FaissParameterSpace_H.getCPtr(arg0), arg1, arg2, arg3);
  }

  public static int faiss_ParameterSpace_set_index_parameters(SWIGTYPE_p_FaissParameterSpace_H arg0, SWIGTYPE_p_FaissIndex_H arg1, String arg2) {
    return faisswrapJNI.faiss_ParameterSpace_set_index_parameters(SWIGTYPE_p_FaissParameterSpace_H.getCPtr(arg0), SWIGTYPE_p_FaissIndex_H.getCPtr(arg1), arg2);
  }

  public static int faiss_ParameterSpace_set_index_parameters_cno(SWIGTYPE_p_FaissParameterSpace_H arg0, SWIGTYPE_p_FaissIndex_H arg1, long arg2) {
    return faisswrapJNI.faiss_ParameterSpace_set_index_parameters_cno(SWIGTYPE_p_FaissParameterSpace_H.getCPtr(arg0), SWIGTYPE_p_FaissIndex_H.getCPtr(arg1), arg2);
  }

  public static int faiss_ParameterSpace_set_index_parameter(SWIGTYPE_p_FaissParameterSpace_H arg0, SWIGTYPE_p_FaissIndex_H arg1, String arg2, double arg3) {
    return faisswrapJNI.faiss_ParameterSpace_set_index_parameter(SWIGTYPE_p_FaissParameterSpace_H.getCPtr(arg0), SWIGTYPE_p_FaissIndex_H.getCPtr(arg1), arg2, arg3);
  }

  public static void faiss_ParameterSpace_display(SWIGTYPE_p_FaissParameterSpace_H arg0) {
    faisswrapJNI.faiss_ParameterSpace_display(SWIGTYPE_p_FaissParameterSpace_H.getCPtr(arg0));
  }

  public static int faiss_ParameterSpace_add_range(SWIGTYPE_p_FaissParameterSpace_H arg0, String arg1, SWIGTYPE_p_p_FaissParameterRange_H arg2) {
    return faisswrapJNI.faiss_ParameterSpace_add_range(SWIGTYPE_p_FaissParameterSpace_H.getCPtr(arg0), arg1, SWIGTYPE_p_p_FaissParameterRange_H.getCPtr(arg2));
  }

  public static long faiss_RangeSearchResult_nq(SWIGTYPE_p_FaissRangeSearchResult_H arg0) {
    return faisswrapJNI.faiss_RangeSearchResult_nq(SWIGTYPE_p_FaissRangeSearchResult_H.getCPtr(arg0));
  }

  public static int faiss_RangeSearchResult_new(SWIGTYPE_p_p_FaissRangeSearchResult_H p_rsr, int nq) {
    return faisswrapJNI.faiss_RangeSearchResult_new(SWIGTYPE_p_p_FaissRangeSearchResult_H.getCPtr(p_rsr), nq);
  }

  public static int faiss_RangeSearchResult_new_with(SWIGTYPE_p_p_FaissRangeSearchResult_H p_rsr, int nq, int alloc_lims) {
    return faisswrapJNI.faiss_RangeSearchResult_new_with(SWIGTYPE_p_p_FaissRangeSearchResult_H.getCPtr(p_rsr), nq, alloc_lims);
  }

  public static int faiss_RangeSearchResult_do_allocation(SWIGTYPE_p_FaissRangeSearchResult_H rsr) {
    return faisswrapJNI.faiss_RangeSearchResult_do_allocation(SWIGTYPE_p_FaissRangeSearchResult_H.getCPtr(rsr));
  }

  public static void faiss_RangeSearchResult_free(SWIGTYPE_p_FaissRangeSearchResult_H obj) {
    faisswrapJNI.faiss_RangeSearchResult_free(SWIGTYPE_p_FaissRangeSearchResult_H.getCPtr(obj));
  }

  public static long faiss_RangeSearchResult_buffer_size(SWIGTYPE_p_FaissRangeSearchResult_H arg0) {
    return faisswrapJNI.faiss_RangeSearchResult_buffer_size(SWIGTYPE_p_FaissRangeSearchResult_H.getCPtr(arg0));
  }

  public static void faiss_RangeSearchResult_lims(SWIGTYPE_p_FaissRangeSearchResult_H rsr, SWIGTYPE_p_p_size_t lims) {
    faisswrapJNI.faiss_RangeSearchResult_lims(SWIGTYPE_p_FaissRangeSearchResult_H.getCPtr(rsr), SWIGTYPE_p_p_size_t.getCPtr(lims));
  }

  public static void faiss_RangeSearchResult_labels(SWIGTYPE_p_FaissRangeSearchResult_H rsr, SWIGTYPE_p_p_long labels, SWIGTYPE_p_p_float distances) {
    faisswrapJNI.faiss_RangeSearchResult_labels(SWIGTYPE_p_FaissRangeSearchResult_H.getCPtr(rsr), SWIGTYPE_p_p_long.getCPtr(labels), SWIGTYPE_p_p_float.getCPtr(distances));
  }

  public static void faiss_IDSelector_free(SWIGTYPE_p_FaissIDSelector_H obj) {
    faisswrapJNI.faiss_IDSelector_free(SWIGTYPE_p_FaissIDSelector_H.getCPtr(obj));
  }

  public static int faiss_IDSelector_is_member(SWIGTYPE_p_FaissIDSelector_H sel, int id) {
    return faisswrapJNI.faiss_IDSelector_is_member(SWIGTYPE_p_FaissIDSelector_H.getCPtr(sel), id);
  }

  public static void faiss_IDSelectorRange_free(SWIGTYPE_p_FaissIDSelectorRange_H obj) {
    faisswrapJNI.faiss_IDSelectorRange_free(SWIGTYPE_p_FaissIDSelectorRange_H.getCPtr(obj));
  }

  public static int faiss_IDSelectorRange_imin(SWIGTYPE_p_FaissIDSelectorRange_H arg0) {
    return faisswrapJNI.faiss_IDSelectorRange_imin(SWIGTYPE_p_FaissIDSelectorRange_H.getCPtr(arg0));
  }

  public static int faiss_IDSelectorRange_imax(SWIGTYPE_p_FaissIDSelectorRange_H arg0) {
    return faisswrapJNI.faiss_IDSelectorRange_imax(SWIGTYPE_p_FaissIDSelectorRange_H.getCPtr(arg0));
  }

  public static int faiss_IDSelectorRange_new(SWIGTYPE_p_p_FaissIDSelectorRange_H p_sel, int imin, int imax) {
    return faisswrapJNI.faiss_IDSelectorRange_new(SWIGTYPE_p_p_FaissIDSelectorRange_H.getCPtr(p_sel), imin, imax);
  }

  public static int faiss_IDSelectorBatch_nbits(SWIGTYPE_p_FaissIDSelectorBatch_H arg0) {
    return faisswrapJNI.faiss_IDSelectorBatch_nbits(SWIGTYPE_p_FaissIDSelectorBatch_H.getCPtr(arg0));
  }

  public static int faiss_IDSelectorBatch_mask(SWIGTYPE_p_FaissIDSelectorBatch_H arg0) {
    return faisswrapJNI.faiss_IDSelectorBatch_mask(SWIGTYPE_p_FaissIDSelectorBatch_H.getCPtr(arg0));
  }

  public static int faiss_IDSelectorBatch_new(SWIGTYPE_p_p_FaissIDSelectorBatch_H p_sel, int n, SWIGTYPE_p_long indices) {
    return faisswrapJNI.faiss_IDSelectorBatch_new(SWIGTYPE_p_p_FaissIDSelectorBatch_H.getCPtr(p_sel), n, SWIGTYPE_p_long.getCPtr(indices));
  }

  public static void faiss_BufferList_free(SWIGTYPE_p_FaissBufferList_H obj) {
    faisswrapJNI.faiss_BufferList_free(SWIGTYPE_p_FaissBufferList_H.getCPtr(obj));
  }

  public static long faiss_BufferList_buffer_size(SWIGTYPE_p_FaissBufferList_H arg0) {
    return faisswrapJNI.faiss_BufferList_buffer_size(SWIGTYPE_p_FaissBufferList_H.getCPtr(arg0));
  }

  public static long faiss_BufferList_wp(SWIGTYPE_p_FaissBufferList_H arg0) {
    return faisswrapJNI.faiss_BufferList_wp(SWIGTYPE_p_FaissBufferList_H.getCPtr(arg0));
  }

  public static int faiss_BufferList_append_buffer(SWIGTYPE_p_FaissBufferList_H bl) {
    return faisswrapJNI.faiss_BufferList_append_buffer(SWIGTYPE_p_FaissBufferList_H.getCPtr(bl));
  }

  public static int faiss_BufferList_new(SWIGTYPE_p_p_FaissBufferList_H p_bl, long buffer_size) {
    return faisswrapJNI.faiss_BufferList_new(SWIGTYPE_p_p_FaissBufferList_H.getCPtr(p_bl), buffer_size);
  }

  public static int faiss_BufferList_add(SWIGTYPE_p_FaissBufferList_H bl, int id, float dis) {
    return faisswrapJNI.faiss_BufferList_add(SWIGTYPE_p_FaissBufferList_H.getCPtr(bl), id, dis);
  }

  public static int faiss_BufferList_copy_range(SWIGTYPE_p_FaissBufferList_H bl, long ofs, long n, SWIGTYPE_p_long dest_ids, SWIGTYPE_p_float dest_dis) {
    return faisswrapJNI.faiss_BufferList_copy_range(SWIGTYPE_p_FaissBufferList_H.getCPtr(bl), ofs, n, SWIGTYPE_p_long.getCPtr(dest_ids), SWIGTYPE_p_float.getCPtr(dest_dis));
  }

  public static SWIGTYPE_p_FaissRangeSearchResult_H faiss_RangeSearchPartialResult_res(SWIGTYPE_p_FaissRangeSearchPartialResult_H arg0) {
    long cPtr = faisswrapJNI.faiss_RangeSearchPartialResult_res(SWIGTYPE_p_FaissRangeSearchPartialResult_H.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_FaissRangeSearchResult_H(cPtr, false);
  }

  public static int faiss_RangeSearchPartialResult_new(SWIGTYPE_p_p_FaissRangeSearchPartialResult_H p_res, SWIGTYPE_p_FaissRangeSearchResult_H res_in) {
    return faisswrapJNI.faiss_RangeSearchPartialResult_new(SWIGTYPE_p_p_FaissRangeSearchPartialResult_H.getCPtr(p_res), SWIGTYPE_p_FaissRangeSearchResult_H.getCPtr(res_in));
  }

  public static int faiss_RangeSearchPartialResult_finalize(SWIGTYPE_p_FaissRangeSearchPartialResult_H res) {
    return faisswrapJNI.faiss_RangeSearchPartialResult_finalize(SWIGTYPE_p_FaissRangeSearchPartialResult_H.getCPtr(res));
  }

  public static int faiss_RangeSearchPartialResult_set_lims(SWIGTYPE_p_FaissRangeSearchPartialResult_H res) {
    return faisswrapJNI.faiss_RangeSearchPartialResult_set_lims(SWIGTYPE_p_FaissRangeSearchPartialResult_H.getCPtr(res));
  }

  public static int faiss_RangeSearchPartialResult_set_result(SWIGTYPE_p_FaissRangeSearchPartialResult_H res, int incremental) {
    return faisswrapJNI.faiss_RangeSearchPartialResult_set_result(SWIGTYPE_p_FaissRangeSearchPartialResult_H.getCPtr(res), incremental);
  }

  public static int faiss_QueryResult_qno(SWIGTYPE_p_FaissQueryResult_H arg0) {
    return faisswrapJNI.faiss_QueryResult_qno(SWIGTYPE_p_FaissQueryResult_H.getCPtr(arg0));
  }

  public static long faiss_QueryResult_nres(SWIGTYPE_p_FaissQueryResult_H arg0) {
    return faisswrapJNI.faiss_QueryResult_nres(SWIGTYPE_p_FaissQueryResult_H.getCPtr(arg0));
  }

  public static SWIGTYPE_p_FaissRangeSearchPartialResult_H faiss_QueryResult_pres(SWIGTYPE_p_FaissQueryResult_H arg0) {
    long cPtr = faisswrapJNI.faiss_QueryResult_pres(SWIGTYPE_p_FaissQueryResult_H.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_FaissRangeSearchPartialResult_H(cPtr, false);
  }

  public static int faiss_RangeSearchPartialResult_new_result(SWIGTYPE_p_FaissRangeSearchPartialResult_H res, int qno, SWIGTYPE_p_p_FaissQueryResult_H qr) {
    return faisswrapJNI.faiss_RangeSearchPartialResult_new_result(SWIGTYPE_p_FaissRangeSearchPartialResult_H.getCPtr(res), qno, SWIGTYPE_p_p_FaissQueryResult_H.getCPtr(qr));
  }

  public static int faiss_QueryResult_add(SWIGTYPE_p_FaissQueryResult_H qr, float dis, int id) {
    return faisswrapJNI.faiss_QueryResult_add(SWIGTYPE_p_FaissQueryResult_H.getCPtr(qr), dis, id);
  }

  public static int faiss_write_index(SWIGTYPE_p_FaissIndex_H idx, SWIGTYPE_p_FILE f) {
    return faisswrapJNI.faiss_write_index(SWIGTYPE_p_FaissIndex_H.getCPtr(idx), SWIGTYPE_p_FILE.getCPtr(f));
  }

  public static int faiss_write_index_fname(SWIGTYPE_p_FaissIndex_H idx, String fname) {
    return faisswrapJNI.faiss_write_index_fname(SWIGTYPE_p_FaissIndex_H.getCPtr(idx), fname);
  }

  public static int faiss_read_index(SWIGTYPE_p_FILE f, int io_flags, SWIGTYPE_p_p_FaissIndex_H p_out) {
    return faisswrapJNI.faiss_read_index(SWIGTYPE_p_FILE.getCPtr(f), io_flags, SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_out));
  }

  public static int faiss_read_index_fname(String fname, int io_flags, SWIGTYPE_p_p_FaissIndex_H p_out) {
    return faisswrapJNI.faiss_read_index_fname(fname, io_flags, SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_out));
  }

  public static int faiss_clone_index(SWIGTYPE_p_FaissIndex_H arg0, SWIGTYPE_p_p_FaissIndex_H p_out) {
    return faisswrapJNI.faiss_clone_index(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0), SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_out));
  }

  public static int faiss_IndexFlat_new(SWIGTYPE_p_p_FaissIndex_H p_index) {
    return faisswrapJNI.faiss_IndexFlat_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index));
  }

  public static int faiss_IndexFlat_new_with(SWIGTYPE_p_p_FaissIndex_H p_index, int d, FaissMetricType metric) {
    return faisswrapJNI.faiss_IndexFlat_new_with(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d, metric.swigValue());
  }

  public static void faiss_IndexFlat_xb(SWIGTYPE_p_FaissIndex_H index, SWIGTYPE_p_p_float p_xb, SWIGTYPE_p_size_t p_size) {
    faisswrapJNI.faiss_IndexFlat_xb(SWIGTYPE_p_FaissIndex_H.getCPtr(index), SWIGTYPE_p_p_float.getCPtr(p_xb), SWIGTYPE_p_size_t.getCPtr(p_size));
  }

  public static SWIGTYPE_p_FaissIndex_H faiss_IndexFlat_cast(SWIGTYPE_p_FaissIndex_H arg0) {
    long cPtr = faisswrapJNI.faiss_IndexFlat_cast(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_FaissIndex_H(cPtr, false);
  }

  public static void faiss_IndexFlat_free(SWIGTYPE_p_FaissIndex_H obj) {
    faisswrapJNI.faiss_IndexFlat_free(SWIGTYPE_p_FaissIndex_H.getCPtr(obj));
  }

  public static int faiss_IndexFlat_compute_distance_subset(SWIGTYPE_p_FaissIndex_H index, int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
    return faisswrapJNI.faiss_IndexFlat_compute_distance_subset(SWIGTYPE_p_FaissIndex_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
  }

  public static int faiss_IndexFlatIP_new(SWIGTYPE_p_p_FaissIndex_H p_index) {
    return faisswrapJNI.faiss_IndexFlatIP_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index));
  }

  public static int faiss_IndexFlatIP_new_with(SWIGTYPE_p_p_FaissIndex_H p_index, int d) {
    return faisswrapJNI.faiss_IndexFlatIP_new_with(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d);
  }

  public static int faiss_IndexFlatL2_new(SWIGTYPE_p_p_FaissIndex_H p_index) {
    return faisswrapJNI.faiss_IndexFlatL2_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index));
  }

  public static int faiss_IndexFlatL2_new_with(SWIGTYPE_p_p_FaissIndex_H p_index, int d) {
    return faisswrapJNI.faiss_IndexFlatL2_new_with(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d);
  }

  public static int faiss_IndexFlatL2BaseShift_new(SWIGTYPE_p_p_FaissIndex_H p_index, int d, long nshift, SWIGTYPE_p_float shift) {
    return faisswrapJNI.faiss_IndexFlatL2BaseShift_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d, nshift, SWIGTYPE_p_float.getCPtr(shift));
  }

  public static int faiss_IndexRefineFlat_new(SWIGTYPE_p_p_FaissIndex_H p_index, SWIGTYPE_p_FaissIndex_H base_index) {
    return faisswrapJNI.faiss_IndexRefineFlat_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), SWIGTYPE_p_FaissIndex_H.getCPtr(base_index));
  }

  public static void faiss_IndexRefineFlat_free(SWIGTYPE_p_FaissIndex_H obj) {
    faisswrapJNI.faiss_IndexRefineFlat_free(SWIGTYPE_p_FaissIndex_H.getCPtr(obj));
  }

  public static int faiss_IndexFlat1D_new(SWIGTYPE_p_p_FaissIndex_H p_index) {
    return faisswrapJNI.faiss_IndexFlat1D_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index));
  }

  public static int faiss_IndexFlat1D_new_with(SWIGTYPE_p_p_FaissIndex_H p_index, int continuous_update) {
    return faisswrapJNI.faiss_IndexFlat1D_new_with(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), continuous_update);
  }

  public static int faiss_IndexFlat1D_update_permutation(SWIGTYPE_p_FaissIndex_H index) {
    return faisswrapJNI.faiss_IndexFlat1D_update_permutation(SWIGTYPE_p_FaissIndex_H.getCPtr(index));
  }

  public static void faiss_IndexIVF_free(SWIGTYPE_p_FaissIndex_H obj) {
    faisswrapJNI.faiss_IndexIVF_free(SWIGTYPE_p_FaissIndex_H.getCPtr(obj));
  }

  public static SWIGTYPE_p_FaissIndex_H faiss_IndexIVF_cast(SWIGTYPE_p_FaissIndex_H arg0) {
    long cPtr = faisswrapJNI.faiss_IndexIVF_cast(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_FaissIndex_H(cPtr, false);
  }

  public static long faiss_IndexIVF_nlist(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexIVF_nlist(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static long faiss_IndexIVF_nprobe(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexIVF_nprobe(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static SWIGTYPE_p_FaissIndex_H faiss_IndexIVF_quantizer(SWIGTYPE_p_FaissIndex_H arg0) {
    long cPtr = faisswrapJNI.faiss_IndexIVF_quantizer(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_FaissIndex_H(cPtr, false);
  }

  public static char faiss_IndexIVF_quantizer_trains_alone(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexIVF_quantizer_trains_alone(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static int faiss_IndexIVF_own_fields(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexIVF_own_fields(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static int faiss_IndexIVF_merge_from(SWIGTYPE_p_FaissIndex_H index, SWIGTYPE_p_FaissIndex_H other, int add_id) {
    return faisswrapJNI.faiss_IndexIVF_merge_from(SWIGTYPE_p_FaissIndex_H.getCPtr(index), SWIGTYPE_p_FaissIndex_H.getCPtr(other), add_id);
  }

  public static int faiss_IndexIVF_copy_subset_to(SWIGTYPE_p_FaissIndex_H index, SWIGTYPE_p_FaissIndex_H other, int subset_type, int a1, int a2) {
    return faisswrapJNI.faiss_IndexIVF_copy_subset_to(SWIGTYPE_p_FaissIndex_H.getCPtr(index), SWIGTYPE_p_FaissIndex_H.getCPtr(other), subset_type, a1, a2);
  }

  public static int faiss_IndexIVF_search_preassigned(SWIGTYPE_p_FaissIndex_H index, int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_long assign, SWIGTYPE_p_float centroid_dis, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels, int store_pairs) {
    return faisswrapJNI.faiss_IndexIVF_search_preassigned(SWIGTYPE_p_FaissIndex_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_long.getCPtr(assign), SWIGTYPE_p_float.getCPtr(centroid_dis), SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels), store_pairs);
  }

  public static long faiss_IndexIVF_get_list_size(SWIGTYPE_p_FaissIndex_H index, long list_no) {
    return faisswrapJNI.faiss_IndexIVF_get_list_size(SWIGTYPE_p_FaissIndex_H.getCPtr(index), list_no);
  }

  public static int faiss_IndexIVF_make_direct_map(SWIGTYPE_p_FaissIndex_H index, int new_maintain_direct_map) {
    return faisswrapJNI.faiss_IndexIVF_make_direct_map(SWIGTYPE_p_FaissIndex_H.getCPtr(index), new_maintain_direct_map);
  }

  public static double faiss_IndexIVF_imbalance_factor(SWIGTYPE_p_FaissIndex_H index) {
    return faisswrapJNI.faiss_IndexIVF_imbalance_factor(SWIGTYPE_p_FaissIndex_H.getCPtr(index));
  }

  public static void faiss_IndexIVF_print_stats(SWIGTYPE_p_FaissIndex_H index) {
    faisswrapJNI.faiss_IndexIVF_print_stats(SWIGTYPE_p_FaissIndex_H.getCPtr(index));
  }

  public static void faiss_IndexIVFStats_reset(FaissIndexIVFStats stats) {
    faisswrapJNI.faiss_IndexIVFStats_reset(FaissIndexIVFStats.getCPtr(stats), stats);
  }

  public static void faiss_IndexIVFStats_init(FaissIndexIVFStats stats) {
    faisswrapJNI.faiss_IndexIVFStats_init(FaissIndexIVFStats.getCPtr(stats), stats);
  }

  public static void faiss_IndexIVFFlat_free(SWIGTYPE_p_FaissIndexIVFFlat_H obj) {
    faisswrapJNI.faiss_IndexIVFFlat_free(SWIGTYPE_p_FaissIndexIVFFlat_H.getCPtr(obj));
  }

  public static int faiss_IndexIVFFlat_new(SWIGTYPE_p_p_FaissIndexIVFFlat_H p_index) {
    return faisswrapJNI.faiss_IndexIVFFlat_new(SWIGTYPE_p_p_FaissIndexIVFFlat_H.getCPtr(p_index));
  }

  public static int faiss_IndexIVFFlat_new_with(SWIGTYPE_p_p_FaissIndexIVFFlat_H p_index, SWIGTYPE_p_FaissIndex_H quantizer, long d, long nlist) {
    return faisswrapJNI.faiss_IndexIVFFlat_new_with(SWIGTYPE_p_p_FaissIndexIVFFlat_H.getCPtr(p_index), SWIGTYPE_p_FaissIndex_H.getCPtr(quantizer), d, nlist);
  }

  public static int faiss_IndexIVFFlat_new_with_metric(SWIGTYPE_p_p_FaissIndexIVFFlat_H p_index, SWIGTYPE_p_FaissIndex_H quantizer, long d, long nlist, FaissMetricType metric) {
    return faisswrapJNI.faiss_IndexIVFFlat_new_with_metric(SWIGTYPE_p_p_FaissIndexIVFFlat_H.getCPtr(p_index), SWIGTYPE_p_FaissIndex_H.getCPtr(quantizer), d, nlist, metric.swigValue());
  }

  public static int faiss_IndexIVFFlat_add_core(SWIGTYPE_p_FaissIndexIVFFlat_H index, int n, SWIGTYPE_p_float x, SWIGTYPE_p_long xids, SWIGTYPE_p_long precomputed_idx) {
    return faisswrapJNI.faiss_IndexIVFFlat_add_core(SWIGTYPE_p_FaissIndexIVFFlat_H.getCPtr(index), n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_long.getCPtr(xids), SWIGTYPE_p_long.getCPtr(precomputed_idx));
  }

  public static int faiss_IndexIVFFlat_update_vectors(SWIGTYPE_p_FaissIndexIVFFlat_H index, int nv, SWIGTYPE_p_long idx, SWIGTYPE_p_float v) {
    return faisswrapJNI.faiss_IndexIVFFlat_update_vectors(SWIGTYPE_p_FaissIndexIVFFlat_H.getCPtr(index), nv, SWIGTYPE_p_long.getCPtr(idx), SWIGTYPE_p_float.getCPtr(v));
  }

  public static SWIGTYPE_p_FaissIndexIVFFlat_H faiss_IndexIVFFlat_cast(SWIGTYPE_p_FaissIndex_H arg0) {
    long cPtr = faisswrapJNI.faiss_IndexIVFFlat_cast(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_FaissIndexIVFFlat_H(cPtr, false);
  }

  public static void faiss_IndexLSH_free(SWIGTYPE_p_FaissIndex_H obj) {
    faisswrapJNI.faiss_IndexLSH_free(SWIGTYPE_p_FaissIndex_H.getCPtr(obj));
  }

  public static SWIGTYPE_p_FaissIndex_H faiss_IndexLSH_cast(SWIGTYPE_p_FaissIndex_H arg0) {
    long cPtr = faisswrapJNI.faiss_IndexLSH_cast(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
    return (cPtr == 0) ? null : new SWIGTYPE_p_FaissIndex_H(cPtr, false);
  }

  public static int faiss_IndexLSH_nbits(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexLSH_nbits(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static int faiss_IndexLSH_bytes_per_vec(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexLSH_bytes_per_vec(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static int faiss_IndexLSH_rotate_data(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexLSH_rotate_data(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static int faiss_IndexLSH_train_thresholds(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexLSH_train_thresholds(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static int faiss_IndexLSH_new(SWIGTYPE_p_p_FaissIndex_H p_index, int d, int nbits) {
    return faisswrapJNI.faiss_IndexLSH_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d, nbits);
  }

  public static int faiss_IndexLSH_new_with_options(SWIGTYPE_p_p_FaissIndex_H p_index, int d, int nbits, int rotate_data, int train_thresholds) {
    return faisswrapJNI.faiss_IndexLSH_new_with_options(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d, nbits, rotate_data, train_thresholds);
  }

  public static int faiss_IndexIDMap_own_fields(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexIDMap_own_fields(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static void faiss_IndexIDMap_set_own_fields(SWIGTYPE_p_FaissIndex_H arg0, int arg1) {
    faisswrapJNI.faiss_IndexIDMap_set_own_fields(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0), arg1);
  }

  public static int faiss_IndexIDMap_new(SWIGTYPE_p_p_FaissIndex_H p_index, SWIGTYPE_p_FaissIndex_H index) {
    return faisswrapJNI.faiss_IndexIDMap_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), SWIGTYPE_p_FaissIndex_H.getCPtr(index));
  }

  public static void faiss_IndexIDMap_id_map(SWIGTYPE_p_FaissIndex_H index, SWIGTYPE_p_p_long p_id_map, SWIGTYPE_p_size_t p_size) {
    faisswrapJNI.faiss_IndexIDMap_id_map(SWIGTYPE_p_FaissIndex_H.getCPtr(index), SWIGTYPE_p_p_long.getCPtr(p_id_map), SWIGTYPE_p_size_t.getCPtr(p_size));
  }

  public static int faiss_IndexIDMap2_new(SWIGTYPE_p_p_FaissIndexIDMap_H p_index, SWIGTYPE_p_FaissIndex_H index) {
    return faisswrapJNI.faiss_IndexIDMap2_new(SWIGTYPE_p_p_FaissIndexIDMap_H.getCPtr(p_index), SWIGTYPE_p_FaissIndex_H.getCPtr(index));
  }

  public static int faiss_IndexIDMap2_construct_rev_map(SWIGTYPE_p_FaissIndexIDMap_H index) {
    return faisswrapJNI.faiss_IndexIDMap2_construct_rev_map(SWIGTYPE_p_FaissIndexIDMap_H.getCPtr(index));
  }

  public static int faiss_IndexShards_own_fields(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexShards_own_fields(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static void faiss_IndexShards_set_own_fields(SWIGTYPE_p_FaissIndex_H arg0, int arg1) {
    faisswrapJNI.faiss_IndexShards_set_own_fields(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0), arg1);
  }

  public static int faiss_IndexShards_threaded(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexShards_threaded(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static void faiss_IndexShards_set_threaded(SWIGTYPE_p_FaissIndex_H arg0, int arg1) {
    faisswrapJNI.faiss_IndexShards_set_threaded(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0), arg1);
  }

  public static int faiss_IndexShards_successive_ids(SWIGTYPE_p_FaissIndex_H arg0) {
    return faisswrapJNI.faiss_IndexShards_successive_ids(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0));
  }

  public static void faiss_IndexShards_set_successive_ids(SWIGTYPE_p_FaissIndex_H arg0, int arg1) {
    faisswrapJNI.faiss_IndexShards_set_successive_ids(SWIGTYPE_p_FaissIndex_H.getCPtr(arg0), arg1);
  }

  public static int faiss_IndexShards_new(SWIGTYPE_p_p_FaissIndex_H p_index, int d) {
    return faisswrapJNI.faiss_IndexShards_new(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d);
  }

  public static int faiss_IndexShards_new_with_options(SWIGTYPE_p_p_FaissIndex_H p_index, int d, int threaded, int successive_ids) {
    return faisswrapJNI.faiss_IndexShards_new_with_options(SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_index), d, threaded, successive_ids);
  }

  public static void faiss_IndexShards_shard_indexes(SWIGTYPE_p_FaissIndex_H index, SWIGTYPE_p_p_FaissIndex_H p_shard_indexes, SWIGTYPE_p_size_t p_size) {
    faisswrapJNI.faiss_IndexShards_shard_indexes(SWIGTYPE_p_FaissIndex_H.getCPtr(index), SWIGTYPE_p_p_FaissIndex_H.getCPtr(p_shard_indexes), SWIGTYPE_p_size_t.getCPtr(p_size));
  }

  public static int faiss_IndexShards_add_shard(SWIGTYPE_p_FaissIndex_H index, SWIGTYPE_p_FaissIndex_H shard) {
    return faisswrapJNI.faiss_IndexShards_add_shard(SWIGTYPE_p_FaissIndex_H.getCPtr(index), SWIGTYPE_p_FaissIndex_H.getCPtr(shard));
  }

  public static int faiss_IndexShards_sync_with_shard_indexes(SWIGTYPE_p_FaissIndex_H index) {
    return faisswrapJNI.faiss_IndexShards_sync_with_shard_indexes(SWIGTYPE_p_FaissIndex_H.getCPtr(index));
  }

  public static SWIGTYPE_p_FaissIndex_H faiss_IndexShards_at(SWIGTYPE_p_FaissIndex_H index, int i) {
    long cPtr = faisswrapJNI.faiss_IndexShards_at(SWIGTYPE_p_FaissIndex_H.getCPtr(index), i);
    return (cPtr == 0) ? null : new SWIGTYPE_p_FaissIndex_H(cPtr, false);
  }

}

 */