(ns milesian.aop.utils
  (:require [clojure.string :as st]))

(defn format-function-invocation
  [pattern *fn* this args ]
  (let [component-key (:bigbang/key (meta this))
        [fn-name fn-args]((juxt :function-name :function-args) (meta *fn*))
        who (:bigbang/who (meta (:wrapper (meta *fn*))))
        formatted-args (-> (st/replace (str fn-args) #"\[" "")
                                           (st/replace #"\]" "")
                                           (st/split #" ")
                                           (next)
                                           ((partial st/join " " )))]
    (format pattern
            (if-not (nil? who) (name who) "REPL")
            (name component-key)
            fn-name
            formatted-args)))

(defn logging-function-invocation
  [*fn* this & args]
  (println (format-function-invocation "%s->%s: %s %s" *fn* this args))
  (apply *fn* (conj args this)))
