(in-ns 'miraj.polymer.layout)

;; (alter-meta! *ns* (fn [m] (assoc m :miraj/miraj {:miraj/elements true
;;                                                  :miraj/nss '[]
;;                                                  :miraj/codom ""
;;                                                  :miraj/assets
;;                                                  {:miraj/bower
;;                                                   [
;; "" 
;;                                                    ]
;;                                                    :miraj/base "/miraj/polymer/assets/"}})))

;;;;;;;; COMPONENT: miraj.polymer.layout/box ;;;;;;;;;;;;;;;;
(defn box
  "app-box is a container element that can have scroll effects - visual effects based on scroll position. For example, the parallax effect can be used to move an image at a slower rate than the foreground.

  https://www.webcomponents.org/element/PolymerElements/app-layout/app-box"
  [& args]
  (apply codom/element :app-box args))
(alter-meta! (find-var (symbol (str *ns*) "box"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :app-box
                            :miraj/lib :miraj.polymer.app
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-box/app-box.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/app-layout/app-box"}})

;;;;;;;; COMPONENT: miraj.polymer.layout/drawer ;;;;;;;;;;;;;;;;
(defn drawer
  "app-drawer is a navigation drawer that can slide in from the left or right.

  https://www.webcomponents.org/element/PolymerElements/app-layout/app-drawer"
  [& args]
  (apply codom/element :app-drawer args))
(alter-meta! (find-var (symbol (str *ns*) "drawer"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :app-drawer
                            :miraj/lib :miraj.polymer.app
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-drawer/app-drawer.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/app-layout/app-drawer"}})

;;;;;;;; COMPONENT: miraj.polymer.layout/drawer-layout ;;;;;;;;;;;;;;;;
(defn drawer-layout
  "app-drawer-layout is a wrapper element that positions an app-drawer and other content. When the viewport width is smaller than responsiveWidth, this element changes to narrow layout. In narrow layout, the drawer will be stacked on top of the main content. The drawer will slide in/out to hide/reveal the main content.

  https://www.webcomponents.org/element/PolymerElements/app-layout/app-drawer-layout"
  [& args]
  (apply codom/element :app-drawer-layout args))
(alter-meta! (find-var (symbol (str *ns*) "drawer-layout"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :app-drawer-layout
                            :miraj/lib :miraj.polymer.app
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-drawer-layout/app-drawer-layout.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/app-layout/app-drawer-layout"}})

;;;;;;;; COMPONENT: miraj.polymer.layout/grid ;;;;;;;;;;;;;;;;
(defn grid
  "app-grid is a helper class useful for creating responsive, fluid grid layouts using custom properties. Because custom properties can be defined inside a @media rule, you can customize the grid layout for different responsive breakpoints.

  https://www.webcomponents.org/element/PolymerElements/app-layout/app-grid"
  [& args]
  (apply codom/element :app-grid args))
(alter-meta! (find-var (symbol (str *ns*) "grid"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :app-grid
                            :miraj/lib :miraj.polymer.app
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-grid/app-grid.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/app-layout/app-grid"}})

;;;;;;;; COMPONENT: miraj.polymer.layout/header ;;;;;;;;;;;;;;;;
(defn header
  "

  https://www.webcomponents.org/element/PolymerElements/app-layout/app-header"
  [& args]
  (apply codom/element :app-header args))
(alter-meta! (find-var (symbol (str *ns*) "header"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :app-header
                            :miraj/lib :miraj.polymer.app
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-header/app-header.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/app-layout/app-header"}})

;;;;;;;; COMPONENT: miraj.polymer.layout/header-layout ;;;;;;;;;;;;;;;;
(defn header-layout
  "

  https://www.webcomponents.org/element/PolymerElements/app-layout/app-header-layout"
  [& args]
  (apply codom/element :app-header-layout args))
(alter-meta! (find-var (symbol (str *ns*) "header-layout"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :app-header-layout
                            :miraj/lib :miraj.polymer.app
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-header-layout/app-header-layout.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/app-layout/app-header-layout"}})

;;;;;;;; COMPONENT: miraj.polymer.layout/scroll-position ;;;;;;;;;;;;;;;;
(defn scroll-position
  "

  https://www.webcomponents.org/element/PolymerElements/app-layout/app-scrollpos-control"
  [& args]
  (apply codom/element :app-scrollpos-control args))
(alter-meta! (find-var (symbol (str *ns*) "scroll-position"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :app-scrollpos-control
                            :miraj/lib :miraj.polymer.app
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-scrollpos-control/app-scrollpos-control.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/app-layout/app-scrollpos-control"}})

;;;;;;;; COMPONENT: miraj.polymer.layout/toolbar ;;;;;;;;;;;;;;;;
(defn toolbar
  "

  https://www.webcomponents.org/element/PolymerElements/app-layout/app-toolbar"
  [& args]
  (apply codom/element :app-toolbar args))
(alter-meta! (find-var (symbol (str *ns*) "toolbar"))
             (fn [old new] (merge old new))
             {:miraj/miraj {:miraj/co-fn true
                            :miraj/element true
                            :miraj/html-tag :app-toolbar
                            :miraj/lib :miraj.polymer.app
                            :miraj/assets {:miraj/href "/miraj/polymer/assets/app-layout/app-toolbar/app-toolbar.html"
                                           :miraj/bower "PolymerElements/app-layout"}
                            :miraj/help "https://www.webcomponents.org/element/PolymerElements/app-layout/app-toolbar"}})



