(ns modelizer.edn
  (:refer-clojure :exclude [read-string])
  (:require
    [edamame.core :as edamame]
    [modelizer.core :as modelizer]))

(defn write-string
  [schema]
  (-> schema
    modelizer/unwrap
    (dissoc :validator :explainer :generator)
    pr-str))


(defn read-string
  [schema]
  (-> schema
    edamame/parse-string
    modelizer/schema))
