(ns modelizer.validator)

(defonce *predicate-registry
  (atom
    [#'any?
     #'nil?
     #'some?
     #'boolean?
     #'true?
     #'false?
     #'char?
     #'string?
     #'number?
     #'zero?
     #'even?
     #'odd?
     #'int?
     #'pos-int?
     #'neg-int?
     #'nat-int?
     #'float?
     #'double?
     #'integer?
     #'ident?
     #'simple-ident?
     #'qualified-ident?
     #'symbol?
     #'simple-symbol?
     #'qualified-symbol?
     #'keyword?
     #'simple-keyword?
     #'qualified-keyword?
     #'list?
     #'vector?
     #'map?
     #'set?
     #'special-symbol?
     #'var?
     #'tagged-literal?
     #'coll?
     #'empty?
     #'seq?
     #'seqable?
     #'sequential?
     #'associative?
     #'indexed?
     #'sorted?
     #'counted?
     #'reversible?
     #'fn?
     #'ifn?
     #'inst?
     #'uuid?
     #'uri?

     #?@(:clj
         [#'decimal?
          #'ratio?
          #'rational?
          #'bytes?
          #'class?
          #'reader-conditional?])]))
