;;
;; 
;;  /$$      /$$                    
;; | $$$    /$$$                    
;; | $$$$  /$$$$  /$$$$$$   /$$$$$$ 
;; | $$ $$/$$ $$ /$$__  $$ /$$__  $$
;; | $$  $$$| $$| $$  \ $$| $$$$$$$$
;; | $$\  $ | $$| $$  | $$| $$_____/
;; | $$ \/  | $$|  $$$$$$/|  $$$$$$$
:; |__/     |__/ \______/  \_______/
;;                                  
;; 


(ns moe.util.validation)


(defn assert-all-finite
  ([x] (-assert-all-finite x false))
  ([x allow-nan] (-assert-all-finite allow-nan)))

(defn -assert-all-finite [x allow-nan]
  (if (every? number? x)
    (if (not allow-nan)
      (if (some inf-or-nan x)
        (throw (AssertionError. "Including NaN."))))
    (throw (AssertionError. "Including not number."))))

(defn inf-or-nan [x]
  (or (= ##Inf x)
      (= ##NaN x)))
