/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.jdbc;

import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.monetdb.jdbc.MonetConnection;
import org.monetdb.jdbc.MonetVersion;
import org.monetdb.jdbc.MonetWrapper;
import org.monetdb.mcl.net.Parameter;
import org.monetdb.mcl.net.Target;
import org.monetdb.mcl.net.ValidationError;

public final class MonetDriver
implements Driver {
    private static final Map<String, Integer> typeMap;
    private static String TypeMapppingSQL;

    @Override
    public boolean acceptsURL(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("jdbc:monetdb:") || string.startsWith("jdbc:monetdbs:");
    }

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        try {
            Target target = new Target(string, properties);
            return new MonetConnection(target);
        }
        catch (URISyntaxException | ValidationError exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    @Override
    public int getMajorVersion() {
        return MonetVersion.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return MonetVersion.minorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        if (!this.acceptsURL(string)) {
            return null;
        }
        boolean bl = string.equals("jdbc:monetdb:") || string.startsWith("jdbc:monetdbs:");
        return Parameter.getPropertyInfo(properties, bl);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw MonetWrapper.newSQLFeatureNotSupportedException("getParentLogger");
    }

    public static final String getDriverVersion() {
        return MonetVersion.driverVersion;
    }

    static final int getJdbcSQLType(String string) {
        Integer n = typeMap.get(string);
        if (n != null) {
            return n;
        }
        return 1111;
    }

    static final Class<?> getClassForType(int n) {
        switch (n) {
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 16: {
                return Boolean.class;
            }
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case -3: 
            case -2: {
                return byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 2013: {
                return OffsetTime.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 2014: {
                return OffsetDateTime.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2004: {
                return Blob.class;
            }
        }
        return String.class;
    }

    static final String getSQLTypeMap(String string) {
        if (TypeMapppingSQL == null) {
            StringBuilder stringBuilder = new StringBuilder(typeMap.size() * 25 + 14);
            for (Map.Entry<String, Integer> entry : typeMap.entrySet()) {
                stringBuilder.append(" WHEN '").append(entry.getKey()).append("' THEN ").append(entry.getValue().toString());
            }
            stringBuilder.append(" ELSE 1111 END");
            TypeMapppingSQL = stringBuilder.toString();
        }
        return "CASE " + string + TypeMapppingSQL;
    }

    static {
        try {
            DriverManager.registerDriver(new MonetDriver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        typeMap = new HashMap<String, Integer>();
        typeMap.put("bigint", -5);
        typeMap.put("blob", 2004);
        typeMap.put("boolean", 16);
        typeMap.put("char", 1);
        typeMap.put("clob", 2005);
        typeMap.put("date", 91);
        typeMap.put("day_interval", 2);
        typeMap.put("decimal", 3);
        typeMap.put("double", 8);
        typeMap.put("hugeint", 2);
        typeMap.put("inet", 12);
        typeMap.put("int", 4);
        typeMap.put("json", 12);
        typeMap.put("month_interval", 4);
        typeMap.put("oid", -5);
        typeMap.put("real", 7);
        typeMap.put("sec_interval", 3);
        typeMap.put("smallint", 5);
        typeMap.put("str", 12);
        typeMap.put("time", 92);
        typeMap.put("timestamp", 93);
        typeMap.put("timestamptz", 2014);
        typeMap.put("timetz", 2013);
        typeMap.put("tinyint", -6);
        typeMap.put("url", 12);
        typeMap.put("uuid", 12);
        typeMap.put("varchar", 12);
        typeMap.put("wrd", -5);
        typeMap.put("xml", 12);
    }
}

