/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class MonetBlob
implements Blob {
    private byte[] buf;

    protected MonetBlob(String in) {
        int len = in.length() / 2;
        this.buf = new byte[len];
        for (int i = 0; i < len; ++i) {
            this.buf[i] = (byte)Integer.parseInt(in.substring(2 * i, 2 * i + 2), 16);
        }
    }

    @Override
    public void free() throws SQLException {
        this.buf = null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Blob object has been freed");
        }
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Blob object has been freed");
        }
        if (pos < 1L) {
            throw new SQLException("pos is less than 1");
        }
        if (pos - 1L > (long)this.buf.length) {
            throw new SQLException("pos is greater than the number of bytes in the Blob");
        }
        if (pos - 1L + length > (long)this.buf.length) {
            throw new SQLException("pos + length is greater than the number of bytes in the Blob");
        }
        return new ByteArrayInputStream(this.buf, (int)(pos - 1L), (int)length);
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Blob object has been freed");
        }
        try {
            byte[] r = new byte[length];
            for (int i = 0; i < length; ++i) {
                r[i] = this.buf[(int)pos - 1 + i];
            }
            return r;
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public long length() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Blob object has been freed");
        }
        return this.buf.length;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Blob object has been freed");
        }
        try {
            for (int i = (int)(start - 1L); i < this.buf.length - pattern.length; ++i) {
                int j;
                for (j = 0; j < pattern.length && this.buf[i + j] == pattern[j]; ++j) {
                }
                if (j != pattern.length) continue;
                return i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage());
        }
        return -1L;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Blob object has been freed");
        }
        if (pos < 1L) {
            throw new SQLException("pos is less than 1");
        }
        throw new SQLFeatureNotSupportedException("Operation setBinaryStream(long pos) currently not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 1, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Blob object has been freed");
        }
        try {
            for (int i = (int)pos; i < len; ++i) {
                this.buf[i] = bytes[offset - 1 + i];
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage());
        }
        return len;
    }

    @Override
    public void truncate(long len) throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This Blob object has been freed");
        }
        if ((long)this.buf.length > len) {
            byte[] newbuf = new byte[(int)len];
            int i = 0;
            while ((long)i < len) {
                newbuf[i] = this.buf[i];
                ++i;
            }
            this.buf = newbuf;
        }
    }
}

