/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class BufferedMCLReader
extends BufferedReader {
    private int lineType;
    public static final int UNKNOWN = 0;
    public static final int ERROR = 33;
    public static final int HEADER = 37;
    public static final int RESULT = 91;
    public static final int PROMPT = 46;
    public static final int MORE = 44;
    public static final int SOHEADER = 38;
    public static final int REDIRECT = 94;
    public static final int INFO = 35;

    public BufferedMCLReader(Reader in) {
        super(in);
    }

    public BufferedMCLReader(InputStream in, String enc) throws UnsupportedEncodingException {
        super(new InputStreamReader(in, enc));
    }

    @Override
    public String readLine() throws IOException {
        String r = super.readLine();
        this.setLineType(r);
        return r;
    }

    void setLineType(String line) {
        this.lineType = 0;
        if (line == null || line.length() == 0) {
            return;
        }
        switch (line.charAt(0)) {
            case '!': {
                this.lineType = 33;
                break;
            }
            case '&': {
                this.lineType = 38;
                break;
            }
            case '%': {
                this.lineType = 37;
                break;
            }
            case '[': {
                this.lineType = 91;
                break;
            }
            case '=': {
                this.lineType = 91;
                break;
            }
            case '^': {
                this.lineType = 94;
                break;
            }
            case '#': {
                this.lineType = 35;
                break;
            }
            case '.': {
                this.lineType = 46;
                break;
            }
            case ',': {
                this.lineType = 44;
            }
        }
    }

    public int getLineType() {
        return this.lineType;
    }

    public final synchronized String waitForPrompt() throws IOException {
        String ret = "";
        while (this.lineType != 46) {
            String tmp = this.readLine();
            if (tmp == null) {
                throw new IOException("Connection to server lost!");
            }
            if (this.lineType != 33) continue;
            ret = ret + "\n" + tmp.substring(1);
        }
        return ret == "" ? null : ret.trim();
    }
}

