/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetVirtualResultSet;
import nl.cwi.monetdb.jdbc.MonetWrapper;

public class MonetDatabaseMetaData
extends MonetWrapper
implements DatabaseMetaData {
    private Connection con;
    private Driver driver;
    private static Map<Connection, Map<String, String>> envs = new HashMap<Connection, Map<String, String>>();
    static final String keyQuery1 = "' AS \"PKTABLE_CAT\", \"pkschema\".\"name\" AS \"PKTABLE_SCHEM\", \"pktable\".\"name\" AS \"PKTABLE_NAME\", \"pkkeycol\".\"name\" AS \"PKCOLUMN_NAME\", '";
    static final String keyQuery2 = "' AS \"FKTABLE_CAT\", \"fkschema\".\"name\" AS \"FKTABLE_SCHEM\", \"fktable\".\"name\" AS \"FKTABLE_NAME\", \"fkkeycol\".\"name\" AS \"FKCOLUMN_NAME\", \"pkkeycol\".\"nr\" AS \"KEY_SEQ\", 3 AS \"UPDATE_RULE\", 3 AS \"DELETE_RULE\", \"fkkey\".\"name\" AS \"FK_NAME\", \"pkkey\".\"name\" AS \"PK_NAME\", 7 AS \"DEFERRABILITY\" FROM \"sys\".\"keys\" AS \"fkkey\", \"sys\".\"keys\" AS \"pkkey\", \"sys\".\"objects\" AS \"fkkeycol\", \"sys\".\"objects\" AS \"pkkeycol\", \"sys\".\"tables\" AS \"fktable\", \"sys\".\"tables\" AS \"pktable\", \"sys\".\"schemas\" AS \"fkschema\", \"sys\".\"schemas\" AS \"pkschema\" WHERE \"fktable\".\"id\" = \"fkkey\".\"table_id\" AND \"pktable\".\"id\" = \"pkkey\".\"table_id\" AND \"fkkey\".\"id\" = \"fkkeycol\".\"id\" AND \"pkkey\".\"id\" = \"pkkeycol\".\"id\" AND \"fkschema\".\"id\" = \"fktable\".\"schema_id\" AND \"pkschema\".\"id\" = \"pktable\".\"schema_id\" AND \"fkkey\".\"rkey\" > -1 AND \"fkkey\".\"rkey\" = \"pkkey\".\"id\" AND \"fkkeycol\".\"nr\" = \"pkkeycol\".\"nr\" ";

    public MonetDatabaseMetaData(Connection parent) {
        this.con = parent;
        this.driver = new MonetDriver();
    }

    private synchronized Statement getStmt() throws SQLException {
        return this.con.createStatement(1004, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getEnv(String key) {
        String ret;
        Map<String, String> menvs = envs.get(this.con);
        if (menvs == null) {
            menvs = new HashMap<String, String>();
            try {
                ResultSet env = this.getStmt().executeQuery("SELECT \"name\", \"value\" FROM sys.env() as env");
                try {
                    while (env.next()) {
                        menvs.put(env.getString("name"), env.getString("value"));
                    }
                }
                finally {
                    env.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            envs.put(this.con, menvs);
        }
        if ((ret = menvs.get(key)) == null) {
            try {
                ResultSet env = this.getStmt().executeQuery("SELECT @\"" + key + "\" AS \"value\"");
                try {
                    if (env.next()) {
                        ret = env.getString("value");
                        menvs.put(key, ret);
                    }
                }
                finally {
                    env.close();
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean allProceduresAreCallable() {
        return true;
    }

    public boolean allTablesAreSelectable() {
        return true;
    }

    public String getURL() throws SQLException {
        return ((MonetConnection)this.con).getJDBCURL();
    }

    public String getUserName() throws SQLException {
        return this.getEnv("current_user");
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean nullsAreSortedHigh() {
        return true;
    }

    public boolean nullsAreSortedLow() {
        return !this.nullsAreSortedHigh();
    }

    public boolean nullsAreSortedAtStart() {
        return false;
    }

    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    public String getDatabaseProductName() {
        return "MonetDB";
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.getEnv("monet_version");
    }

    public String getDriverName() {
        return "MonetDB Native Driver";
    }

    public String getDriverVersion() {
        return MonetDriver.getDriverVersion();
    }

    public int getDriverMajorVersion() {
        return this.driver.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.driver.getMinorVersion();
    }

    public boolean usesLocalFiles() {
        return false;
    }

    public boolean usesLocalFilePerTable() {
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() {
        return false;
    }

    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseIdentifiers() {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public String getSQLKeywords() {
        return "";
    }

    public String getNumericFunctions() {
        return "";
    }

    public String getStringFunctions() {
        return "";
    }

    public String getSystemFunctions() {
        return "";
    }

    public String getTimeDateFunctions() {
        return "";
    }

    public String getSearchStringEscape() {
        return "\\";
    }

    public String getExtraNameCharacters() {
        return "";
    }

    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    public boolean supportsColumnAliasing() {
        return true;
    }

    public boolean nullPlusNonNullIsNull() {
        return true;
    }

    public boolean supportsConvert() {
        return false;
    }

    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    public boolean supportsTableCorrelationNames() {
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsGroupByUnrelated() {
        return true;
    }

    public boolean supportsGroupByBeyondSelect() {
        return true;
    }

    public boolean supportsLikeEscapeClause() {
        return true;
    }

    public boolean supportsMultipleResultSets() {
        return true;
    }

    public boolean supportsMultipleTransactions() {
        return true;
    }

    public boolean supportsNonNullableColumns() {
        return true;
    }

    public boolean supportsMinimumSQLGrammar() {
        return true;
    }

    public boolean supportsCoreSQLGrammar() {
        return true;
    }

    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() {
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    public boolean supportsANSI92FullSQL() {
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() {
        return true;
    }

    public boolean supportsOuterJoins() {
        return true;
    }

    public boolean supportsFullOuterJoins() {
        return true;
    }

    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    public String getSchemaTerm() {
        return "schema";
    }

    public String getProcedureTerm() {
        return "function";
    }

    public String getCatalogTerm() {
        return "database";
    }

    public boolean isCatalogAtStart() {
        return true;
    }

    public String getCatalogSeparator() {
        return ".";
    }

    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() {
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    public boolean supportsPositionedDelete() {
        return false;
    }

    public boolean supportsPositionedUpdate() {
        return false;
    }

    public boolean supportsSelectForUpdate() {
        return false;
    }

    public boolean supportsStoredProcedures() {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() {
        return true;
    }

    public boolean supportsSubqueriesInExists() {
        return true;
    }

    public boolean supportsSubqueriesInIns() {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() {
        return true;
    }

    public boolean supportsUnion() {
        return true;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return true;
    }

    public boolean supportsOpenCursorsAcrossRollback() {
        return true;
    }

    public boolean supportsOpenStatementsAcrossCommit() {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() {
        return true;
    }

    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    public int getMaxCharLiteralLength() {
        return 0;
    }

    public int getMaxColumnNameLength() {
        return 1024;
    }

    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    public int getMaxColumnsInIndex() {
        return 0;
    }

    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    public int getMaxColumnsInSelect() {
        return 0;
    }

    public int getMaxColumnsInTable() {
        return 0;
    }

    public int getMaxConnections() {
        return 16;
    }

    public int getMaxCursorNameLength() {
        return 1024;
    }

    public int getMaxIndexLength() {
        return 0;
    }

    public int getMaxSchemaNameLength() {
        return 1024;
    }

    public int getMaxProcedureNameLength() {
        return 1024;
    }

    public int getMaxCatalogNameLength() {
        return 1024;
    }

    public int getMaxRowSize() {
        return 0;
    }

    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    public int getMaxStatementLength() {
        return 0;
    }

    public int getMaxStatements() {
        return 0;
    }

    public int getMaxTableNameLength() {
        return 1024;
    }

    public int getMaxTablesInSelect() {
        return 0;
    }

    public int getMaxUserNameLength() {
        return 512;
    }

    public int getDefaultTransactionIsolation() {
        return 8;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 8;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        String query = "SELECT cast(null AS varchar(1)) AS \"PROCEDURE_CAT\", cast(null AS varchar(1)) AS \"PROCEDURE_SCHEM\", '' AS \"PROCEDURE_NAME\", cast(null AS varchar(1)) AS \"Field4\", cast(null AS varchar(1)) AS \"Field5\", cast(null AS varchar(1)) AS \"Field6\", '' AS \"REMARKS\", cast(0 AS smallint) AS \"PROCEDURE_TYPE\" WHERE 1 = 0";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        String query = "SELECT cast(null AS varchar(1)) AS \"PROCEDURE_CAT\", cast(null AS varchar(1)) AS \"PROCEDURE_SCHEM\", '' AS \"PROCEDURE_NAME\", '' AS \"COLUMN_NAME\", cast(0 AS smallint) AS \"COLUMN_TYPE\", cast(0 AS smallint) AS \"DATA_TYPE\", '' AS \"TYPE_NAME\", 0 AS \"PRECISION\", 0 AS \"LENGTH\", 0 AS \"SCALE\", 0 AS \"RADIX\", cast(0 AS smallint) AS \"NULLABLE\", '' AS \"REMARKS\" WHERE 1 = 0";
        return this.getStmt().executeQuery(query);
    }

    private static final String escapeQuotes(String in) {
        return in.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'");
    }

    private static final String dq(String in) {
        return "\"" + in.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\"";
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String select = "SELECT * FROM ( SELECT '" + cat + "' AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", " + "CASE WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" = 0 AND \"tables\".\"temporary\" = 0 THEN 'SYSTEM TABLE' " + "\tWHEN \"tables\".\"system\" = true AND \"tables\".\"type\" = 1 AND \"tables\".\"temporary\" = 0 THEN 'SYSTEM VIEW' " + "\tWHEN \"tables\".\"system\" = false AND \"tables\".\"type\" = 0 AND \"tables\".\"temporary\" = 0 THEN 'TABLE' " + "\tWHEN \"tables\".\"system\" = false AND \"tables\".\"type\" = 1 AND \"tables\".\"temporary\" = 0 THEN 'VIEW' " + "   WHEN \"tables\".\"system\" = true AND \"tables\".\"type\" = 0 AND \"tables\".\"temporary\" = 1 THEN 'SYSTEM SESSION TABLE' " + "\tWHEN \"tables\".\"system\" = true AND \"tables\".\"type\" = 1 AND \"tables\".\"temporary\" = 1 THEN 'SYSTEM SESSION VIEW' " + "\tWHEN \"tables\".\"system\" = false AND \"tables\".\"type\" = 0 AND \"tables\".\"temporary\" = 1 THEN 'SESSION TABLE' " + "\tWHEN \"tables\".\"system\" = false AND \"tables\".\"type\" = 1 AND \"tables\".\"temporary\" = 1 THEN 'SESSION VIEW' " + "END AS \"TABLE_TYPE\", \"tables\".\"query\" AS \"REMARKS\", null AS \"TYPE_CAT\", null AS \"TYPE_SCHEM\", " + "null AS \"TYPE_NAME\", 'rowid' AS \"SELF_REFERENCING_COL_NAME\", 'SYSTEM' AS \"REF_GENERATION\" " + "FROM \"sys\".\"tables\" AS \"tables\", \"sys\".\"schemas\" AS \"schemas\" WHERE \"tables\".\"schema_id\" = \"schemas\".\"id\" " + ") AS \"tables\" WHERE 1 = 1 ";
        if (tableNamePattern != null) {
            select = select + "AND LOWER(\"TABLE_NAME\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(tableNamePattern).toLowerCase() + "' ";
        }
        if (schemaPattern != null) {
            select = select + "AND LOWER(\"TABLE_SCHEM\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schemaPattern).toLowerCase() + "' ";
        }
        if (types != null) {
            select = select + "AND (";
            for (int i = 0; i < types.length; ++i) {
                select = select + (i == 0 ? "" : " OR ") + "LOWER(\"TABLE_TYPE\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(types[i]).toLowerCase() + "'";
            }
            select = select + ") ";
        }
        String orderby = "ORDER BY \"TABLE_TYPE\", \"TABLE_SCHEM\", \"TABLE_NAME\" ";
        return this.getStmt().executeQuery(select + orderby);
    }

    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT \"name\" AS \"TABLE_SCHEM\", '" + cat + "' AS \"TABLE_CATALOG\", " + "'" + cat + "' AS \"TABLE_CAT\" " + "FROM \"sys\".\"schemas\" " + "WHERE 1 = 1 ";
        if (catalog != null) {
            query = query + "AND LOWER('" + cat + "') LIKE '" + MonetDatabaseMetaData.escapeQuotes(catalog).toLowerCase() + "' ";
        }
        if (schemaPattern != null) {
            query = query + "AND LOWER(\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schemaPattern).toLowerCase() + "' ";
        }
        query = query + "ORDER BY \"TABLE_SCHEM\"";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getCatalogs() throws SQLException {
        String[] columns = new String[1];
        String[] types = new String[1];
        String[][] results = new String[1][1];
        columns[0] = "TABLE_TYPE";
        types[0] = "varchar";
        results[0][0] = this.getEnv("gdk_dbname");
        try {
            return new MonetVirtualResultSet(columns, types, results);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage(), "M0M03");
        }
    }

    public ResultSet getTableTypes() throws SQLException {
        String[] columns = new String[1];
        String[] types = new String[1];
        String[][] results = new String[8][1];
        columns[0] = "TABLE_TYPE";
        types[0] = "varchar";
        results[0][0] = "SYSTEM TABLE";
        results[1][0] = "TABLE";
        results[2][0] = "SYSTEM VIEW";
        results[3][0] = "VIEW";
        results[4][0] = "SYSTEM SESSION TABLE";
        results[5][0] = "SESSION TABLE";
        results[6][0] = "SYSTEM SESSION VIEW";
        results[7][0] = "SESSION VIEW";
        try {
            return new MonetVirtualResultSet(columns, types, results);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage(), "M0M03");
        }
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT '" + cat + "' AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", " + "\"tables\".\"name\" AS \"TABLE_NAME\", \"columns\".\"name\" AS \"COLUMN_NAME\", " + "cast(" + MonetDriver.getSQLTypeMap("\"columns\".\"type\"") + " " + "AS smallint) AS \"DATA_TYPE\", " + "\"columns\".\"type\" AS \"TYPE_NAME\", " + "\"columns\".\"type_digits\" AS \"COLUMN_SIZE\", " + "0 AS \"BUFFER_LENGTH\", \"columns\".\"type_scale\" AS \"DECIMAL_DIGITS\", " + "10 AS \"NUM_PREC_RADIX\", " + "cast(CASE \"null\" " + "WHEN true THEN " + 1 + " " + "WHEN false THEN " + 0 + " " + "END AS int) AS \"NULLABLE\", cast(null AS varchar(1)) AS \"REMARKS\", " + "\"columns\".\"default\" AS \"COLUMN_DEF\", 0 AS \"SQL_DATA_TYPE\", " + "0 AS \"SQL_DATETIME_SUB\", 0 AS \"CHAR_OCTET_LENGTH\", " + "\"columns\".\"number\" + 1 AS \"ORDINAL_POSITION\", " + "CASE \"null\" " + "WHEN true THEN CAST ('YES' AS varchar(3)) " + "WHEN false THEN CAST ('NO' AS varchar(3)) " + "END AS \"IS_NULLABLE\", " + "cast(null AS varchar(1)) AS \"SCOPE_CATALOG\", " + "cast(null AS varchar(1)) AS \"SCOPE_SCHEMA\", " + "cast(null AS varchar(1)) AS \"SCOPE_TABLE\", " + "cast(" + MonetDriver.getJavaType("other") + " AS smallint) AS \"SOURCE_DATA_TYPE\" " + "FROM \"sys\".\"columns\" AS \"columns\", " + "\"sys\".\"tables\" AS \"tables\", " + "\"sys\".\"schemas\" AS \"schemas\" " + "WHERE \"columns\".\"table_id\" = \"tables\".\"id\" " + "AND \"tables\".\"schema_id\" = \"schemas\".\"id\" ";
        if (schemaPattern != null) {
            query = query + "AND LOWER(\"schemas\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schemaPattern).toLowerCase() + "' ";
        }
        if (tableNamePattern != null) {
            query = query + "AND LOWER(\"tables\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(tableNamePattern).toLowerCase() + "' ";
        }
        if (columnNamePattern != null) {
            query = query + "AND LOWER(\"columns\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(columnNamePattern).toLowerCase() + "' ";
        }
        query = query + "ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"ORDINAL_POSITION\"";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getColumnPrivileges(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT '" + cat + "' AS \"TABLE_CAT\", " + "\"schemas\".\"name\" AS \"TABLE_SCHEM\", " + "\"tables\".\"name\" AS \"TABLE_NAME\", " + "\"columns\".\"name\" AS \"COLUMN_NAME\", " + "\"grantors\".\"name\" AS \"GRANTOR\", " + "\"grantees\".\"name\" AS \"GRANTEE\", " + "CASE \"privileges\".\"privileges\" " + "WHEN 1 THEN cast('SELECT' AS varchar(7)) " + "WHEN 2 THEN cast('UPDATE' AS varchar(7)) " + "WHEN 4 THEN cast('INSERT' AS varchar(7)) " + "WHEN 8 THEN cast('DELETE' AS varchar(7)) " + "WHEN 16 THEN cast('EXECUTE' AS varchar(7)) " + "WHEN 32 THEN cast('GRANT' AS varchar(7)) " + "END AS \"PRIVILEGE\", " + "CASE \"privileges\".\"grantable\" " + "WHEN 0 THEN cast('NO' AS varchar(3)) " + "WHEN 1 THEN cast('YES' AS varchar(3)) " + "END AS \"IS_GRANTABLE\" " + "FROM \"sys\".\"privileges\" AS \"privileges\", " + "\"sys\".\"tables\" AS \"tables\", " + "\"sys\".\"schemas\" AS \"schemas\", " + "\"sys\".\"columns\" AS \"columns\", " + "\"sys\".\"auths\" AS \"grantors\", " + "\"sys\".\"auths\" AS \"grantees\" " + "WHERE \"privileges\".\"obj_id\" = \"columns\".\"id\" " + "AND \"columns\".\"table_id\" = \"tables\".\"id\" " + "AND \"tables\".\"schema_id\" = \"schemas\".\"id\" " + "AND \"privileges\".\"auth_id\" = \"grantees\".\"id\" " + "AND \"privileges\".\"grantor\" = \"grantors\".\"id\" ";
        if (schemaPattern != null) {
            query = query + "AND LOWER(\"schemas\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schemaPattern).toLowerCase() + "' ";
        }
        if (tableNamePattern != null) {
            query = query + "AND LOWER(\"tables\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(tableNamePattern).toLowerCase() + "' ";
        }
        if (columnNamePattern != null) {
            query = query + "AND LOWER(\"columns\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(columnNamePattern).toLowerCase() + "' ";
        }
        query = query + "ORDER BY \"COLUMN_NAME\", \"PRIVILEGE\"";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT '" + cat + "' AS \"TABLE_CAT\", " + "\"schemas\".\"name\" AS \"TABLE_SCHEM\", " + "\"tables\".\"name\" AS \"TABLE_NAME\", " + "\"grantors\".\"name\" AS \"GRANTOR\", " + "\"grantees\".\"name\" AS \"GRANTEE\", " + "CASE \"privileges\".\"privileges\" " + "WHEN 1 THEN cast('SELECT' AS varchar(7)) " + "WHEN 2 THEN cast('UPDATE' AS varchar(7)) " + "WHEN 4 THEN cast('INSERT' AS varchar(7)) " + "WHEN 8 THEN cast('DELETE' AS varchar(7)) " + "WHEN 16 THEN cast('EXECUTE' AS varchar(7)) " + "WHEN 32 THEN cast('GRANT' AS varchar(7)) " + "END AS \"PRIVILEGE\", " + "CASE \"privileges\".\"grantable\" " + "WHEN 0 THEN cast('NO' AS varchar(3)) " + "WHEN 1 THEN cast('YES' AS varchar(3)) " + "END AS \"IS_GRANTABLE\" " + "FROM \"sys\".\"privileges\" AS \"privileges\", " + "\"sys\".\"tables\" AS \"tables\", " + "\"sys\".\"schemas\" AS \"schemas\", " + "\"sys\".\"auths\" AS \"grantors\", " + "\"sys\".\"auths\" AS \"grantees\" " + "WHERE \"privileges\".\"obj_id\" = \"tables\".\"id\" " + "AND \"tables\".\"schema_id\" = \"schemas\".\"id\" " + "AND \"privileges\".\"auth_id\" = \"grantees\".\"id\" " + "AND \"privileges\".\"grantor\" = \"grantors\".\"id\" ";
        if (schemaPattern != null) {
            query = query + "AND LOWER(\"schemas\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schemaPattern).toLowerCase() + "' ";
        }
        if (tableNamePattern != null) {
            query = query + "AND LOWER(\"tables\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(tableNamePattern).toLowerCase() + "' ";
        }
        query = query + "ORDER BY \"TABLE_SCHEM\", \"TABLE_NAME\", \"PRIVILEGE\"";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        String query = "SELECT \"columns\".\"name\" AS \"COLUMN_NAME\", \"columns\".\"type\" AS \"TYPE_NAME\", \"columns\".\"type_digits\" AS \"COLUMN_SIZE\", 0 AS \"BUFFER_LENGTH\", \"columns\".\"type_scale\" AS \"DECIMAL_DIGITS\", \"keys\".\"type\" AS \"keytype\" FROM \"sys\".\"keys\" AS \"keys\", \"sys\".\"objects\" AS \"objects\", \"sys\".\"columns\" AS \"columns\", \"sys\".\"tables\" AS \"tables\", \"sys\".\"schemas\" AS \"schemas\" WHERE \"keys\".\"id\" = \"objects\".\"id\" AND \"keys\".\"table_id\" = \"tables\".\"id\" AND \"keys\".\"table_id\" = \"columns\".\"table_id\" AND \"objects\".\"name\" = \"columns\".\"name\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"keys\".\"type\" IN (0, 1) ";
        if (schema != null) {
            query = query + "AND LOWER(\"schemas\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schema).toLowerCase() + "' ";
        }
        if (table != null) {
            query = query + "AND LOWER(\"tables\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(table).toLowerCase() + "' ";
        }
        if (!nullable) {
            query = query + "AND \"columns\".\"null\" = false ";
        }
        query = query + "ORDER BY \"keytype\"";
        String[] columns = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        String[] types = new String[]{"int", "varchar", "int", "varchar", "int", "int", "int", "int"};
        ArrayList<String[]> tmpRes = new ArrayList<String[]>();
        ResultSet rs = this.getStmt().executeQuery(query);
        while (rs.next()) {
            String[] result = new String[]{"2", rs.getString("column_name"), "" + MonetDriver.getJavaType(rs.getString("type_name")), rs.getString("type_name"), rs.getString("column_size"), rs.getString("buffer_length"), rs.getString("decimal_digits"), "1"};
            tmpRes.add(result);
        }
        rs.close();
        String[][] results = (String[][])tmpRes.toArray((T[])new String[tmpRes.size()][]);
        try {
            return new MonetVirtualResultSet(columns, types, results);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage(), "M0M03");
        }
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String[] columns = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        String[] types = new String[]{"int", "varchar", "int", "varchar", "int", "int", "int", "int"};
        String[][] results = new String[0][columns.length];
        try {
            return new MonetVirtualResultSet(columns, types, results);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage(), "M0M03");
        }
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        String query = "SELECT cast(null AS varchar(1)) AS \"TABLE_CAT\", \"schemas\".\"name\" AS \"TABLE_SCHEM\", \"tables\".\"name\" AS \"TABLE_NAME\", \"objects\".\"name\" AS \"COLUMN_NAME\", \"objects\".\"nr\" AS \"KEY_SEQ\", \"keys\".\"name\" AS \"PK_NAME\" FROM \"sys\".\"keys\" AS \"keys\", \"sys\".\"objects\" AS \"objects\", \"sys\".\"tables\" AS \"tables\", \"sys\".\"schemas\" AS \"schemas\" WHERE \"keys\".\"id\" = \"objects\".\"id\" AND \"keys\".\"table_id\" = \"tables\".\"id\" AND \"tables\".\"schema_id\" = \"schemas\".\"id\" AND \"keys\".\"type\" = 0 ";
        if (schema != null) {
            query = query + "AND LOWER(\"schemas\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schema).toLowerCase() + "' ";
        }
        if (table != null) {
            query = query + "AND LOWER(\"tables\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(table).toLowerCase() + "' ";
        }
        query = query + "ORDER BY \"COLUMN_NAME\"";
        return this.getStmt().executeQuery(query);
    }

    static String keyQuery(String cat) {
        return "SELECT '" + cat + keyQuery1 + cat + keyQuery2;
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = MonetDatabaseMetaData.keyQuery(cat);
        if (schema != null) {
            query = query + "AND LOWER(\"fkschema\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schema).toLowerCase() + "' ";
        }
        if (table != null) {
            query = query + "AND LOWER(\"fktable\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(table).toLowerCase() + "' ";
        }
        query = query + "ORDER BY \"PKTABLE_CAT\", \"PKTABLE_SCHEM\", \"PKTABLE_NAME\", \"PK_NAME\", \"KEY_SEQ\"";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = MonetDatabaseMetaData.keyQuery(cat);
        if (schema != null) {
            query = query + "AND LOWER(\"pkschema\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schema).toLowerCase() + "' ";
        }
        if (table != null) {
            query = query + "AND LOWER(\"pktable\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(table).toLowerCase() + "' ";
        }
        query = query + "ORDER BY \"FKTABLE_CAT\", \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getCrossReference(String pcatalog, String pschema, String ptable, String fcatalog, String fschema, String ftable) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = MonetDatabaseMetaData.keyQuery(cat);
        if (pschema != null) {
            query = query + "AND LOWER(\"pkschema\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(pschema).toLowerCase() + "' ";
        }
        if (ptable != null) {
            query = query + "AND LOWER(\"pktable\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(ptable).toLowerCase() + "' ";
        }
        if (fschema != null) {
            query = query + "AND LOWER(\"fkschema\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(fschema).toLowerCase() + "' ";
        }
        if (ftable != null) {
            query = query + "AND LOWER(\"fktable\".\"name\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(ftable).toLowerCase() + "' ";
        }
        query = query + "ORDER BY \"FKTABLE_CAT\", \"FKTABLE_SCHEM\", \"FKTABLE_NAME\", \"FK_NAME\", \"KEY_SEQ\"";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getTypeInfo() throws SQLException {
        String query = "SELECT \"sqlname\" AS \"TYPE_NAME\", cast(" + MonetDriver.getSQLTypeMap("\"sqlname\"") + " " + "AS smallint) AS \"DATA_TYPE\", " + "\"digits\" AS \"PRECISION\", " + "cast(CASE WHEN \"systemname\" = 'str' THEN cast('" + MonetDatabaseMetaData.escapeQuotes("'") + "' AS char) " + "ELSE cast(NULL AS char) END AS char) AS \"LITERAL_PREFIX\", " + "cast(CASE WHEN \"systemname\" = 'str' THEN cast('" + MonetDatabaseMetaData.escapeQuotes("'") + "' AS char) " + "ELSE cast(NULL AS char) END AS char) AS \"LITERAL_SUFFIX\", " + "cast(NULL AS varchar(1)) AS \"CREATE_PARAMS\", " + "cast(CASE WHEN \"systemname\" = 'oid' THEN " + 0 + " " + "ELSE " + 1 + " END AS smallint) AS \"NULLABLE\", " + "false AS \"CASE_SENSITIVE\", " + "cast(CASE \"systemname\" WHEN 'table' THEN " + 0 + " " + "WHEN 'str' THEN " + 1 + " " + "WHEN 'sqlblob' THEN " + 1 + " " + "ELSE " + 2 + " " + "END AS smallint) AS SEARCHABLE, " + "false AS \"UNSIGNED_ATTRIBUTE\", " + "CASE \"sqlname\" WHEN 'decimal' THEN true " + "ELSE false END AS \"FIXED_PREC_SCALE\", " + "false AS \"AUTO_INCREMENT\", " + "\"systemname\" AS \"LOCAL_TYPE_NAME\", " + "0 AS \"MINIMUM_SCALE\", " + "18 AS \"MAXIMUM SCALE\", " + "cast(NULL AS int) AS \"SQL_DATA_TYPE\", " + "cast(NULL AS int) AS \"SQL_DATETIME_SUB\", " + "\"radix\" AS \"NUM_PREC_RADIX\" " + "FROM \"sys\".\"types\"";
        return this.getStmt().executeQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT * FROM ( SELECT '" + cat + "' AS \"TABLE_CAT\", " + "\"idxs\".\"name\" AS \"INDEX_NAME\", " + "\"tables\".\"name\" AS \"TABLE_NAME\", " + "\"schemas\".\"name\" AS \"TABLE_SCHEM\", " + "CASE WHEN \"keys\".\"name\" IS NULL THEN true ELSE false END AS \"NON_UNIQUE\", " + "CASE \"idxs\".\"type\" WHEN 0 THEN " + 2 + " ELSE " + 3 + " END AS \"TYPE\", " + "\"objects\".\"nr\" AS \"ORDINAL_POSITION\", " + "\"columns\".\"name\" as \"COLUMN_NAME\", " + "cast(null AS varchar(1)) AS \"INDEX_QUALIFIER\", " + "cast(null AS varchar(1)) AS \"ASC_OR_DESC\", " + "0 AS \"PAGES\", " + "cast(null AS varchar(1)) AS \"FILTER_CONDITION\" " + "FROM \"sys\".\"idxs\" AS \"idxs\" LEFT JOIN \"sys\".\"keys\" AS \"keys\" ON \"idxs\".\"name\" = \"keys\".\"name\", " + "\"sys\".\"schemas\" AS \"schemas\", " + "\"sys\".\"objects\" AS \"objects\", " + "\"sys\".\"columns\" AS \"columns\", " + "\"sys\".\"tables\" AS \"tables\" " + "WHERE \"idxs\".\"table_id\" = \"tables\".\"id\" " + "AND \"tables\".\"schema_id\" = \"schemas\".\"id\" " + "AND \"idxs\".\"id\" = \"objects\".\"id\" " + "AND \"tables\".\"id\" = \"columns\".\"table_id\" " + "AND \"objects\".\"name\" = \"columns\".\"name\" " + "AND (\"keys\".\"type\" IS NULL OR \"keys\".\"type\" = 1) " + ") AS jdbcquery " + "WHERE 1 = 1 ";
        if (schema != null) {
            query = query + "AND LOWER(\"TABLE_SCHEM\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schema).toLowerCase() + "' ";
        }
        if (table != null) {
            query = query + "AND LOWER(\"TABLE_NAME\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(table).toLowerCase() + "' ";
        }
        if (unique) {
            query = query + "AND \"NON_UNIQUE\" = false ";
        }
        query = query + "ORDER BY \"NON_UNIQUE\", \"TYPE\", \"INDEX_NAME\", \"ORDINAL_POSITION\"";
        String[] columns = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        String[] types = new String[]{"varchar", "varchar", "varchar", "boolean", "varchar", "varchar", "int", "int", "varchar", "varchar", "int", "int", "varchar"};
        ArrayList<String[]> tmpRes = new ArrayList<String[]>();
        Statement sub = null;
        if (!approximate) {
            sub = this.con.createStatement();
        }
        ResultSet rs = this.getStmt().executeQuery(query);
        try {
            while (rs.next()) {
                ResultSet count;
                String[] result = new String[]{null, rs.getString("table_schem"), rs.getString("table_name"), rs.getString("non_unique"), rs.getString("index_qualifier"), rs.getString("index_name"), rs.getString("type"), rs.getString("ordinal_position"), rs.getString("column_name"), rs.getString("asc_or_desc"), approximate ? "0" : ((count = sub.executeQuery("SELECT COUNT(*) AS \"CARDINALITY\" FROM \"" + rs.getString("table_schem") + "\".\"" + rs.getString("table_name") + "\"")).next() ? count.getString("cardinality") : "0"), rs.getString("pages"), rs.getString("filter_condition")};
                tmpRes.add(result);
            }
            if (!approximate) {
                sub.close();
            }
        }
        finally {
            rs.close();
        }
        String[][] results = (String[][])tmpRes.toArray((T[])new String[tmpRes.size()][]);
        try {
            return new MonetVirtualResultSet(columns, types, results);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage(), "M0M03");
        }
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        return type != 1005;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1005) {
            return false;
        }
        return concurrency == 1007;
    }

    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    public boolean othersDeletesAreVisible(int i) {
        return false;
    }

    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    public boolean updatesAreDetected(int type) {
        return false;
    }

    public boolean deletesAreDetected(int i) {
        return false;
    }

    public boolean insertsAreDetected(int type) {
        return false;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT '" + cat + "' AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", " + "'java.lang.Object' AS \"CLASS_NAME\", 0 AS \"DATA_TYPE\", " + "'' AS \"REMARKS\", 0 AS \"BASE_TYPE\" WHERE 1 = 0";
        return this.getStmt().executeQuery(query);
    }

    public Connection getConnection() {
        return this.con;
    }

    public boolean rowChangesAreDetected(int type) {
        return false;
    }

    public boolean rowChangesAreVisible(int type) {
        return false;
    }

    public boolean supportsSavepoints() {
        return true;
    }

    public boolean supportsNamedParameters() {
        return false;
    }

    public boolean supportsMultipleOpenResults() {
        return true;
    }

    public boolean supportsGetGeneratedKeys() {
        return true;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT '" + cat + "' AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", " + "'' AS \"SUPERTYPE_CAT\", '' AS \"SUPERTYPE_SCHEM\", " + "'' AS \"SUPERTYPE_NAME\" WHERE 1 = 0";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT '" + cat + "' AS \"TABLE_CAT\", '' AS \"TABLE_SCHEM\", '' AS \"TABLE_NAME\", " + "'' AS \"SUPERTABLE_NAME\" WHERE 1 = 0";
        return this.getStmt().executeQuery(query);
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String query = "SELECT '" + cat + "' AS \"TYPE_CAT\", '' AS \"TYPE_SCHEM\", '' AS \"TYPE_NAME\", " + "'' AS \"ATTR_NAME\", '' AS \"ATTR_TYPE_NAME\", 0 AS \"ATTR_SIZE\", " + "0 AS \"DECIMAL_DIGITS\", 0 AS \"NUM_PREC_RADIX\", 0 AS \"NULLABLE\", " + "'' AS \"REMARKS\", '' AS \"ATTR_DEF\", 0 AS \"SQL_DATA_TYPE\", " + "0 AS \"SQL_DATETIME_SUB\", 0 AS \"CHAR_OCTET_LENGTH\", " + "0 AS \"ORDINAL_POSITION\", 'YES' AS \"IS_NULLABLE\", " + "'' AS \"SCOPE_CATALOG\", '' AS \"SCOPE_SCHEMA\", '' AS \"SCOPE_TABLE\", " + "0 AS \"SOURCE_DATA_TYPE\" WHERE 1 = 0";
        return this.getStmt().executeQuery(query);
    }

    public boolean supportsResultSetHoldability(int holdability) {
        return holdability == 1;
    }

    public int getResultSetHoldability() {
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        String version = this.getEnv("monet_version");
        int major = 0;
        try {
            major = Integer.parseInt(version.substring(0, version.indexOf(".")));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return major;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        String version = this.getEnv("monet_version");
        int minor = 0;
        try {
            int start = version.indexOf(".");
            minor = Integer.parseInt(version.substring(start + 1, version.indexOf(".", start + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return minor;
    }

    public int getJDBCMajorVersion() {
        return 4;
    }

    public int getJDBCMinorVersion() {
        return 1;
    }

    public int getSQLStateType() {
        return 2;
    }

    public boolean locatorsUpdateCopy() {
        return true;
    }

    public boolean supportsStatementPooling() {
        return false;
    }

    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        String[] columns = new String[4];
        String[] types = new String[4];
        String[][] results = new String[4][0];
        columns[0] = "NAME";
        types[0] = "varchar";
        columns[1] = "MAX_LEN";
        types[1] = "integer";
        columns[2] = "DEFAULT_VALUE";
        types[2] = "varchar";
        columns[3] = "DESCRIPTION";
        types[3] = "varchar";
        try {
            return new MonetVirtualResultSet(columns, types, results);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage(), "M0M03");
        }
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        String cat = this.getEnv("gdk_dbname");
        String select = "SELECT * FROM ( SELECT '" + cat + "' AS \"FUNCTION_CAT\", " + "\"schemas\".\"name\" AS \"FUNCTION_SCHEM\", " + "\"functions\".\"name\" AS \"FUNCTION_NAME\", " + "null AS \"REMARKS\", " + 0 + " AS \"FUNCTION_TYPE\", " + "CASE WHEN \"functions\".\"sql\" = false THEN CAST(\"functions\"/\"mod\" || '.' || \"functions\".\"func\" AS CLOB) ELSE CAST(\"functions\".\"name\" AS CLOB) END AS \"SPECIFIC_NAME\" " + "FROM \"sys\".\"functions\" AS \"functions\", \"sys\".\"schemas\" AS \"schemas\" WHERE \"functions\".\"schema_id\" = \"schemas\".\"id\" " + ") AS \"functions\" WHERE 1 = 1 ";
        if (catalog != null) {
            select = select + "AND LOWER('" + cat + "') LIKE '" + MonetDatabaseMetaData.escapeQuotes(catalog).toLowerCase() + "' ";
        }
        if (schemaPattern != null) {
            select = select + "AND LOWER(\"FUNCTION_SCHEM\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(schemaPattern).toLowerCase() + "' ";
        }
        if (functionNamePattern != null) {
            select = select + "AND LOWER(\"FUNCTION_NAME\") LIKE '" + MonetDatabaseMetaData.escapeQuotes(functionNamePattern).toLowerCase() + "' ";
        }
        String orderby = "ORDER BY \"FUNCTION_SCHEM\", \"FUNCTION_NAME\", \"SPECIFIC_NAME\"";
        return this.getStmt().executeQuery(select + orderby);
    }

    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("getFunctionColumns(String, String, String, String) is not implemented", "0A000");
    }

    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        String[] columns = new String[12];
        String[] types = new String[12];
        String[][] results = new String[12][0];
        columns[0] = "TABLE_CAT";
        types[0] = "varchar";
        columns[1] = "TABLE_SCHEM";
        types[1] = "varchar";
        columns[2] = "TABLE_NAME";
        types[2] = "varchar";
        columns[3] = "COLUMN_NAME";
        types[3] = "varchar";
        columns[4] = "DATA_TYPE";
        types[4] = "int";
        columns[5] = "COLUMN_SIZE";
        types[5] = "int";
        columns[6] = "DECIMAL_DIGITS";
        types[6] = "int";
        columns[7] = "NUM_PREC_RADIX";
        types[7] = "int";
        columns[8] = "COLUMN_USAGE";
        types[8] = "varchar";
        columns[9] = "REMARKS";
        types[9] = "varchar";
        columns[10] = "CHAR_OCTET_LENGTH";
        types[10] = "int";
        columns[11] = "IS_NULLABLE";
        types[11] = "varchar";
        try {
            return new MonetVirtualResultSet(columns, types, results);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Internal driver error: " + e.getMessage(), "M0M03");
        }
    }

    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return true;
    }
}

