/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import nl.cwi.monetdb.jdbc.MonetConnection;

public final class MonetDriver
implements Driver {
    private static final String MONETURL = "jdbc:monetdb://";
    private static final int DRIVERMAJOR = 2;
    private static final int DRIVERMINOR = 21;
    private static final String DRIVERVERSIONSUFFIX = "Liberica 20160610 based on MCL v1.13";
    private static final boolean MONETJDBCCOMPLIANT = false;
    private static final String PORT = "50000";
    private static Map<String, Integer> typeMap;
    private static String TypeMapppingSQL;

    @Override
    public boolean acceptsURL(String url) {
        return url != null && url.startsWith(MONETURL);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String uri_query;
        String uri_path;
        URI uri;
        Properties props = new Properties();
        props.put("port", PORT);
        props.put("debug", "false");
        props.put("language", "sql");
        props.put("so_timeout", "0");
        props.putAll((Map<?, ?>)info);
        info = props;
        if (!this.acceptsURL(url)) {
            throw new SQLException("Invalid URL: it does not start with: jdbc:monetdb://", "08M26");
        }
        try {
            uri = new URI(url.substring(5));
        }
        catch (URISyntaxException e) {
            throw new SQLException(e.toString(), "08M26");
        }
        String uri_host = uri.getHost();
        if (uri_host == null) {
            throw new SQLException("Invalid URL: no hostname given or unparsable in '" + url + "'", "08M26");
        }
        info.put("host", uri_host);
        int uri_port = uri.getPort();
        if (uri_port > 0) {
            info.put("port", "" + uri_port);
        }
        if ((uri_path = uri.getPath()) != null && uri_path.length() != 0 && !(uri_path = uri_path.substring(1)).trim().equals("")) {
            info.put("database", uri_path);
        }
        if ((uri_query = uri.getQuery()) != null) {
            String[] args = uri_query.split("&");
            for (int i = 0; i < args.length; ++i) {
                int tmp = args[i].indexOf("=");
                if (tmp <= 0) continue;
                info.put(args[i].substring(0, tmp), args[i].substring(tmp + 1));
            }
        }
        return new MonetConnection(info);
    }

    @Override
    public int getMajorVersion() {
        return 2;
    }

    @Override
    public int getMinorVersion() {
        return 21;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        if (!this.acceptsURL(url)) {
            return null;
        }
        ArrayList<DriverPropertyInfo> props = new ArrayList<DriverPropertyInfo>();
        DriverPropertyInfo prop = new DriverPropertyInfo("user", info.getProperty("user"));
        prop.required = true;
        prop.description = "The user loginname to use when authenticating on the database server";
        props.add(prop);
        prop = new DriverPropertyInfo("password", info.getProperty("password"));
        prop.required = true;
        prop.description = "The password to use when authenticating on the database server";
        props.add(prop);
        prop = new DriverPropertyInfo("debug", "false");
        prop.required = false;
        prop.description = "Whether or not to create a log file for debugging purposes";
        props.add(prop);
        prop = new DriverPropertyInfo("logfile", "");
        prop.required = false;
        prop.description = "The filename to write the debug log to. Only takes effect if debug is set to true. If the file exists, an incrementing number is added, till the filename is unique.";
        props.add(prop);
        prop = new DriverPropertyInfo("language", "sql");
        prop.required = false;
        prop.description = "What language to use for MonetDB conversations (experts only)";
        props.add(prop);
        prop = new DriverPropertyInfo("hash", "");
        prop.required = false;
        prop.description = "Force the use of the given hash algorithm during challenge response (one of SHA1, MD5, plain)";
        props.add(prop);
        prop = new DriverPropertyInfo("follow_redirects", "true");
        prop.required = false;
        prop.description = "Whether redirects issued by the server should be followed";
        props.add(prop);
        prop = new DriverPropertyInfo("treat_blob_as_binary", "false");
        prop.required = false;
        prop.description = "Whether BLOBs on the server should be treated as BINARY types, thus mapped to byte[]";
        props.add(prop);
        prop = new DriverPropertyInfo("so_timeout", "0");
        prop.required = false;
        prop.description = "Defines the maximum time to wait in milliseconds on a blocking read socket call";
        props.add(prop);
        DriverPropertyInfo[] dpi = new DriverPropertyInfo[props.size()];
        return props.toArray(dpi);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static int getJavaType(String type) {
        Integer tp = typeMap.get(type);
        if (tp != null) {
            return tp;
        }
        return 1111;
    }

    static String getSQLTypeMap(String column) {
        if (TypeMapppingSQL == null) {
            StringBuilder val = new StringBuilder(typeMap.size() * 25 + 14);
            for (Map.Entry<String, Integer> entry : typeMap.entrySet()) {
                val.append(" WHEN '").append(entry.getKey()).append("' THEN ").append(entry.getValue().toString());
            }
            val.append(" ELSE ").append(1111).append(" END");
            TypeMapppingSQL = val.toString();
        }
        return "CASE " + column + TypeMapppingSQL;
    }

    public static String getDriverVersion() {
        return "2.21 (Liberica 20160610 based on MCL v1.13)";
    }

    public static int getDriverMajorVersion() {
        return 2;
    }

    public static int getDriverMinorVersion() {
        return 21;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging not in use", "0A000");
    }

    static {
        try {
            DriverManager.registerDriver(new MonetDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        typeMap = new HashMap<String, Integer>();
        typeMap.put("bigint", -5);
        typeMap.put("blob", 2004);
        typeMap.put("boolean", 16);
        typeMap.put("char", 1);
        typeMap.put("clob", 2005);
        typeMap.put("date", 91);
        typeMap.put("decimal", 3);
        typeMap.put("double", 8);
        typeMap.put("hugeint", 2);
        typeMap.put("inet", 12);
        typeMap.put("int", 4);
        typeMap.put("json", 12);
        typeMap.put("month_interval", 4);
        typeMap.put("oid", -5);
        typeMap.put("real", 7);
        typeMap.put("sec_interval", 3);
        typeMap.put("smallint", 5);
        typeMap.put("table", 2003);
        typeMap.put("time", 92);
        typeMap.put("timestamp", 93);
        typeMap.put("timestamptz", 93);
        typeMap.put("timetz", 92);
        typeMap.put("tinyint", -6);
        typeMap.put("url", 12);
        typeMap.put("uuid", 12);
        typeMap.put("varchar", 12);
        typeMap.put("wrd", -5);
        TypeMapppingSQL = null;
    }
}

