/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.parser;

import nl.cwi.monetdb.mcl.parser.MCLParseException;
import nl.cwi.monetdb.mcl.parser.MCLParser;

public class HeaderLineParser
extends MCLParser {
    private int type;
    public static final int NAME = 1;
    public static final int LENGTH = 2;
    public static final int TABLE = 3;
    public static final int TYPE = 4;

    public HeaderLineParser(int columncount) {
        super(columncount);
    }

    @Override
    public int parse(String source) throws MCLParseException {
        char[] chrLine = source.toCharArray();
        int len = chrLine.length;
        int pos = 0;
        boolean foundChar = false;
        boolean nameFound = false;
        block9: for (int i = len - 1; i >= 0; --i) {
            switch (chrLine[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!foundChar) {
                        len = i - 1;
                        continue block9;
                    }
                    pos = i + 1;
                    continue block9;
                }
                case '#': {
                    nameFound = true;
                    if (pos == 0) {
                        pos = i + 1;
                    }
                    i = 0;
                    continue block9;
                }
                default: {
                    foundChar = true;
                    pos = 0;
                }
            }
        }
        if (!nameFound) {
            throw new MCLParseException("invalid header, no header name found", pos);
        }
        switch (chrLine[pos]) {
            case 'n': {
                if (len - pos != 4 || !source.regionMatches(pos + 1, "name", 1, 3)) break;
                this.getValues(chrLine, 2, pos - 3);
                this.type = 1;
                break;
            }
            case 'l': {
                if (len - pos != 6 || !source.regionMatches(pos + 1, "length", 1, 5)) break;
                this.getIntValues(chrLine, 2, pos - 3);
                this.type = 2;
                break;
            }
            case 't': {
                if (len - pos == 4 && source.regionMatches(pos + 1, "type", 1, 3)) {
                    this.getValues(chrLine, 2, pos - 3);
                    this.type = 4;
                    break;
                }
                if (len - pos != 10 || !source.regionMatches(pos + 1, "table_name", 1, 9)) break;
                this.getValues(chrLine, 2, pos - 3);
                this.type = 3;
                break;
            }
            default: {
                throw new MCLParseException("unknown header: " + new String(chrLine, pos, len - pos));
            }
        }
        this.reset();
        return this.type;
    }

    private final void getValues(char[] chrLine, int start, int stop) {
        int elem = 0;
        boolean inString = false;
        boolean escaped = false;
        block5: for (int i = start; i < stop; ++i) {
            switch (chrLine[i]) {
                case '\\': {
                    escaped = !escaped;
                    continue block5;
                }
                case '\"': {
                    if (!inString) {
                        inString = true;
                    } else if (!escaped) {
                        inString = false;
                    }
                    escaped = false;
                    continue block5;
                }
                case ',': {
                    if (!inString && chrLine[i + 1] == '\t') {
                        if (chrLine[start] == '\"') {
                            ++start;
                        }
                        if (elem < this.values.length) {
                            this.values[elem++] = new String(chrLine, start, i - (chrLine[i - 1] == '\"' ? 1 : 0) - start);
                        }
                        start = ++i + 1;
                    }
                    escaped = false;
                    continue block5;
                }
                default: {
                    escaped = false;
                }
            }
        }
        if (chrLine[start] == '\"') {
            ++start;
        }
        if (elem < this.values.length) {
            this.values[elem] = new String(chrLine, start, stop - (chrLine[stop - 1] == '\"' ? 1 : 0) - start);
        }
    }

    private final void getIntValues(char[] chrLine, int start, int stop) throws MCLParseException {
        int elem = 0;
        int tmp = 0;
        for (int i = start; i < stop; ++i) {
            if (chrLine[i] == ',' && chrLine[i + 1] == '\t') {
                this.intValues[elem++] = tmp;
                tmp = 0;
                start = i++;
                continue;
            }
            if (chrLine[i] >= '0' && chrLine[i] <= '9') {
                tmp *= 10;
                tmp += chrLine[i] - 48;
                continue;
            }
            throw new MCLParseException("expected a digit in " + new String(chrLine) + " at " + i);
        }
        this.intValues[elem] = tmp;
    }
}

