/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.jdbc.types.INET;
import nl.cwi.monetdb.jdbc.types.URL;
import nl.cwi.monetdb.mcl.parser.MCLParseException;
import nl.cwi.monetdb.mcl.parser.TupleLineParser;

public class MonetResultSet
extends MonetWrapper
implements ResultSet {
    final TupleLineParser tlp;
    int curRow = 0;
    private final MonetConnection.ResultSetResponse header;
    private final String[] columns;
    private final String[] types;
    private final int[] JdbcSQLTypes;
    final int tupleCount;
    private final Statement statement;
    private int type = 1003;
    private int concurrency = 1007;
    private SQLWarning warnings;
    private boolean lastReadWasNull = true;
    private int fetchSize;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private SimpleDateFormat timestampFormat;

    MonetResultSet(Statement statement, MonetConnection.ResultSetResponse header) throws SQLException {
        if (statement == null) {
            throw new IllegalArgumentException("Statement may not be null!");
        }
        if (header == null) {
            throw new IllegalArgumentException("ResultSetResponse may not be null!");
        }
        this.statement = statement;
        this.header = header;
        this.type = header.getRSType();
        this.concurrency = header.getRSConcur();
        this.fetchSize = header.getCacheSize();
        this.columns = header.getNames();
        this.types = header.getTypes();
        this.tupleCount = header.tuplecount;
        this.tlp = new TupleLineParser(this.columns.length);
        this.JdbcSQLTypes = new int[this.types.length];
        this.populateJdbcSQLtypesArray();
    }

    MonetResultSet(Statement statement, String[] columns, String[] types, int results) throws IllegalArgumentException {
        if (statement == null) {
            throw new IllegalArgumentException("Statement may not be null!");
        }
        if (columns == null || types == null) {
            throw new IllegalArgumentException("One of the given arguments is null!");
        }
        if (columns.length != types.length) {
            throw new IllegalArgumentException("Given arguments are not the same size!");
        }
        if (results < 0) {
            throw new IllegalArgumentException("Negative rowcount not allowed!");
        }
        this.statement = statement;
        this.header = null;
        this.fetchSize = 0;
        this.columns = columns;
        this.types = types;
        this.tupleCount = results;
        this.tlp = new TupleLineParser(columns.length);
        this.JdbcSQLTypes = new int[types.length];
        this.populateJdbcSQLtypesArray();
    }

    private void populateJdbcSQLtypesArray() {
        for (int i = 0; i < this.types.length; ++i) {
            int javaSQLtype;
            this.JdbcSQLTypes[i] = javaSQLtype = MonetDriver.getJavaType(this.types[i]);
            if (javaSQLtype != 2004) continue;
            try {
                if (!((MonetConnection)this.statement.getConnection()).getBlobAsBinary()) continue;
                this.JdbcSQLTypes[i] = -2;
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row != this.curRow + 1 && this.type == 1003) {
            throw new SQLException("(Absolute) positioning not allowed on forward  only result sets!", "M1M05");
        }
        if (this.header.isClosed()) {
            throw new SQLException("ResultSet is closed!", "M1M20");
        }
        if (row < 0) {
            row = this.tupleCount + row + 1;
        }
        if (row < 0) {
            row = 0;
        } else if (row > this.tupleCount + 1) {
            row = this.tupleCount + 1;
        }
        String tmpLine = this.header.getLine(row - 1);
        this.curRow = row;
        if (tmpLine == null) {
            return false;
        }
        try {
            this.tlp.parse(tmpLine);
        }
        catch (MCLParseException e) {
            throw new SQLException(e.getMessage(), "M0M10");
        }
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.absolute(this.tupleCount + 1);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        if (this.header != null && !this.header.isClosed()) {
            this.header.close();
        }
        if (this.statement instanceof MonetStatement) {
            ((MonetStatement)this.statement).closeIfCompletion();
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        if (columnName != null) {
            int i;
            int array_size = this.columns.length;
            for (i = 0; i < array_size; ++i) {
                if (!columnName.equals(this.columns[i])) continue;
                return i + 1;
            }
            for (i = 0; i < array_size; ++i) {
                if (!columnName.equalsIgnoreCase(this.columns[i])) continue;
                return i + 1;
            }
        }
        throw new SQLException("No such column name: " + columnName, "M1M05");
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try {
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case 2004: {
                    Blob blob = this.getBlob(columnIndex);
                    if (blob == null) {
                        return null;
                    }
                    return blob.getBinaryStream();
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] bte = this.getBytes(columnIndex);
                    if (bte == null) {
                        return null;
                    }
                    return new ByteArrayInputStream(bte);
                }
            }
            throw new SQLException("Cannot operate on " + this.types[columnIndex - 1] + " type", "M1M05");
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new StringReader(val);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public Reader getNCharacterStream(String columnName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNCharacterStream");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return MonetBlob.create(val);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new MonetClob(val);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public NClob getNClob(int i) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String colName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new BigDecimal(val);
        }
        catch (NumberFormatException e) {
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            BigDecimal bd = new BigDecimal(val);
            bd.setScale(scale);
            return bd;
        }
        catch (NumberFormatException e) {
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return false;
            }
            this.lastReadWasNull = false;
            if ("false".equalsIgnoreCase(val) || "0".equals(val)) {
                return false;
            }
            if ("true".equalsIgnoreCase(val) || "1".equals(val)) {
                return true;
            }
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case -1: 
                case 1: 
                case 12: 
                case 16: 
                case 2005: {
                    return Boolean.parseBoolean(val);
                }
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    return this.getInt(columnIndex) != 0;
                }
                case -5: {
                    return this.getLong(columnIndex) != 0L;
                }
                case 6: 
                case 7: 
                case 8: {
                    return this.getDouble(columnIndex) != 0.0;
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(columnIndex).compareTo(BigDecimal.ZERO) != 0;
                }
            }
            throw new SQLException("Conversion from " + this.types[columnIndex - 1] + " to boolean type not supported", "M1M05");
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Byte.parseByte(val);
        }
        catch (NumberFormatException e) {
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            switch (this.JdbcSQLTypes[columnIndex - 1]) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    int len = val.length() / 2;
                    byte[] buf = new byte[len];
                    for (int j = 0; j < len; ++j) {
                        int offset = j * 2;
                        buf[j] = (byte)Integer.parseInt(val.substring(offset, offset + 2), 16);
                    }
                    return buf;
                }
            }
            throw new SQLException("Cannot operate on " + this.types[columnIndex - 1] + " type", "M1M05");
        }
        catch (NumberFormatException e) {
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned updates not supported for this cursor (" + (this.header != null ? Integer.valueOf(this.header.id) : "") + ")", "0AM21");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return 0.0;
            }
            this.lastReadWasNull = false;
            return Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getStatement().getConnection().getHoldability();
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                throw new SQLException("Not supported direction " + direction, "0A000");
            }
            default: {
                throw new SQLException("Illegal direction: " + direction, "M1M05");
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new SQLException("Illegal fetch size value: " + rows, "M1M05");
        }
        this.fetchSize = rows;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return 0.0f;
            }
            this.lastReadWasNull = false;
            return Float.parseFloat(val);
        }
        catch (NumberFormatException e) {
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        String val = "";
        try {
            val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            int len;
            if ("oid".equals(this.types[columnIndex - 1]) && (len = val.length()) > 2 && val.endsWith("@0")) {
                val = val.substring(0, len - 2);
                try {
                    return Integer.parseInt(val);
                }
                catch (NumberFormatException nfe) {
                    throw MonetResultSet.newSQLNumberFormatException(nfe);
                }
            }
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        String val = "";
        try {
            val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return 0L;
            }
            this.lastReadWasNull = false;
            return Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            int len;
            if ("oid".equals(this.types[columnIndex - 1]) && (len = val.length()) > 2 && val.endsWith("@0")) {
                val = val.substring(0, len - 2);
                try {
                    return Long.parseLong(val);
                }
                catch (NumberFormatException nfe) {
                    throw MonetResultSet.newSQLNumberFormatException(nfe);
                }
            }
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new rsmdw(){
            final int array_size;
            private boolean[] _is_fetched;
            private int[] _precision;
            private int[] _scale;
            private int[] _isNullable;
            private boolean[] _isAutoincrement;
            private Connection conn;
            private DatabaseMetaData dbmd;
            {
                this.array_size = MonetResultSet.this.columns.length + 1;
                this._is_fetched = new boolean[this.array_size];
                this._precision = new int[this.array_size];
                this._scale = new int[this.array_size];
                this._isNullable = new int[this.array_size];
                this._isAutoincrement = new boolean[this.array_size];
                this.conn = null;
                this.dbmd = null;
            }

            private void fetchColumnInfo(int column) throws SQLException {
                String colName;
                String tblName;
                if (column <= 0 || column > MonetResultSet.this.columns.length) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
                this._is_fetched[column] = true;
                this._precision[column] = 0;
                this._scale[column] = 0;
                this._isNullable[column] = 2;
                this._isAutoincrement[column] = false;
                String schName = this.getSchemaName(column);
                if (!(schName == null || schName.isEmpty() || (tblName = this.getTableName(column)) == null || tblName.isEmpty() || (colName = this.getColumnName(column)) == null || colName.isEmpty())) {
                    ResultSet colInfo;
                    if (this.conn == null) {
                        this.conn = MonetResultSet.this.getStatement().getConnection();
                    }
                    if (this.conn != null && this.dbmd == null) {
                        this.dbmd = this.conn.getMetaData();
                    }
                    if (this.dbmd != null && (colInfo = this.dbmd.getColumns(null, schName, tblName, colName)) != null) {
                        if (colInfo.next()) {
                            this._precision[column] = colInfo.getInt(7);
                            this._scale[column] = colInfo.getInt(9);
                            this._isNullable[column] = colInfo.getInt(11);
                            String strVal = colInfo.getString(23);
                            if (strVal != null && "YES".equals(strVal)) {
                                this._isAutoincrement[column] = true;
                            }
                        }
                        colInfo.close();
                    }
                }
            }

            @Override
            public int getColumnCount() {
                return MonetResultSet.this.columns.length;
            }

            @Override
            public boolean isAutoIncrement(int column) throws SQLException {
                try {
                    if (!this._is_fetched[column]) {
                        this.fetchColumnInfo(column);
                    }
                    return this._isAutoincrement[column];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public boolean isCaseSensitive(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case -1: 
                    case 1: 
                    case 2005: {
                        return true;
                    }
                    case 12: {
                        String monettype = this.getColumnTypeName(column);
                        return monettype == null || monettype.length() != 4 || !"inet".equals(monettype) && !"uuid".equals(monettype);
                    }
                }
                return false;
            }

            @Override
            public boolean isSearchable(int column) {
                return true;
            }

            @Override
            public boolean isCurrency(int column) {
                return false;
            }

            @Override
            public boolean isSigned(int column) throws SQLException {
                switch (this.getColumnType(column)) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                    case -5: {
                        String monettype = this.getColumnTypeName(column);
                        return monettype == null || monettype.length() != 3 || !"oid".equals(monettype) && !"ptr".equals(monettype);
                    }
                }
                return false;
            }

            @Override
            public int getColumnDisplaySize(int column) throws SQLException {
                int ret = 1;
                if (MonetResultSet.this.header != null) {
                    try {
                        ret = MonetResultSet.this.header.getColumnLengths()[column - 1];
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                    }
                }
                return ret;
            }

            @Override
            public String getSchemaName(int column) throws SQLException {
                if (MonetResultSet.this.header != null) {
                    try {
                        String schema = MonetResultSet.this.header.getTableNames()[column - 1];
                        if (schema != null) {
                            int dot = schema.indexOf(46);
                            return dot >= 0 ? schema.substring(0, dot) : "";
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                    }
                }
                return "";
            }

            @Override
            public String getTableName(int column) throws SQLException {
                if (MonetResultSet.this.header != null) {
                    try {
                        String table = MonetResultSet.this.header.getTableNames()[column - 1];
                        if (table != null) {
                            int dot = table.indexOf(46);
                            return dot >= 0 ? table.substring(dot + 1) : table;
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                    }
                }
                return "";
            }

            @Override
            public int getPrecision(int column) throws SQLException {
                try {
                    if (!this._is_fetched[column]) {
                        this.fetchColumnInfo(column);
                    }
                    if (this._precision[column] == 0) {
                        switch (this.getColumnType(column)) {
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: 
                            case 2004: 
                            case 2005: {
                                this._precision[column] = this.getColumnDisplaySize(column);
                                break;
                            }
                            case -6: {
                                this._precision[column] = 3;
                                break;
                            }
                            case 5: {
                                this._precision[column] = 5;
                                break;
                            }
                            case 4: {
                                this._precision[column] = 10;
                                break;
                            }
                            case -5: {
                                this._precision[column] = 19;
                                break;
                            }
                            case 7: {
                                this._precision[column] = 7;
                                break;
                            }
                            case 6: 
                            case 8: {
                                this._precision[column] = 15;
                                break;
                            }
                            case -7: {
                                this._precision[column] = 1;
                                break;
                            }
                            case 16: {
                                this._precision[column] = 5;
                                break;
                            }
                            case 91: {
                                this._precision[column] = 10;
                                break;
                            }
                            case 92: {
                                this._precision[column] = 8;
                                break;
                            }
                            case 93: {
                                this._precision[column] = 19;
                                break;
                            }
                            default: {
                                this._precision[column] = 30;
                            }
                        }
                    }
                    return this._precision[column];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int getScale(int column) throws SQLException {
                try {
                    if (!this._is_fetched[column]) {
                        this.fetchColumnInfo(column);
                    }
                    return this._scale[column];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int isNullable(int column) throws SQLException {
                try {
                    if (!this._is_fetched[column]) {
                        this.fetchColumnInfo(column);
                    }
                    return this._isNullable[column];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getCatalogName(int column) throws SQLException {
                return null;
            }

            @Override
            public boolean isReadOnly(int column) {
                return true;
            }

            @Override
            public boolean isWritable(int column) {
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int column) {
                return false;
            }

            @Override
            public String getColumnClassName(int column) throws SQLException {
                if (this.conn == null) {
                    this.conn = MonetResultSet.this.getStatement().getConnection();
                }
                try {
                    Map<String, Class<?>> map;
                    String MonetDBType = MonetResultSet.this.types[column - 1];
                    Class<?> type = null;
                    if (this.conn != null && (map = this.conn.getTypeMap()) != null && map.containsKey(MonetDBType)) {
                        type = map.get(MonetDBType);
                    }
                    if (type == null) {
                        type = MonetResultSet.getClassForType(MonetResultSet.this.JdbcSQLTypes[column - 1]);
                    }
                    if (type != null) {
                        return type.getName();
                    }
                    throw new SQLException("column type mapping null: " + MonetDBType, "M0M03");
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getColumnLabel(int column) throws SQLException {
                return this.getColumnName(column);
            }

            @Override
            public String getColumnName(int column) throws SQLException {
                try {
                    return MonetResultSet.this.columns[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public int getColumnType(int column) throws SQLException {
                try {
                    return MonetResultSet.this.JdbcSQLTypes[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }

            @Override
            public String getColumnTypeName(int column) throws SQLException {
                try {
                    return MonetResultSet.this.types[column - 1];
                }
                catch (IndexOutOfBoundsException e) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(column);
                }
            }
        };
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        int JdbcType;
        String val;
        try {
            val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            JdbcType = this.JdbcSQLTypes[columnIndex - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
        switch (JdbcType) {
            case -7: 
            case -6: 
            case 5: {
                try {
                    return Short.valueOf(val);
                }
                catch (NumberFormatException e) {
                    return val;
                }
            }
            case 4: {
                try {
                    return Integer.valueOf(val);
                }
                catch (NumberFormatException e) {
                    return val;
                }
            }
            case -5: {
                try {
                    return Long.valueOf(val);
                }
                catch (NumberFormatException e) {
                    return val;
                }
            }
            case 6: 
            case 8: {
                try {
                    return Double.valueOf(val);
                }
                catch (NumberFormatException e) {
                    return val;
                }
            }
            case 7: {
                try {
                    return Float.valueOf(val);
                }
                catch (NumberFormatException e) {
                    return val;
                }
            }
            case 2: 
            case 3: {
                try {
                    return new BigDecimal(val);
                }
                catch (NumberFormatException e) {
                    return val;
                }
            }
            case 16: {
                return Boolean.valueOf(val);
            }
            case 12: {
                String MonetDBType = this.types[columnIndex - 1];
                switch (MonetDBType.length()) {
                    case 3: {
                        if (!"url".equals(MonetDBType)) break;
                        try {
                            URL url_obj = new URL();
                            url_obj.fromString(val);
                            return url_obj;
                        }
                        catch (MalformedURLException exc) {
                            return val;
                        }
                        catch (Exception exc) {
                            return val;
                        }
                    }
                    case 4: {
                        if ("inet".equals(MonetDBType)) {
                            try {
                                INET inet_obj = new INET();
                                inet_obj.fromString(val);
                                return inet_obj;
                            }
                            catch (Exception exc) {
                                return val;
                            }
                        }
                        if (!"uuid".equals(MonetDBType)) break;
                        try {
                            return UUID.fromString(val);
                        }
                        catch (IllegalArgumentException exc) {
                            return val;
                        }
                    }
                }
                return val;
            }
            case -1: 
            case 1: {
                return val;
            }
            case 2005: {
                return new MonetClob(val);
            }
            case 2004: {
                return MonetBlob.create(val);
            }
            case 91: {
                return this.getDate(columnIndex);
            }
            case 92: {
                return this.getTime(columnIndex);
            }
            case 93: {
                return this.getTimestamp(columnIndex);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(columnIndex);
            }
        }
        return this.getObject(columnIndex, this.getStatement().getConnection().getTypeMap());
    }

    private boolean classImplementsSQLData(Class<?> cl) {
        Class<?>[] cls = cl.getInterfaces();
        for (int i = 0; i < cls.length; ++i) {
            if (cls[i] != SQLData.class) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        String MonetDBtype;
        String val;
        try {
            val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            MonetDBtype = this.types[columnIndex - 1];
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
        Class<?> type = null;
        if (map != null && map.containsKey(MonetDBtype)) {
            type = map.get(MonetDBtype);
        }
        if (type == null) {
            type = MonetResultSet.getClassForType(this.JdbcSQLTypes[columnIndex - 1]);
        }
        if (type == null || type == String.class) {
            return val;
        }
        if (type == BigDecimal.class) {
            return this.getBigDecimal(columnIndex);
        }
        if (type == Boolean.class) {
            return this.getBoolean(columnIndex);
        }
        if (type == Short.class) {
            return this.getShort(columnIndex);
        }
        if (type == Integer.class) {
            return this.getInt(columnIndex);
        }
        if (type == Long.class) {
            return this.getLong(columnIndex);
        }
        if (type == Float.class) {
            return Float.valueOf(this.getFloat(columnIndex));
        }
        if (type == Double.class) {
            return this.getDouble(columnIndex);
        }
        if (type == byte[].class) {
            return this.getBytes(columnIndex);
        }
        if (type == Date.class) {
            return this.getDate(columnIndex);
        }
        if (type == Time.class) {
            return this.getTime(columnIndex);
        }
        if (type == Timestamp.class) {
            return this.getTimestamp(columnIndex);
        }
        if (type == Clob.class) {
            return this.getClob(columnIndex);
        }
        if (type == Blob.class) {
            return this.getBlob(columnIndex);
        }
        if (this.classImplementsSQLData(type)) {
            SQLData x;
            try {
                Constructor<?> ctor = type.getConstructor(new Class[0]);
                x = (SQLData)ctor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new SQLException(nsme.getMessage(), "M0M27");
            }
            catch (InstantiationException ie) {
                throw new SQLException(ie.getMessage(), "M0M27");
            }
            catch (IllegalAccessException iae) {
                throw new SQLException(iae.getMessage(), "M0M27");
            }
            catch (InvocationTargetException ite) {
                throw new SQLException(ite.getMessage(), "M0M27");
            }
            catch (SecurityException se) {
                throw new SQLException(se.getMessage(), "M0M27");
            }
            final int colnum = columnIndex;
            final boolean valwasnull = this.wasNull();
            SQLInput input = new SQLInput(){

                @Override
                public String readString() throws SQLException {
                    return MonetResultSet.this.getString(colnum);
                }

                @Override
                public boolean readBoolean() throws SQLException {
                    return MonetResultSet.this.getBoolean(colnum);
                }

                @Override
                public byte readByte() throws SQLException {
                    return MonetResultSet.this.getByte(colnum);
                }

                @Override
                public short readShort() throws SQLException {
                    return MonetResultSet.this.getShort(colnum);
                }

                @Override
                public int readInt() throws SQLException {
                    return MonetResultSet.this.getInt(colnum);
                }

                @Override
                public long readLong() throws SQLException {
                    return MonetResultSet.this.getLong(colnum);
                }

                @Override
                public float readFloat() throws SQLException {
                    return MonetResultSet.this.getFloat(colnum);
                }

                @Override
                public double readDouble() throws SQLException {
                    return MonetResultSet.this.getDouble(colnum);
                }

                @Override
                public BigDecimal readBigDecimal() throws SQLException {
                    return MonetResultSet.this.getBigDecimal(colnum);
                }

                @Override
                public byte[] readBytes() throws SQLException {
                    return MonetResultSet.this.getBytes(colnum);
                }

                @Override
                public Date readDate() throws SQLException {
                    return MonetResultSet.this.getDate(colnum);
                }

                @Override
                public Time readTime() throws SQLException {
                    return MonetResultSet.this.getTime(colnum);
                }

                @Override
                public Timestamp readTimestamp() throws SQLException {
                    return MonetResultSet.this.getTimestamp(colnum);
                }

                @Override
                public Reader readCharacterStream() throws SQLException {
                    return MonetResultSet.this.getCharacterStream(colnum);
                }

                @Override
                public InputStream readAsciiStream() throws SQLException {
                    return MonetResultSet.this.getAsciiStream(colnum);
                }

                @Override
                public InputStream readBinaryStream() throws SQLException {
                    return MonetResultSet.this.getBinaryStream(colnum);
                }

                @Override
                public Object readObject() throws SQLException {
                    return MonetResultSet.this.getObject(colnum);
                }

                @Override
                public Ref readRef() throws SQLException {
                    return MonetResultSet.this.getRef(colnum);
                }

                @Override
                public Blob readBlob() throws SQLException {
                    return MonetResultSet.this.getBlob(colnum);
                }

                @Override
                public Clob readClob() throws SQLException {
                    return MonetResultSet.this.getClob(colnum);
                }

                @Override
                public Array readArray() throws SQLException {
                    return MonetResultSet.this.getArray(colnum);
                }

                @Override
                public boolean wasNull() throws SQLException {
                    return valwasnull;
                }

                @Override
                public java.net.URL readURL() throws SQLException {
                    return MonetResultSet.this.getURL(colnum);
                }

                @Override
                public NClob readNClob() throws SQLException {
                    return MonetResultSet.this.getNClob(colnum);
                }

                @Override
                public String readNString() throws SQLException {
                    return MonetResultSet.this.getNString(colnum);
                }

                @Override
                public SQLXML readSQLXML() throws SQLException {
                    return MonetResultSet.this.getSQLXML(colnum);
                }

                @Override
                public RowId readRowId() throws SQLException {
                    return MonetResultSet.this.getRowId(colnum);
                }
            };
            x.readSQL(input, MonetDBtype);
            return x;
        }
        return val;
    }

    @Override
    public <T> T getObject(int i, Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLException("type is null", "M1M05");
        }
        throw new SQLFeatureNotSupportedException("cannot return a Java generic type based on static types from getXXX methods", "0AM34");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    static Class<?> getClassForType(int type) {
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 16: {
                return Boolean.class;
            }
            case -7: 
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2004: {
                return Blob.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(colName), map);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public int getRow() {
        return this.curRow;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String columnName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Short.parseShort(val);
        }
        catch (NumberFormatException e) {
            throw MonetResultSet.newSQLNumberFormatException(e);
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return val;
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnName) throws SQLException {
        return this.getNString(this.findColumn(columnName));
    }

    @Override
    public SQLXML getSQLXML(int i) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String colName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getSQLXML");
    }

    private int getJavaDate(Calendar cal, int columnIndex, int type) throws SQLException {
        char[] monDate;
        int pos;
        int vallen;
        int JdbcType;
        String MonetDBType;
        String monetDate;
        if (cal == null) {
            throw new IllegalArgumentException("No Calendar object given!");
        }
        try {
            monetDate = this.tlp.values[columnIndex - 1];
            if (monetDate == null) {
                this.lastReadWasNull = true;
                return -1;
            }
            this.lastReadWasNull = false;
            MonetDBType = this.types[columnIndex - 1];
            JdbcType = this.JdbcSQLTypes[columnIndex - 1];
            if (JdbcType == 1 || JdbcType == 12 || JdbcType == -1 || JdbcType == 2005) {
                JdbcType = type;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
        TimeZone ptz = cal.getTimeZone();
        if (MonetDBType != null && ("timetz".equals(MonetDBType) || "timestamptz".equals(MonetDBType)) && (vallen = monetDate.length()) >= 6) {
            ptz = TimeZone.getTimeZone("GMT" + monetDate.substring(vallen - 6, vallen));
        }
        java.util.Date pdate = null;
        ParsePosition ppos = new ParsePosition(0);
        switch (JdbcType) {
            case 91: {
                if (this.dateFormat == null) {
                    this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                }
                this.dateFormat.setTimeZone(ptz);
                pdate = this.dateFormat.parse(monetDate, ppos);
                break;
            }
            case 92: {
                if (this.timeFormat == null) {
                    this.timeFormat = new SimpleDateFormat("HH:mm:ss");
                }
                this.timeFormat.setTimeZone(ptz);
                pdate = this.timeFormat.parse(monetDate, ppos);
                break;
            }
            case 93: {
                if (this.timestampFormat == null) {
                    this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
                this.timestampFormat.setTimeZone(ptz);
                pdate = this.timestampFormat.parse(monetDate, ppos);
                break;
            }
            default: {
                this.addWarning("unsupported data type", "01M03");
                cal.clear();
                return 0;
            }
        }
        if (pdate == null) {
            int epos = ppos.getErrorIndex();
            if (epos == -1) {
                this.addWarning("parsing '" + monetDate + "' failed", "01M10");
            } else if (epos < monetDate.length()) {
                this.addWarning("parsing failed, found: '" + monetDate.charAt(epos) + "' in: \"" + monetDate + "\" at pos: " + epos, "01M10");
            } else {
                this.addWarning("parsing failed, expected more data after '" + monetDate + "'", "01M10");
            }
            cal.clear();
            return 0;
        }
        cal.setTime(pdate);
        int nanos = 0;
        if ((JdbcType == 92 || JdbcType == 93) && (pos = ppos.getIndex()) < (monDate = monetDate.toCharArray()).length && monDate[pos] == '.') {
            ++pos;
            try {
                nanos = MonetResultSet.getIntrinsicValue(monDate[pos], pos++);
                int ctr = 1;
                while (pos < monDate.length && monDate[pos] >= '0' && monDate[pos] <= '9') {
                    if (ctr < 9) {
                        nanos *= 10;
                        nanos += MonetResultSet.getIntrinsicValue(monDate[pos], pos);
                    }
                    if (ctr == 2) {
                        cal.set(14, nanos);
                    }
                    ++pos;
                    ++ctr;
                }
                while (ctr++ < 9) {
                    nanos *= 10;
                }
            }
            catch (MCLParseException e) {
                this.addWarning(e.getMessage() + " found: '" + monDate[e.getErrorOffset()] + "' in: \"" + monetDate + "\" at pos: " + e.getErrorOffset(), "01M10");
                cal.clear();
                nanos = 0;
            }
        }
        return nanos;
    }

    private static final int getIntrinsicValue(char c, int pos) throws MCLParseException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new MCLParseException("Expected a digit", pos);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(columnIndex, null);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        int ret;
        try {
            if (this.tlp.values[columnIndex - 1] == null) {
                this.lastReadWasNull = true;
                return null;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        return (ret = this.getJavaDate(cal, columnIndex, 91)) == -1 ? null : new Date(cal.getTimeInMillis());
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName), null);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(columnIndex, null);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        int ret;
        try {
            if (this.tlp.values[columnIndex - 1] == null) {
                this.lastReadWasNull = true;
                return null;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        return (ret = this.getJavaDate(cal, columnIndex, 92)) == -1 ? null : new Time(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName), null);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(columnIndex, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        int nanos;
        try {
            if (this.tlp.values[columnIndex - 1] == null) {
                this.lastReadWasNull = true;
                return null;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        if ((nanos = this.getJavaDate(cal, columnIndex, 93)) == -1) {
            return null;
        }
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        ts.setNanos(nanos);
        return ts;
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), null);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public java.net.URL getURL(int columnIndex) throws SQLException {
        try {
            String val = this.tlp.values[columnIndex - 1];
            if (val == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            try {
                return new java.net.URL(val);
            }
            catch (MalformedURLException e) {
                throw new SQLException(e.getMessage(), "M1M05");
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(columnIndex);
        }
    }

    @Override
    public java.net.URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.header != null && this.header.isClosed()) {
            throw new SQLException("Cannot call on closed ResultSet", "M1M20");
        }
        return this.warnings;
    }

    @Override
    public boolean isAfterLast() {
        return this.curRow == this.tupleCount + 1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.curRow == 0;
    }

    @Override
    public boolean isClosed() {
        return this.header != null && this.header.isClosed();
    }

    @Override
    public boolean isFirst() {
        return this.curRow == 1;
    }

    @Override
    public boolean isLast() {
        return this.curRow == this.tupleCount;
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.curRow + rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void insertRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("moveToCurrentRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("refreshRow");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream xh) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream s) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream s, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnName, InputStream s) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String columnName, InputStream s, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    public void updateNCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    public void updateNCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String columnName, Reader reader, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(int columnIndex, Reader r) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(int columnIndex, Reader r, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnName, Reader r) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String columnName, Reader r, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int columnIndex, NClob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader r) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(int columnIndex, Reader r, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnName, NClob x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnName, Reader r) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String columnName, Reader r, long length) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateNString(int columnIndex, String x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String columnName, String x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public boolean wasNull() {
        return this.lastReadWasNull;
    }

    private void addWarning(String reason, String sqlstate) {
        if (this.warnings == null) {
            this.warnings = new SQLWarning(reason, sqlstate);
        } else {
            this.warnings.setNextWarning(new SQLWarning(reason, sqlstate));
        }
    }

    public static final SQLException newSQLInvalidColumnIndexException(int colIdx) {
        return new SQLException("Invalid Column Index number: " + colIdx, "M1M05");
    }

    private static final SQLException newSQLNumberFormatException(NumberFormatException error) {
        return new SQLException("Could not convert value to a number. " + error.getMessage(), "22003");
    }

    private static final SQLFeatureNotSupportedException newSQLFeatureNotSupportedException(String name) {
        return new SQLFeatureNotSupportedException("Method " + name + " not implemented", "0A000");
    }

    private abstract class rsmdw
    extends MonetWrapper
    implements ResultSetMetaData {
        private rsmdw() {
        }
    }
}

