/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public class MonetClob
implements Clob {
    private StringBuilder buf;

    protected MonetClob(String string) {
        this.buf = new StringBuilder(string);
    }

    private void checkBufIsNotNull() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This MonetClob has been freed", "M1M20");
        }
    }

    @Override
    public void free() {
        this.buf = null;
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method getAsciiStream() not supported", "0A000");
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        this.checkBufIsNotNull();
        return new StringReader(this.buf.toString());
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkBufIsNotNull();
        return new StringReader(this.getSubString(l, (int)l2));
    }

    @Override
    public String getSubString(long l, int n) throws SQLException {
        this.checkBufIsNotNull();
        try {
            return this.buf.substring((int)(l - 1L), (int)(l - 1L + (long)n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SQLException(indexOutOfBoundsException.getMessage());
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkBufIsNotNull();
        return this.buf.length();
    }

    @Override
    public long position(Clob clob, long l) throws SQLException {
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    @Override
    public long position(String string, long l) throws SQLException {
        this.checkBufIsNotNull();
        return this.buf.indexOf(string, (int)(l - 1L));
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method setAsciiStream(long pos) not supported", "0A000");
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method setCharacterStream(long pos) not supported", "0A000");
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 1, string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkBufIsNotNull();
        int n3 = this.buf.length();
        int n4 = Math.min(n3, (int)(l - 1L + (long)n2));
        if (n4 > 0) {
            this.buf.replace((int)(l - 1L), (int)(l + (long)n4), string.substring(n - 1, n + n2));
            return n4;
        }
        return 0;
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.checkBufIsNotNull();
    }

    public String toString() {
        return this.buf == null ? "null" : this.buf.toString();
    }
}

