/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLInput;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import nl.cwi.monetdb.jdbc.MonetBlob;
import nl.cwi.monetdb.jdbc.MonetClob;
import nl.cwi.monetdb.jdbc.MonetConnection;
import nl.cwi.monetdb.jdbc.MonetDriver;
import nl.cwi.monetdb.jdbc.MonetStatement;
import nl.cwi.monetdb.jdbc.MonetWrapper;
import nl.cwi.monetdb.jdbc.types.INET;
import nl.cwi.monetdb.jdbc.types.URL;
import nl.cwi.monetdb.mcl.parser.MCLParseException;
import nl.cwi.monetdb.mcl.parser.TupleLineParser;

public class MonetResultSet
extends MonetWrapper
implements ResultSet,
AutoCloseable {
    private final Statement statement;
    private final MonetConnection.ResultSetResponse header;
    private final String[] columns;
    private final String[] types;
    private final int[] JdbcSQLTypes;
    protected final TupleLineParser tlp;
    protected int curRow = 0;
    protected final int tupleCount;
    private int type = 1003;
    private int concurrency = 1007;
    private SQLWarning warnings;
    private boolean lastReadWasNull = true;
    private int fetchSize;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private SimpleDateFormat timestampFormat;

    MonetResultSet(Statement statement, MonetConnection.ResultSetResponse resultSetResponse) throws SQLException {
        if (statement == null) {
            throw new IllegalArgumentException("Statement may not be null!");
        }
        if (resultSetResponse == null) {
            throw new IllegalArgumentException("ResultSetResponse may not be null!");
        }
        this.statement = statement;
        this.header = resultSetResponse;
        this.type = resultSetResponse.getRSType();
        this.concurrency = resultSetResponse.getRSConcur();
        this.fetchSize = resultSetResponse.getCacheSize();
        this.columns = resultSetResponse.getNames();
        this.types = resultSetResponse.getTypes();
        this.tupleCount = resultSetResponse.tuplecount;
        this.tlp = new TupleLineParser(this.columns.length);
        this.JdbcSQLTypes = new int[this.types.length];
        this.populateJdbcSQLtypesArray();
    }

    MonetResultSet(Statement statement, String[] stringArray, String[] stringArray2, int n) throws IllegalArgumentException {
        if (statement == null) {
            throw new IllegalArgumentException("Statement may not be null!");
        }
        if (stringArray == null || stringArray2 == null) {
            throw new IllegalArgumentException("One of the given arguments is null!");
        }
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("Given arguments are not the same size!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative rowcount not allowed!");
        }
        this.statement = statement;
        this.header = null;
        this.fetchSize = 0;
        this.columns = stringArray;
        this.types = stringArray2;
        this.tupleCount = n;
        this.tlp = new TupleLineParser(stringArray.length);
        this.JdbcSQLTypes = new int[stringArray2.length];
        this.populateJdbcSQLtypesArray();
    }

    private void populateJdbcSQLtypesArray() {
        MonetConnection monetConnection = null;
        try {
            monetConnection = (MonetConnection)this.statement.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (int i = 0; i < this.types.length; ++i) {
            int n = MonetDriver.getJavaType(this.types[i]);
            if (n == 2005) {
                if (monetConnection != null && monetConnection.mapClobAsVarChar()) {
                    n = 12;
                }
            } else if (n == 2004 && monetConnection != null && monetConnection.mapBlobAsVarBinary()) {
                n = -3;
            }
            this.JdbcSQLTypes[i] = n;
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        String string;
        this.checkNotClosed();
        if (n != this.curRow + 1 && this.type == 1003) {
            throw new SQLException("(Absolute) positioning not allowed on forward  only result sets!", "M1M05");
        }
        if (n < 0) {
            n = this.tupleCount + n + 1;
        }
        if (n < 0) {
            n = 0;
        } else if (n > this.tupleCount + 1) {
            n = this.tupleCount + 1;
        }
        this.curRow = n;
        String string2 = string = this.header != null ? this.header.getLine(n - 1) : null;
        if (string == null) {
            return false;
        }
        try {
            this.tlp.parse(string);
        }
        catch (MCLParseException mCLParseException) {
            throw new SQLException(mCLParseException.getMessage(), "M0M10");
        }
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this.absolute(this.tupleCount + 1);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void close() {
        if (this.header != null && !this.header.isClosed()) {
            this.header.close();
        }
        if (this.statement instanceof MonetStatement) {
            ((MonetStatement)this.statement).closeIfCompletion();
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        this.checkNotClosed();
        if (string != null) {
            int n;
            int n2 = this.columns.length;
            for (n = 0; n < n2; ++n) {
                if (!string.equals(this.columns[n])) continue;
                return n + 1;
            }
            for (n = 0; n < n2; ++n) {
                if (!string.equalsIgnoreCase(this.columns[n])) continue;
                return n + 1;
            }
        }
        throw new SQLException("No such column name: " + string, "M1M05");
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getArray");
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getAsciiStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getUnicodeStream");
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkNotClosed();
        try {
            switch (this.JdbcSQLTypes[n - 1]) {
                case 2004: {
                    Blob blob = this.getBlob(n);
                    if (blob == null) {
                        return null;
                    }
                    return blob.getBinaryStream();
                }
                case -4: 
                case -3: 
                case -2: {
                    byte[] byArray = this.getBytes(n);
                    if (byArray == null) {
                        return null;
                    }
                    return new ByteArrayInputStream(byArray);
                }
            }
            throw new SQLException("Cannot operate on " + this.types[n - 1] + " type", "M1M05");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new StringReader(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return MonetBlob.create(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new MonetClob(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getNClob");
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            BigDecimal bigDecimal = new BigDecimal(string);
            bigDecimal.setScale(n2);
            return bigDecimal;
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return false;
            }
            this.lastReadWasNull = false;
            if ("false".equalsIgnoreCase(string) || "0".equals(string)) {
                return false;
            }
            if ("true".equalsIgnoreCase(string) || "1".equals(string)) {
                return true;
            }
            switch (this.JdbcSQLTypes[n - 1]) {
                case -1: 
                case 1: 
                case 12: 
                case 16: 
                case 2005: {
                    return Boolean.parseBoolean(string);
                }
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    return this.getInt(n) != 0;
                }
                case -5: {
                    return this.getLong(n) != 0L;
                }
                case 6: 
                case 7: 
                case 8: {
                    return this.getDouble(n) != 0.0;
                }
                case 2: 
                case 3: {
                    return this.getBigDecimal(n).compareTo(BigDecimal.ZERO) != 0;
                }
            }
            throw new SQLException("Conversion from " + this.types[n - 1] + " to boolean type not supported", "M1M05");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Byte.parseByte(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            switch (this.JdbcSQLTypes[n - 1]) {
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    int n2 = string.length() / 2;
                    byte[] byArray = new byte[n2];
                    for (int i = 0; i < n2; ++i) {
                        int n3 = i * 2;
                        byArray[i] = (byte)Integer.parseInt(string.substring(n3, n3 + 2), 16);
                    }
                    return byArray;
                }
            }
            throw new SQLException("Cannot operate on " + this.types[n - 1] + " type", "M1M05");
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public int getConcurrency() {
        return this.concurrency;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("Positioned updates not supported for this cursor (" + (this.header != null ? Integer.valueOf(this.header.id) : "") + ")", "0AM21");
    }

    @Override
    public double getDouble(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0.0;
            }
            this.lastReadWasNull = false;
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.getStatement().getConnection().getHoldability();
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1000: {
                break;
            }
            case 1001: 
            case 1002: {
                throw new SQLException("Not supported direction " + n, "0A000");
            }
            default: {
                throw new SQLException("Illegal direction: " + n, "M1M05");
            }
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Illegal fetch size value: " + n, "M1M05");
        }
        this.fetchSize = n;
    }

    @Override
    public float getFloat(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0.0f;
            }
            this.lastReadWasNull = false;
            return Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        this.checkNotClosed();
        String string = "";
        try {
            string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            int n2;
            if ("oid".equals(this.types[n - 1]) && (n2 = string.length()) > 2 && string.endsWith("@0")) {
                try {
                    return Integer.parseInt(string.substring(0, n2 - 2));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw MonetResultSet.newSQLNumberFormatException(numberFormatException2);
                }
            }
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        this.checkNotClosed();
        String string = "";
        try {
            string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0L;
            }
            this.lastReadWasNull = false;
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            int n2;
            if ("oid".equals(this.types[n - 1]) && (n2 = string.length()) > 2 && string.endsWith("@0")) {
                try {
                    return Long.parseLong(string.substring(0, n2 - 2));
                }
                catch (NumberFormatException numberFormatException2) {
                    throw MonetResultSet.newSQLNumberFormatException(numberFormatException2);
                }
            }
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new rsmdw(){
            private final int array_size;
            private final boolean[] _is_fetched;
            private final int[] _precision;
            private final int[] _scale;
            private final int[] _isNullable;
            private final boolean[] _isAutoincrement;
            private Connection conn;
            private DatabaseMetaData dbmd;
            {
                this.array_size = MonetResultSet.this.columns.length + 1;
                this._is_fetched = new boolean[this.array_size];
                this._precision = new int[this.array_size];
                this._scale = new int[this.array_size];
                this._isNullable = new int[this.array_size];
                this._isAutoincrement = new boolean[this.array_size];
                this.conn = null;
                this.dbmd = null;
            }

            private void checkColumnIndexValidity(int n) throws SQLDataException {
                if (n < 1 || n > MonetResultSet.this.columns.length) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            private void fetchColumnInfo(int n) throws SQLException {
                String string;
                String string2;
                this.checkColumnIndexValidity(n);
                this._is_fetched[n] = true;
                this._precision[n] = 0;
                this._scale[n] = 0;
                this._isNullable[n] = 2;
                this._isAutoincrement[n] = false;
                String string3 = this.getSchemaName(n);
                if (!(string3 == null || string3.isEmpty() || (string2 = this.getTableName(n)) == null || string2.isEmpty() || (string = this.getColumnName(n)) == null || string.isEmpty())) {
                    ResultSet resultSet;
                    if (this.conn == null) {
                        this.conn = MonetResultSet.this.getStatement().getConnection();
                    }
                    if (this.conn != null && this.dbmd == null) {
                        this.dbmd = this.conn.getMetaData();
                    }
                    if (this.dbmd != null && (resultSet = this.dbmd.getColumns(null, string3, string2, string)) != null) {
                        if (resultSet.next()) {
                            this._precision[n] = resultSet.getInt(7);
                            this._scale[n] = resultSet.getInt(9);
                            this._isNullable[n] = resultSet.getInt(11);
                            String string4 = resultSet.getString(23);
                            if (string4 != null && "YES".equals(string4)) {
                                this._isAutoincrement[n] = true;
                            }
                        }
                        resultSet.close();
                    }
                }
            }

            @Override
            public int getColumnCount() {
                return MonetResultSet.this.columns.length;
            }

            @Override
            public boolean isAutoIncrement(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    if (!this._is_fetched[n]) {
                        this.fetchColumnInfo(n);
                    }
                    return this._isAutoincrement[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public boolean isCaseSensitive(int n) throws SQLException {
                switch (this.getColumnType(n)) {
                    case -1: 
                    case 1: 
                    case 2005: {
                        return true;
                    }
                    case 12: {
                        String string = this.getColumnTypeName(n);
                        return string == null || string.length() != 4 || !"inet".equals(string) && !"uuid".equals(string);
                    }
                }
                return false;
            }

            @Override
            public boolean isSearchable(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return true;
            }

            @Override
            public boolean isCurrency(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return false;
            }

            @Override
            public boolean isSigned(int n) throws SQLException {
                switch (this.getColumnType(n)) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                    case -5: {
                        String string = this.getColumnTypeName(n);
                        return string == null || string.length() != 3 || !"oid".equals(string) && !"ptr".equals(string);
                    }
                }
                return false;
            }

            @Override
            public int getColumnDisplaySize(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                int n2 = 1;
                if (MonetResultSet.this.header != null) {
                    try {
                        n2 = MonetResultSet.this.header.getColumnLengths()[n - 1];
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return n2;
            }

            @Override
            public String getSchemaName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                if (MonetResultSet.this.header != null) {
                    try {
                        String string = MonetResultSet.this.header.getTableNames()[n - 1];
                        if (string != null) {
                            int n2 = string.indexOf(46);
                            return n2 >= 0 ? string.substring(0, n2) : "";
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return "";
            }

            @Override
            public String getTableName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                if (MonetResultSet.this.header != null) {
                    try {
                        String string = MonetResultSet.this.header.getTableNames()[n - 1];
                        if (string != null) {
                            int n2 = string.indexOf(46);
                            return n2 >= 0 ? string.substring(n2 + 1) : string;
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                    }
                }
                return "";
            }

            @Override
            public int getPrecision(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    if (!this._is_fetched[n]) {
                        this.fetchColumnInfo(n);
                    }
                    if (this._precision[n] == 0) {
                        switch (this.getColumnType(n)) {
                            case -1: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 12: 
                            case 2004: 
                            case 2005: {
                                this._precision[n] = this.getColumnDisplaySize(n);
                                break;
                            }
                            case -6: {
                                this._precision[n] = 3;
                                break;
                            }
                            case 5: {
                                this._precision[n] = 5;
                                break;
                            }
                            case 4: {
                                this._precision[n] = 10;
                                break;
                            }
                            case -5: {
                                this._precision[n] = 19;
                                break;
                            }
                            case 7: {
                                this._precision[n] = 7;
                                break;
                            }
                            case 6: 
                            case 8: {
                                this._precision[n] = 15;
                                break;
                            }
                            case -7: {
                                this._precision[n] = 1;
                                break;
                            }
                            case 16: {
                                this._precision[n] = 5;
                                break;
                            }
                            case 91: {
                                this._precision[n] = 10;
                                break;
                            }
                            case 92: {
                                this._precision[n] = 8;
                                break;
                            }
                            case 93: {
                                this._precision[n] = 19;
                                break;
                            }
                            default: {
                                this._precision[n] = 30;
                            }
                        }
                    }
                    return this._precision[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public int getScale(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    if (!this._is_fetched[n]) {
                        this.fetchColumnInfo(n);
                    }
                    return this._scale[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public int isNullable(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    if (!this._is_fetched[n]) {
                        this.fetchColumnInfo(n);
                    }
                    return this._isNullable[n];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getCatalogName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return null;
            }

            @Override
            public boolean isReadOnly(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return true;
            }

            @Override
            public boolean isWritable(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return false;
            }

            @Override
            public boolean isDefinitelyWritable(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                return false;
            }

            @Override
            public String getColumnClassName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                if (this.conn == null) {
                    this.conn = MonetResultSet.this.getStatement().getConnection();
                }
                try {
                    Map<String, Class<?>> map;
                    String string = MonetResultSet.this.types[n - 1];
                    Class<?> clazz = null;
                    if (this.conn != null && (map = this.conn.getTypeMap()) != null && map.containsKey(string)) {
                        clazz = map.get(string);
                    }
                    if (clazz == null) {
                        clazz = MonetResultSet.getClassForType(MonetResultSet.this.JdbcSQLTypes[n - 1]);
                    }
                    if (clazz != null) {
                        return clazz.getName();
                    }
                    throw new SQLException("column type mapping null: " + string, "M0M03");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getColumnLabel(int n) throws SQLException {
                return this.getColumnName(n);
            }

            @Override
            public String getColumnName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    return MonetResultSet.this.columns[n - 1];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public int getColumnType(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    return MonetResultSet.this.JdbcSQLTypes[n - 1];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }

            @Override
            public String getColumnTypeName(int n) throws SQLException {
                this.checkColumnIndexValidity(n);
                try {
                    return MonetResultSet.this.types[n - 1];
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw MonetResultSet.newSQLInvalidColumnIndexException(n);
                }
            }
        };
    }

    @Override
    public Object getObject(int n) throws SQLException {
        int n2;
        String string;
        this.checkNotClosed();
        try {
            string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            n2 = this.JdbcSQLTypes[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
        switch (n2) {
            case -7: 
            case -6: 
            case 5: {
                try {
                    return Short.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 4: {
                try {
                    return Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case -5: {
                try {
                    return Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 6: 
            case 8: {
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 7: {
                try {
                    return Float.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 2: 
            case 3: {
                try {
                    return new BigDecimal(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
            }
            case 16: {
                return Boolean.valueOf(string);
            }
            case 12: {
                String string2 = this.types[n - 1];
                switch (string2.length()) {
                    case 3: {
                        if (!"url".equals(string2)) break;
                        try {
                            URL uRL = new URL();
                            uRL.fromString(string);
                            return uRL;
                        }
                        catch (MalformedURLException malformedURLException) {
                            return string;
                        }
                        catch (Exception exception) {
                            return string;
                        }
                    }
                    case 4: {
                        if ("inet".equals(string2)) {
                            try {
                                INET iNET = new INET();
                                iNET.fromString(string);
                                return iNET;
                            }
                            catch (Exception exception) {
                                return string;
                            }
                        }
                        if (!"uuid".equals(string2)) break;
                        try {
                            return UUID.fromString(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return string;
                        }
                    }
                }
                return string;
            }
            case -1: 
            case 1: {
                return string;
            }
            case 2005: {
                return new MonetClob(string);
            }
            case 2004: {
                return MonetBlob.create(string);
            }
            case 91: {
                return this.getDate(n, null);
            }
            case 92: {
                return this.getTime(n, null);
            }
            case 93: {
                return this.getTimestamp(n, null);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes(n);
            }
        }
        return this.getObject(n, this.getStatement().getConnection().getTypeMap());
    }

    private boolean classImplementsSQLData(Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] != SQLData.class) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        String string;
        String string2;
        this.checkNotClosed();
        try {
            string2 = this.tlp.values[n - 1];
            if (string2 == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            string = this.types[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
        Class<?> clazz = null;
        if (map != null && map.containsKey(string)) {
            clazz = map.get(string);
        }
        if (clazz == null) {
            clazz = MonetResultSet.getClassForType(this.JdbcSQLTypes[n - 1]);
        }
        if (clazz == null || clazz == String.class) {
            return string2;
        }
        if (clazz == BigDecimal.class) {
            return this.getBigDecimal(n);
        }
        if (clazz == Boolean.class) {
            return this.getBoolean(n);
        }
        if (clazz == Short.class) {
            return this.getShort(n);
        }
        if (clazz == Integer.class) {
            return this.getInt(n);
        }
        if (clazz == Long.class) {
            return this.getLong(n);
        }
        if (clazz == Float.class) {
            return Float.valueOf(this.getFloat(n));
        }
        if (clazz == Double.class) {
            return this.getDouble(n);
        }
        if (clazz == byte[].class) {
            return this.getBytes(n);
        }
        if (clazz == Date.class) {
            return this.getDate(n, null);
        }
        if (clazz == Time.class) {
            return this.getTime(n, null);
        }
        if (clazz == Timestamp.class) {
            return this.getTimestamp(n, null);
        }
        if (clazz == Clob.class) {
            return this.getClob(n);
        }
        if (clazz == Blob.class) {
            return this.getBlob(n);
        }
        if (this.classImplementsSQLData(clazz)) {
            SQLData sQLData;
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                sQLData = (SQLData)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SQLException(noSuchMethodException.getMessage(), "M0M27");
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException(instantiationException.getMessage(), "M0M27");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(illegalAccessException.getMessage(), "M0M27");
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException(invocationTargetException.getMessage(), "M0M27");
            }
            catch (SecurityException securityException) {
                throw new SQLException(securityException.getMessage(), "M0M27");
            }
            final int n2 = n;
            final boolean bl = this.wasNull();
            SQLInput sQLInput = new SQLInput(){

                @Override
                public String readString() throws SQLException {
                    return MonetResultSet.this.getString(n2);
                }

                @Override
                public boolean readBoolean() throws SQLException {
                    return MonetResultSet.this.getBoolean(n2);
                }

                @Override
                public byte readByte() throws SQLException {
                    return MonetResultSet.this.getByte(n2);
                }

                @Override
                public short readShort() throws SQLException {
                    return MonetResultSet.this.getShort(n2);
                }

                @Override
                public int readInt() throws SQLException {
                    return MonetResultSet.this.getInt(n2);
                }

                @Override
                public long readLong() throws SQLException {
                    return MonetResultSet.this.getLong(n2);
                }

                @Override
                public float readFloat() throws SQLException {
                    return MonetResultSet.this.getFloat(n2);
                }

                @Override
                public double readDouble() throws SQLException {
                    return MonetResultSet.this.getDouble(n2);
                }

                @Override
                public BigDecimal readBigDecimal() throws SQLException {
                    return MonetResultSet.this.getBigDecimal(n2);
                }

                @Override
                public byte[] readBytes() throws SQLException {
                    return MonetResultSet.this.getBytes(n2);
                }

                @Override
                public Date readDate() throws SQLException {
                    return MonetResultSet.this.getDate(n2, null);
                }

                @Override
                public Time readTime() throws SQLException {
                    return MonetResultSet.this.getTime(n2, null);
                }

                @Override
                public Timestamp readTimestamp() throws SQLException {
                    return MonetResultSet.this.getTimestamp(n2, null);
                }

                @Override
                public Reader readCharacterStream() throws SQLException {
                    return MonetResultSet.this.getCharacterStream(n2);
                }

                @Override
                public InputStream readAsciiStream() throws SQLException {
                    return MonetResultSet.this.getAsciiStream(n2);
                }

                @Override
                public InputStream readBinaryStream() throws SQLException {
                    return MonetResultSet.this.getBinaryStream(n2);
                }

                @Override
                public Object readObject() throws SQLException {
                    return MonetResultSet.this.getObject(n2);
                }

                @Override
                public Ref readRef() throws SQLException {
                    return MonetResultSet.this.getRef(n2);
                }

                @Override
                public Blob readBlob() throws SQLException {
                    return MonetResultSet.this.getBlob(n2);
                }

                @Override
                public Clob readClob() throws SQLException {
                    return MonetResultSet.this.getClob(n2);
                }

                @Override
                public Array readArray() throws SQLException {
                    return MonetResultSet.this.getArray(n2);
                }

                @Override
                public boolean wasNull() throws SQLException {
                    return bl;
                }

                @Override
                public java.net.URL readURL() throws SQLException {
                    return MonetResultSet.this.getURL(n2);
                }

                @Override
                public NClob readNClob() throws SQLException {
                    return MonetResultSet.this.getNClob(n2);
                }

                @Override
                public String readNString() throws SQLException {
                    return MonetResultSet.this.getNString(n2);
                }

                @Override
                public SQLXML readSQLXML() throws SQLException {
                    return MonetResultSet.this.getSQLXML(n2);
                }

                @Override
                public RowId readRowId() throws SQLException {
                    return MonetResultSet.this.getRowId(n2);
                }
            };
            sQLData.readSQL(sQLInput, string);
            return sQLData;
        }
        return string2;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        this.checkNotClosed();
        if (clazz == null) {
            throw new SQLException("type is null", "M1M05");
        }
        throw new SQLFeatureNotSupportedException("cannot return a Java generic type based on static types from getXXX methods", "0AM34");
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    static Class<?> getClassForType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
            case 16: {
                return Boolean.class;
            }
            case -7: 
            case -6: 
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return byte[].class;
            }
            case 91: {
                return Date.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 2005: {
                return Clob.class;
            }
            case 2004: {
                return Blob.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRef");
    }

    @Override
    public int getRow() {
        return this.curRow;
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getRowId");
    }

    @Override
    public short getShort(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return 0;
            }
            this.lastReadWasNull = false;
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw MonetResultSet.newSQLNumberFormatException(numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public String getString(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getSQLXML");
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("getSQLXML");
    }

    private int getJavaDate(Calendar calendar, int n, int n2) throws SQLException {
        char[] cArray;
        int n3;
        int n4;
        int n5;
        String string;
        String string2;
        this.checkNotClosed();
        if (calendar == null) {
            throw new IllegalArgumentException("No Calendar object given!");
        }
        try {
            string2 = this.tlp.values[n - 1];
            if (string2 == null) {
                this.lastReadWasNull = true;
                return -1;
            }
            this.lastReadWasNull = false;
            string = this.types[n - 1];
            n5 = this.JdbcSQLTypes[n - 1];
            if (n5 == 1 || n5 == 12 || n5 == -1 || n5 == 2005) {
                n5 = n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
        TimeZone timeZone = calendar.getTimeZone();
        if (string != null && ("timetz".equals(string) || "timestamptz".equals(string)) && (n4 = string2.length()) >= 6) {
            timeZone = TimeZone.getTimeZone("GMT" + string2.substring(n4 - 6, n4));
        }
        java.util.Date date = null;
        ParsePosition parsePosition = new ParsePosition(0);
        switch (n5) {
            case 91: {
                if (this.dateFormat == null) {
                    this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                }
                this.dateFormat.setTimeZone(timeZone);
                date = this.dateFormat.parse(string2, parsePosition);
                break;
            }
            case 92: {
                if (this.timeFormat == null) {
                    this.timeFormat = new SimpleDateFormat("HH:mm:ss");
                }
                this.timeFormat.setTimeZone(timeZone);
                date = this.timeFormat.parse(string2, parsePosition);
                break;
            }
            case 93: {
                if (this.timestampFormat == null) {
                    this.timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                }
                this.timestampFormat.setTimeZone(timeZone);
                date = this.timestampFormat.parse(string2, parsePosition);
                break;
            }
            default: {
                this.addWarning("unsupported data type", "01M03");
                calendar.clear();
                return 0;
            }
        }
        if (date == null) {
            int n6 = parsePosition.getErrorIndex();
            if (n6 == -1) {
                this.addWarning("parsing '" + string2 + "' failed", "01M10");
            } else if (n6 < string2.length()) {
                this.addWarning("parsing failed, found: '" + string2.charAt(n6) + "' in: \"" + string2 + "\" at pos: " + n6, "01M10");
            } else {
                this.addWarning("parsing failed, expected more data after '" + string2 + "'", "01M10");
            }
            calendar.clear();
            return 0;
        }
        calendar.setTime(date);
        int n7 = 0;
        if ((n5 == 92 || n5 == 93) && (n3 = parsePosition.getIndex()) < (cArray = string2.toCharArray()).length && cArray[n3] == '.') {
            ++n3;
            try {
                n7 = MonetResultSet.getIntrinsicValue(cArray[n3], n3++);
                int n8 = 1;
                while (n3 < cArray.length && cArray[n3] >= '0' && cArray[n3] <= '9') {
                    if (n8 < 9) {
                        n7 *= 10;
                        n7 += MonetResultSet.getIntrinsicValue(cArray[n3], n3);
                    }
                    if (n8 == 2) {
                        calendar.set(14, n7);
                    }
                    ++n3;
                    ++n8;
                }
                while (n8++ < 9) {
                    n7 *= 10;
                }
            }
            catch (MCLParseException mCLParseException) {
                this.addWarning(mCLParseException.getMessage() + " found: '" + cArray[mCLParseException.getErrorOffset()] + "' in: \"" + string2 + "\" at pos: " + mCLParseException.getErrorOffset(), "01M10");
                calendar.clear();
                n7 = 0;
            }
        }
        return n7;
    }

    private static final int getIntrinsicValue(char c, int n) throws MCLParseException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new MCLParseException("Expected a digit", n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDate(n, null);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkNotClosed();
        try {
            int n2;
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            if (calendar == null) {
                if (string.contains("-") && !string.contains(":") && !string.contains("+")) {
                    return Date.valueOf(string);
                }
                calendar = Calendar.getInstance();
            }
            return (n2 = this.getJavaDate(calendar, n, 91)) == -1 ? null : new Date(calendar.getTimeInMillis());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLDataException("Could not convert value to a Date. Expected JDBC date escape format yyyy-[m]m-[d]d. " + illegalArgumentException.getMessage(), "22007");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string), null);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTime(n, null);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkNotClosed();
        try {
            int n2;
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            if (calendar == null) {
                if (!string.contains("-") && string.contains(":") && !string.contains("+")) {
                    return Time.valueOf(string);
                }
                calendar = Calendar.getInstance();
            }
            return (n2 = this.getJavaDate(calendar, n, 92)) == -1 ? null : new Time(calendar.getTimeInMillis());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLDataException("Could not convert value to a Time. Expected JDBC time escape format hh:mm:ss. " + illegalArgumentException.getMessage(), "22007");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string), null);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, null);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkNotClosed();
        try {
            int n2;
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            if (calendar == null) {
                if (string.contains("-") && string.contains(":") && !string.contains("+")) {
                    return Timestamp.valueOf(string);
                }
                calendar = Calendar.getInstance();
            }
            if ((n2 = this.getJavaDate(calendar, n, 93)) == -1) {
                return null;
            }
            Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
            timestamp.setNanos(n2);
            return timestamp;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLDataException("Could not convert value to a Timestamp. Expected JDBC time escape format yyyy-[m]m-[d]d hh:mm:ss[.f...]. " + illegalArgumentException.getMessage(), "22007");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public java.net.URL getURL(int n) throws SQLException {
        this.checkNotClosed();
        try {
            String string = this.tlp.values[n - 1];
            if (string == null) {
                this.lastReadWasNull = true;
                return null;
            }
            this.lastReadWasNull = false;
            try {
                return new java.net.URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new SQLException(malformedURLException.getMessage(), "M1M05");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw MonetResultSet.newSQLInvalidColumnIndexException(n);
        }
    }

    @Override
    public java.net.URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return this.warnings;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return this.curRow == this.tupleCount + 1;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.curRow == 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.header != null && this.header.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.curRow == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return this.curRow == this.tupleCount;
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    public boolean relative(int n) throws SQLException {
        return this.absolute(this.curRow + n);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkNotClosed();
        return false;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("cancelRowUpdates");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("deleteRow");
    }

    @Override
    public void insertRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("insertRow");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("moveToCurrentRow");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("moveToInsertRow");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("refreshRow");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateArray");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateAsciiStream");
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBigDecimal");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBinaryStream");
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBlob");
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBoolean");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateByte");
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateBytes");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    public void updateNCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    public void updateNCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNCharacterStream");
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateClob");
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNClob");
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDate");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateDouble");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateFloat");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateInt");
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateLong");
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNull");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateObject");
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRef");
    }

    @Override
    public void updateRow() throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRow");
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateRowId");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateShort");
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateString");
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateNString");
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateSQLXML");
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTime");
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw MonetResultSet.newSQLFeatureNotSupportedException("updateTimestamp");
    }

    @Override
    public boolean wasNull() {
        return this.lastReadWasNull;
    }

    private void addWarning(String string, String string2) {
        SQLWarning sQLWarning = new SQLWarning(string, string2);
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("ResultSet is closed", "M1M20");
        }
    }

    public static final SQLDataException newSQLInvalidColumnIndexException(int n) {
        return new SQLDataException("Invalid Column Index number: " + n, "22010");
    }

    private static final SQLDataException newSQLNumberFormatException(NumberFormatException numberFormatException) {
        return new SQLDataException("Could not convert value to a number. " + numberFormatException.getMessage(), "22003");
    }

    private static final SQLFeatureNotSupportedException newSQLFeatureNotSupportedException(String string) {
        return new SQLFeatureNotSupportedException("Method " + string + " not implemented", "0A000");
    }

    private abstract class rsmdw
    extends MonetWrapper
    implements ResultSetMetaData {
        private rsmdw() {
        }
    }
}

