/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.mcl.parser;

import nl.cwi.monetdb.mcl.parser.MCLParseException;
import nl.cwi.monetdb.mcl.parser.MCLParser;

public class HeaderLineParser
extends MCLParser {
    private int type;
    public static final int NAME = 1;
    public static final int LENGTH = 2;
    public static final int TABLE = 3;
    public static final int TYPE = 4;

    public HeaderLineParser(int n) {
        super(n);
    }

    @Override
    public int parse(String string) throws MCLParseException {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        block9: for (int i = n - 1; i >= 0; --i) {
            switch (cArray[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!bl) {
                        n = i - 1;
                        continue block9;
                    }
                    n2 = i + 1;
                    continue block9;
                }
                case '#': {
                    bl2 = true;
                    if (n2 == 0) {
                        n2 = i + 1;
                    }
                    i = 0;
                    continue block9;
                }
                default: {
                    bl = true;
                    n2 = 0;
                }
            }
        }
        if (!bl2) {
            throw new MCLParseException("invalid header, no header name found", n2);
        }
        switch (cArray[n2]) {
            case 'n': {
                if (n - n2 != 4 || !string.regionMatches(n2 + 1, "name", 1, 3)) break;
                this.getValues(cArray, 2, n2 - 3);
                this.type = 1;
                break;
            }
            case 'l': {
                if (n - n2 != 6 || !string.regionMatches(n2 + 1, "length", 1, 5)) break;
                this.getIntValues(cArray, 2, n2 - 3);
                this.type = 2;
                break;
            }
            case 't': {
                if (n - n2 == 4 && string.regionMatches(n2 + 1, "type", 1, 3)) {
                    this.getValues(cArray, 2, n2 - 3);
                    this.type = 4;
                    break;
                }
                if (n - n2 != 10 || !string.regionMatches(n2 + 1, "table_name", 1, 9)) break;
                this.getValues(cArray, 2, n2 - 3);
                this.type = 3;
                break;
            }
            default: {
                throw new MCLParseException("unknown header: " + new String(cArray, n2, n - n2));
            }
        }
        this.reset();
        return this.type;
    }

    private final void getValues(char[] cArray, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        block5: for (int i = n; i < n2; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    bl2 = !bl2;
                    continue block5;
                }
                case '\"': {
                    if (!bl) {
                        bl = true;
                    } else if (!bl2) {
                        bl = false;
                    }
                    bl2 = false;
                    continue block5;
                }
                case ',': {
                    if (!bl && cArray[i + 1] == '\t') {
                        if (cArray[n] == '\"') {
                            ++n;
                        }
                        if (n3 < this.values.length) {
                            this.values[n3++] = new String(cArray, n, i - (cArray[i - 1] == '\"' ? 1 : 0) - n);
                        }
                        n = ++i + 1;
                    }
                    bl2 = false;
                    continue block5;
                }
                default: {
                    bl2 = false;
                }
            }
        }
        if (cArray[n] == '\"') {
            ++n;
        }
        if (n3 < this.values.length) {
            this.values[n3] = new String(cArray, n, n2 - (cArray[n2 - 1] == '\"' ? 1 : 0) - n);
        }
    }

    private final void getIntValues(char[] cArray, int n, int n2) throws MCLParseException {
        int n3 = 0;
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] == ',' && cArray[i + 1] == '\t') {
                this.intValues[n3++] = n4;
                n4 = 0;
                n = i++;
                continue;
            }
            if (cArray[i] >= '0' && cArray[i] <= '9') {
                n4 *= 10;
                n4 += cArray[i] - 48;
                continue;
            }
            throw new MCLParseException("expected a digit in " + new String(cArray) + " at " + i);
        }
        this.intValues[n3] = n4;
    }
}

