/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;

public final class MonetBlob
implements Blob {
    private byte[] buf;

    protected MonetBlob(byte[] byArray) {
        this.buf = byArray;
    }

    static MonetBlob create(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = 2 * i;
            byArray[i] = (byte)Integer.parseInt(string.substring(n2, n2 + 2), 16);
        }
        return new MonetBlob(byArray);
    }

    private final void checkBufIsNotNull() throws SQLException {
        if (this.buf == null) {
            throw new SQLException("This MonetBlob has been freed", "M1M20");
        }
    }

    @Override
    public void free() throws SQLException {
        this.buf = null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkBufIsNotNull();
        return new ByteArrayInputStream(this.buf);
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.checkBufIsNotNull();
        if (l < 1L || l > (long)this.buf.length) {
            throw new SQLException("Invalid pos value: " + l, "M1M05");
        }
        if (l2 < 0L || l - 1L + l2 > (long)this.buf.length) {
            throw new SQLException("Invalid length value: " + l2, "M1M05");
        }
        return new ByteArrayInputStream(this.buf, (int)l - 1, (int)l2);
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        this.checkBufIsNotNull();
        if (l < 1L || l > (long)this.buf.length) {
            throw new SQLException("Invalid pos value: " + l, "M1M05");
        }
        if (n < 0 || l - 1L + (long)n > (long)this.buf.length) {
            throw new SQLException("Invalid length value: " + n, "M1M05");
        }
        try {
            return Arrays.copyOfRange(this.buf, (int)l - 1, (int)l - 1 + n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SQLException(indexOutOfBoundsException.getMessage(), "M0M10");
        }
    }

    @Override
    public long length() throws SQLException {
        this.checkBufIsNotNull();
        return this.buf.length;
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        if (blob == null) {
            throw new SQLException("Missing pattern object", "M1M05");
        }
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        this.checkBufIsNotNull();
        if (byArray == null) {
            throw new SQLException("Missing pattern object", "M1M05");
        }
        if (l < 1L || l > (long)this.buf.length) {
            throw new SQLException("Invalid start value: " + l, "M1M05");
        }
        try {
            int n = byArray.length;
            int n2 = this.buf.length;
            for (int i = (int)(l - 1L); i < n2 - n; ++i) {
                int n3;
                for (n3 = 0; n3 < n && this.buf[i + n3] == byArray[n3]; ++n3) {
                }
                if (n3 != n) continue;
                return i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SQLException(indexOutOfBoundsException.getMessage(), "M0M10");
        }
        return -1L;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method setBinaryStream(long pos) not supported", "0A000");
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw new SQLException("Missing bytes[] object", "M1M05");
        }
        return this.setBytes(l, byArray, 1, byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        this.checkBufIsNotNull();
        if (byArray == null) {
            throw new SQLException("Missing bytes[] object", "M1M05");
        }
        if (l < 1L || l > Integer.MAX_VALUE) {
            throw new SQLException("Invalid pos value: " + l, "M1M05");
        }
        if (n2 < 0 || l + (long)n2 > (long)this.buf.length) {
            throw new SQLException("Invalid len value: " + n2, "M1M05");
        }
        if (n < 0 || n > byArray.length) {
            throw new SQLException("Invalid offset value: " + n, "M1M05");
        }
        try {
            for (int i = (int)l; i < n2; ++i) {
                this.buf[i] = byArray[n - 1 + i];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SQLException(indexOutOfBoundsException.getMessage(), "M0M10");
        }
        return n2;
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.checkBufIsNotNull();
        if (l < 0L || l > (long)this.buf.length) {
            throw new SQLException("Invalid len value: " + l, "M1M05");
        }
        if ((long)this.buf.length > l) {
            byte[] byArray = new byte[(int)l];
            int n = 0;
            while ((long)n < l) {
                byArray[n] = this.buf[n];
                ++n;
            }
            this.buf = byArray;
        }
    }
}

